/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbUtil;
import org.lightcouch.ReplicatorDocument;
import org.lightcouch.Response;
import org.lightcouch.URIBuilder;

public class Replicator {
    private String replicatorDB;
    private String userCtxName;
    private String[] userCtxRoles;
    private CouchDbClientBase dbc;
    private ReplicatorDocument replicatorDoc;
    private URI dbURI;

    public Replicator(CouchDbClientBase dbc) {
        this.dbc = dbc;
        this.replicatorDoc = new ReplicatorDocument();
        this.replicatorDB = "_replicator";
        this.userCtxRoles = new String[0];
        this.dbURI = URIBuilder.buildUri(dbc.getBaseUri()).path(this.replicatorDB).path("/").build();
    }

    public Response save() {
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getSource(), "Source");
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getTarget(), "Target");
        if (this.userCtxName != null) {
            ReplicatorDocument.UserCtx ctx = new ReplicatorDocument.UserCtx(this.replicatorDoc);
            ctx.setName(this.userCtxName);
            ctx.setRoles(this.userCtxRoles);
            this.replicatorDoc.setUserCtx(ctx);
        }
        return this.dbc.put(this.dbURI, this.replicatorDoc, true);
    }

    public ReplicatorDocument find() {
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getId(), "Doc id");
        URI uri = URIBuilder.buildUri(this.dbURI).path(this.replicatorDoc.getId()).query("rev", this.replicatorDoc.getRevision()).build();
        return this.dbc.get(uri, ReplicatorDocument.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReplicatorDocument> findAll() {
        ArrayList<ReplicatorDocument> arrayList;
        InputStream instream = null;
        try {
            URI uri = URIBuilder.buildUri(this.dbURI).path("_all_docs").query("include_docs", "true").build();
            instream = this.dbc.get(uri);
            InputStreamReader reader = new InputStreamReader(instream, StandardCharsets.UTF_8);
            JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonObject().getAsJsonArray("rows");
            ArrayList<ReplicatorDocument> list = new ArrayList<ReplicatorDocument>();
            for (JsonElement jsonElem : jsonArray) {
                JsonElement elem = jsonElem.getAsJsonObject().get("doc");
                if (CouchDbUtil.getAsString(elem.getAsJsonObject(), "_id").startsWith("_design")) continue;
                ReplicatorDocument rd = (ReplicatorDocument)this.dbc.getGson().fromJson(elem, ReplicatorDocument.class);
                list.add(rd);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(instream);
            throw throwable;
        }
        CouchDbUtil.close(instream);
        return arrayList;
    }

    public Response remove() {
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getId(), "Doc id");
        CouchDbUtil.assertNotEmpty(this.replicatorDoc.getRevision(), "Doc rev");
        URI uri = URIBuilder.buildUri(this.dbURI).path(this.replicatorDoc.getId()).query("rev", this.replicatorDoc.getRevision()).build();
        return this.dbc.delete(uri);
    }

    public Replicator source(String source) {
        this.replicatorDoc.setSource(source);
        return this;
    }

    public Replicator target(String target) {
        this.replicatorDoc.setTarget(target);
        return this;
    }

    public Replicator continuous(boolean continuous) {
        this.replicatorDoc.setContinuous(continuous);
        return this;
    }

    public Replicator filter(String filter) {
        this.replicatorDoc.setFilter(filter);
        return this;
    }

    public Replicator queryParams(String queryParams) {
        this.replicatorDoc.setQueryParams((JsonObject)this.dbc.getGson().fromJson(queryParams, JsonObject.class));
        return this;
    }

    public Replicator queryParams(Map<String, Object> queryParams) {
        this.replicatorDoc.setQueryParams(this.dbc.getGson().toJsonTree(queryParams).getAsJsonObject());
        return this;
    }

    public Replicator docIds(String ... docIds) {
        this.replicatorDoc.setDocIds(docIds);
        return this;
    }

    public Replicator proxy(String proxy) {
        this.replicatorDoc.setProxy(proxy);
        return this;
    }

    public Replicator createTarget(Boolean createTarget) {
        this.replicatorDoc.setCreateTarget(createTarget);
        return this;
    }

    public Replicator replicatorDB(String replicatorDB) {
        this.replicatorDB = replicatorDB;
        this.dbURI = URIBuilder.buildUri(this.dbc.getBaseUri()).path(replicatorDB).path("/").build();
        return this;
    }

    public Replicator replicatorDocId(String replicatorDocId) {
        this.replicatorDoc.setId(replicatorDocId);
        return this;
    }

    public Replicator replicatorDocRev(String replicatorDocRev) {
        this.replicatorDoc.setRevision(replicatorDocRev);
        return this;
    }

    public Replicator workerProcesses(int workerProcesses) {
        this.replicatorDoc.setWorkerProcesses(workerProcesses);
        return this;
    }

    public Replicator workerBatchSize(int workerBatchSize) {
        this.replicatorDoc.setWorkerBatchSize(workerBatchSize);
        return this;
    }

    public Replicator httpConnections(int httpConnections) {
        this.replicatorDoc.setHttpConnections(httpConnections);
        return this;
    }

    public Replicator connectionTimeout(long connectionTimeout) {
        this.replicatorDoc.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public Replicator retriesPerRequest(int retriesPerRequest) {
        this.replicatorDoc.setRetriesPerRequest(retriesPerRequest);
        return this;
    }

    public Replicator userCtxName(String userCtxName) {
        this.userCtxName = userCtxName;
        return this;
    }

    public Replicator userCtxRoles(String ... userCtxRoles) {
        this.userCtxRoles = userCtxRoles;
        return this;
    }

    public Replicator sinceSeq(String sinceSeq) {
        this.replicatorDoc.setSinceSeq(sinceSeq);
        return this;
    }
}

