/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.JsonObject;
import java.net.URI;
import java.util.List;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbUtil;
import org.lightcouch.NoDocumentException;
import org.lightcouch.Response;
import org.lightcouch.URIBuilder;
import org.lightcouch.View;

public class Local {
    private static final String LOCAL_PATH = "_local";
    private CouchDbClientBase dbc;
    private URI dbURI;
    private View localDocsView;

    Local(CouchDbClientBase dbc) {
        this.dbc = dbc;
        this.dbURI = URIBuilder.buildUri(dbc.getDBUri()).path(LOCAL_PATH).path("/").build();
        this.localDocsView = new View(dbc, "_local_docs");
    }

    public View localDocs() {
        return this.localDocsView;
    }

    public List<JsonObject> findAll() {
        return this.findAll(JsonObject.class);
    }

    public <T> List<T> findAll(Class<T> classType) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        return this.localDocsView.includeDocs(true).query(classType);
    }

    public JsonObject find(String id) {
        return this.find(JsonObject.class, id);
    }

    public <T> T find(Class<T> classType, String id) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        URI uri = this.buildURIforLocal(id);
        return this.dbc.get(uri, classType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        ClassicHttpResponse response = null;
        try {
            URI uri = this.buildURIforLocal(id);
            response = this.dbc.head(uri);
            CouchDbUtil.close(response);
        }
        catch (NoDocumentException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            CouchDbUtil.close(response);
        }
        return true;
    }

    public Response save(Object object) {
        return this.dbc.put(this.dbURI, object, true);
    }

    public Response update(Object object) {
        JsonObject json = this.dbc.getGson().toJsonTree(object).getAsJsonObject();
        String id = CouchDbUtil.getAsString(json, "_id");
        URI baseURI = this.buildURIforLocal(id, false);
        return this.dbc.put(baseURI, object, false);
    }

    public Response remove(Object object) {
        CouchDbUtil.assertNotEmpty(object, "object");
        JsonObject jsonObject = this.dbc.getGson().toJsonTree(object).getAsJsonObject();
        String id = CouchDbUtil.getAsString(jsonObject, "_id");
        return this.remove(id);
    }

    public Response removeWithRev(Object object) {
        CouchDbUtil.assertNotEmpty(object, "object");
        JsonObject jsonObject = this.dbc.getGson().toJsonTree(object).getAsJsonObject();
        String id = CouchDbUtil.getAsString(jsonObject, "_id");
        String rev = CouchDbUtil.getAsString(jsonObject, "_rev");
        return this.remove(id, rev);
    }

    public Response remove(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        URI docURI = this.buildURIforLocal(id);
        return this.dbc.delete(docURI);
    }

    public Response remove(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(id, "rev");
        URI docURI = URIBuilder.buildUri(this.buildURIforLocal(id)).query("rev", rev).build();
        return this.dbc.delete(docURI);
    }

    private URI buildURIforLocal(String id) {
        return this.buildURIforLocal(id, true);
    }

    private URI buildURIforLocal(String id, boolean includeId) {
        URI baseURI = this.dbURI;
        if (id.startsWith(LOCAL_PATH)) {
            baseURI = this.dbc.getDBUri();
        }
        if (includeId) {
            return URIBuilder.buildUri(baseURI).pathEncoded(id).build();
        }
        return URIBuilder.buildUri(baseURI).build();
    }
}

