/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.lightcouch.Changes;
import org.lightcouch.CouchDbClient;
import org.lightcouch.CouchDbConfig;
import org.lightcouch.CouchDbContext;
import org.lightcouch.CouchDbDesign;
import org.lightcouch.CouchDbException;
import org.lightcouch.CouchDbProperties;
import org.lightcouch.CouchDbUtil;
import org.lightcouch.DocumentConflictException;
import org.lightcouch.DocumentNotModifiedException;
import org.lightcouch.Local;
import org.lightcouch.NoDocumentException;
import org.lightcouch.Params;
import org.lightcouch.PurgeResponse;
import org.lightcouch.Replication;
import org.lightcouch.Replicator;
import org.lightcouch.Response;
import org.lightcouch.URIBuilder;
import org.lightcouch.View;

public abstract class CouchDbClientBase {
    static final Log log = LogFactory.getLog(CouchDbClient.class);
    private URI baseURI;
    private URI dbURI;
    private Gson gson;
    private CouchDbContext context;
    private CouchDbDesign design;
    private Local local;
    final CloseableHttpClient httpClient;
    final HttpHost host;
    final BasicCredentialsProvider credentialsProvider;

    CouchDbClientBase() {
        this(new CouchDbConfig());
    }

    CouchDbClientBase(CouchDbConfig config) {
        CouchDbProperties props = config.getProperties();
        this.credentialsProvider = this.initializeCredentials(props);
        this.httpClient = this.createHttpClient(props, (CredentialsProvider)this.credentialsProvider);
        this.gson = this.initGson(new GsonBuilder());
        this.host = new HttpHost(props.getProtocol(), props.getHost(), props.getPort());
        String path = props.getPath() != null ? props.getPath() : "";
        this.baseURI = URIBuilder.buildUri().scheme(props.getProtocol()).host(props.getHost()).port(props.getPort()).path("/").path(path).build();
        this.dbURI = URIBuilder.buildUri(this.baseURI).path(props.getDbName()).path("/").build();
        this.context = new CouchDbContext(this, props);
        this.design = new CouchDbDesign(this);
        this.local = new Local(this);
    }

    abstract CloseableHttpClient createHttpClient(CouchDbProperties var1, CredentialsProvider var2);

    abstract HttpContext createContext();

    abstract void shutdown();

    abstract BasicCredentialsProvider initializeCredentials(CouchDbProperties var1);

    public CouchDbContext context() {
        return this.context;
    }

    public CouchDbDesign design() {
        return this.design;
    }

    public View view(String viewId) {
        return new View(this, viewId);
    }

    public Local local() {
        return this.local;
    }

    public Replication replication() {
        return new Replication(this);
    }

    public Replicator replicator() {
        return new Replicator(this);
    }

    public Changes changes() {
        return new Changes(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PurgeResponse purge(Map<String, List<String>> toPurge) {
        PurgeResponse purgeResponse;
        CouchDbUtil.assertNotEmpty(toPurge, "to purge map");
        ClassicHttpResponse response = null;
        InputStreamReader reader = null;
        try {
            String jsonToPurge = this.getGson().toJson(toPurge);
            response = this.post(URIBuilder.buildUri(this.getDBUri()).path("_purge").build(), jsonToPurge);
            reader = new InputStreamReader(CouchDbUtil.getStream(response), StandardCharsets.UTF_8);
            purgeResponse = (PurgeResponse)this.getGson().fromJson((Reader)reader, PurgeResponse.class);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(reader);
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(reader);
        CouchDbUtil.close(response);
        return purgeResponse;
    }

    public <T> T find(Class<T> classType, String id) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        URI uri = URIBuilder.buildUri(this.getDBUri()).pathEncoded(id).build();
        return this.get(uri, classType);
    }

    public <T> T find(Class<T> classType, String id, Params params) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        URI uri = URIBuilder.buildUri(this.getDBUri()).pathEncoded(id).query(params).build();
        return this.get(uri, classType);
    }

    public <T> T find(Class<T> classType, String id, String rev) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(id, "rev");
        URI uri = URIBuilder.buildUri(this.getDBUri()).pathEncoded(id).query("rev", rev).build();
        return this.get(uri, classType);
    }

    public <T> T findAny(Class<T> classType, String uri) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(uri, "uri");
        return this.get(URI.create(uri), classType);
    }

    public InputStream find(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        return this.get(URIBuilder.buildUri(this.getDBUri()).path(id).build());
    }

    public InputStream find(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(rev, "rev");
        URI uri = URIBuilder.buildUri(this.getDBUri()).path(id).query("rev", rev).build();
        return this.get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> findDocs(String jsonQuery, Class<T> classOfT) {
        ArrayList<Object> arrayList;
        CouchDbUtil.assertNotEmpty(jsonQuery, "jsonQuery");
        ClassicHttpResponse response = null;
        try {
            response = this.post(URIBuilder.buildUri(this.getDBUri()).path("_find").build(), jsonQuery);
            InputStreamReader reader = new InputStreamReader(CouchDbUtil.getStream(response), StandardCharsets.UTF_8);
            JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonObject().getAsJsonArray("docs");
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement jsonElem : jsonArray) {
                JsonObject elem = jsonElem.getAsJsonObject();
                Object t = this.gson.fromJson((JsonElement)elem, classOfT);
                list.add(t);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String id) {
        CouchDbUtil.assertNotEmpty(id, "id");
        ClassicHttpResponse response = null;
        try {
            response = this.head(URIBuilder.buildUri(this.getDBUri()).pathEncoded(id).build());
            CouchDbUtil.close(response);
        }
        catch (NoDocumentException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            CouchDbUtil.close(response);
        }
        return true;
    }

    public Response save(Object object) {
        return this.put(this.getDBUri(), object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response post(Object object) {
        Response response;
        CouchDbUtil.assertNotEmpty(object, "object");
        ClassicHttpResponse response2 = null;
        try {
            URI uri = URIBuilder.buildUri(this.getDBUri()).build();
            response2 = this.post(uri, this.getGson().toJson(object));
            response = this.getResponse(response2);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response2);
            throw throwable;
        }
        CouchDbUtil.close(response2);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(Object object) {
        CouchDbUtil.assertNotEmpty(object, "object");
        ClassicHttpResponse response = null;
        try {
            URI uri = URIBuilder.buildUri(this.getDBUri()).query("batch", "ok").build();
            response = this.post(uri, this.getGson().toJson(object));
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
    }

    public Response update(Object object) {
        return this.put(this.getDBUri(), object, false);
    }

    public Response remove(Object object) {
        CouchDbUtil.assertNotEmpty(object, "object");
        JsonObject jsonObject = this.getGson().toJsonTree(object).getAsJsonObject();
        String id = CouchDbUtil.getAsString(jsonObject, "_id");
        String rev = CouchDbUtil.getAsString(jsonObject, "_rev");
        return this.remove(id, rev);
    }

    public Response remove(String id, String rev) {
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(rev, "rev");
        URI uri = URIBuilder.buildUri(this.getDBUri()).pathEncoded(id).query("rev", rev).build();
        return this.delete(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Response> bulk(List<?> objects, boolean newEdits) {
        List<Response> list;
        CouchDbUtil.assertNotEmpty(objects, "objects");
        ClassicHttpResponse response = null;
        try {
            String newEditsVal = newEdits ? "\"new_edits\": true, " : "\"new_edits\": false, ";
            String json = String.format("{%s%s%s}", newEditsVal, "\"docs\": ", this.getGson().toJson(objects));
            URI uri = URIBuilder.buildUri(this.getDBUri()).path("_bulk_docs").build();
            response = this.post(uri, json);
            list = this.getResponseList(response);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
        return list;
    }

    public Response saveAttachment(InputStream in, String name, String contentType) {
        CouchDbUtil.assertNotEmpty(in, "in");
        CouchDbUtil.assertNotEmpty(name, "name");
        CouchDbUtil.assertNotEmpty(contentType, "ContentType");
        URI uri = URIBuilder.buildUri(this.getDBUri()).path(CouchDbUtil.generateUUID()).path("/").path(name).build();
        return this.put(uri, in, contentType);
    }

    public Response saveAttachment(InputStream in, String name, String contentType, String docId, String docRev) {
        CouchDbUtil.assertNotEmpty(in, "in");
        CouchDbUtil.assertNotEmpty(name, "name");
        CouchDbUtil.assertNotEmpty(contentType, "ContentType");
        CouchDbUtil.assertNotEmpty(docId, "docId");
        URI uri = URIBuilder.buildUri(this.getDBUri()).pathEncoded(docId).path("/").path(name).query("rev", docRev).build();
        return this.put(uri, in, contentType);
    }

    public Response removeAttachment(String name, String docId, String docRev) {
        CouchDbUtil.assertNotEmpty(name, "name");
        CouchDbUtil.assertNotEmpty(docId, "docId");
        CouchDbUtil.assertNotEmpty(docRev, "docRev");
        URI uri = URIBuilder.buildUri(this.getDBUri()).pathEncoded(docId).path("/").path(name).query("rev", docRev).build();
        return this.delete(uri);
    }

    public String invokeUpdateHandler(String updateHandlerUri, String docId, Params params) {
        CouchDbUtil.assertNotEmpty(updateHandlerUri, "uri");
        CouchDbUtil.assertNotEmpty(docId, "docId");
        String[] v = updateHandlerUri.split("/");
        String path = String.format("_design/%s/_update/%s/", v[0], v[1]);
        URI uri = URIBuilder.buildUri(this.getDBUri()).path(path).path(docId).query(params).build();
        ClassicHttpResponse response = this.executeRequest((ClassicHttpRequest)new HttpPut(uri));
        return CouchDbUtil.streamToString(CouchDbUtil.getStream(response));
    }

    public ClassicHttpResponse executeRequest(ClassicHttpRequest request) {
        try {
            return this.httpClient.executeOpen(this.host, request, this.createContext());
        }
        catch (IOException e) {
            throw new CouchDbException("Error executing request. ", e);
        }
    }

    public void syncDesignDocsWithDb() {
        this.design().synchronizeAllWithDb();
    }

    public void setGsonBuilder(GsonBuilder gsonBuilder) {
        this.gson = this.initGson(gsonBuilder);
    }

    public URI getBaseUri() {
        return this.baseURI;
    }

    public URI getDBUri() {
        return this.dbURI;
    }

    public Gson getGson() {
        return this.gson;
    }

    InputStream get(HttpGet httpGet) {
        ClassicHttpResponse response = this.executeRequest((ClassicHttpRequest)httpGet);
        return CouchDbUtil.getStream(response);
    }

    InputStream get(URI uri) {
        HttpGet get = new HttpGet(uri);
        get.addHeader("Accept", (Object)"application/json");
        return this.get(get);
    }

    InputStream get(URI uri, Header[] headers) {
        HttpGet get = new HttpGet(uri);
        get.setHeaders(headers);
        get.addHeader("Accept", (Object)"application/json");
        return this.get(get);
    }

    <T> T get(URI uri, Class<T> classType) {
        InputStream in = null;
        try {
            in = this.get(uri);
            Object object = this.getGson().fromJson((Reader)new InputStreamReader(in, "UTF-8"), classType);
            return (T)object;
        }
        catch (UnsupportedEncodingException e) {
            throw new CouchDbException(e);
        }
        finally {
            CouchDbUtil.close(in);
        }
    }

    <T> T get(URI uri, Class<T> classType, Header[] headers) {
        Object object;
        InputStream in = null;
        try {
            in = this.get(uri, headers);
            object = this.getGson().fromJson((Reader)new InputStreamReader(in, "UTF-8"), classType);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new CouchDbException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(in);
                throw throwable;
            }
        }
        CouchDbUtil.close(in);
        return (T)object;
    }

    ClassicHttpResponse head(URI uri) {
        return this.executeRequest((ClassicHttpRequest)new HttpHead(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response put(URI uri, Object object, boolean newEntity) {
        Response response;
        CouchDbUtil.assertNotEmpty(object, "object");
        ClassicHttpResponse response2 = null;
        try {
            JsonObject json = this.getGson().toJsonTree(object).getAsJsonObject();
            String id = CouchDbUtil.getAsString(json, "_id");
            String rev = CouchDbUtil.getAsString(json, "_rev");
            if (newEntity) {
                CouchDbUtil.assertNull(rev, "rev");
                id = id == null ? CouchDbUtil.generateUUID() : id;
            } else {
                CouchDbUtil.assertNotEmpty(id, "id");
                CouchDbUtil.assertNotEmpty(rev, "rev");
            }
            HttpPut put = new HttpPut(URIBuilder.buildUri(uri).pathEncoded(id).build());
            this.setEntity((HttpUriRequestBase)put, json.toString());
            response2 = this.executeRequest((ClassicHttpRequest)put);
            response = this.getResponse(response2);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response2);
            throw throwable;
        }
        CouchDbUtil.close(response2);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response put(URI uri, InputStream instream, String contentType) {
        Response response;
        ClassicHttpResponse response2 = null;
        try {
            HttpPut httpPut = new HttpPut(uri);
            InputStreamEntity entity = new InputStreamEntity(instream, -1L, ContentType.parse((CharSequence)contentType));
            httpPut.setEntity((HttpEntity)entity);
            response2 = this.executeRequest((ClassicHttpRequest)httpPut);
            response = this.getResponse(response2);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response2);
            throw throwable;
        }
        CouchDbUtil.close(response2);
        return response;
    }

    ClassicHttpResponse post(URI uri, String json) {
        HttpPost post = new HttpPost(uri);
        this.setEntity((HttpUriRequestBase)post, json);
        return this.executeRequest((ClassicHttpRequest)post);
    }

    InputStream post(HttpPost post, String json) {
        this.setEntity((HttpUriRequestBase)post, json);
        ClassicHttpResponse resp = this.executeRequest((ClassicHttpRequest)post);
        return CouchDbUtil.getStream(resp);
    }

    <T> T post(URI uri, String json, Class<T> classType) {
        Object object;
        InputStream in = null;
        try {
            in = CouchDbUtil.getStream(this.post(uri, json));
            object = this.getGson().fromJson((Reader)new InputStreamReader(in, "UTF-8"), classType);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new CouchDbException(e);
            }
            catch (Throwable throwable) {
                CouchDbUtil.close(in);
                throw throwable;
            }
        }
        CouchDbUtil.close(in);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response delete(URI uri) {
        Response response;
        ClassicHttpResponse response2 = null;
        try {
            HttpDelete delete = new HttpDelete(uri);
            response2 = this.executeRequest((ClassicHttpRequest)delete);
            response = this.getResponse(response2);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response2);
            throw throwable;
        }
        CouchDbUtil.close(response2);
        return response;
    }

    void validate(HttpResponse response) throws IOException {
        int code = response.getCode();
        if (code == 200 || code == 201 || code == 202) {
            return;
        }
        String reason = response.getReasonPhrase();
        switch (code) {
            case 404: {
                throw new NoDocumentException(reason);
            }
            case 409: {
                throw new DocumentConflictException(reason);
            }
            case 304: {
                throw new DocumentNotModifiedException(reason);
            }
        }
        reason = reason + response.getReasonPhrase();
        throw new CouchDbException(reason);
    }

    private Response getResponse(ClassicHttpResponse response) throws CouchDbException {
        InputStreamReader reader = new InputStreamReader(CouchDbUtil.getStream(response), StandardCharsets.UTF_8);
        return (Response)this.getGson().fromJson((Reader)reader, Response.class);
    }

    private List<Response> getResponseList(ClassicHttpResponse response) throws CouchDbException {
        InputStream instream = CouchDbUtil.getStream(response);
        InputStreamReader reader = new InputStreamReader(instream, StandardCharsets.UTF_8);
        return (List)this.getGson().fromJson((Reader)reader, new TypeToken<List<Response>>(){}.getType());
    }

    private void setEntity(HttpUriRequestBase httpRequest, String json) {
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        httpRequest.setEntity((HttpEntity)entity);
    }

    private Gson initGson(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter(JsonObject.class, (Object)new JsonDeserializer<JsonObject>(){

            public JsonObject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return json.getAsJsonObject();
            }
        });
        gsonBuilder.registerTypeAdapter(JsonObject.class, (Object)new JsonSerializer<JsonObject>(){

            public JsonElement serialize(JsonObject src, Type typeOfSrc, JsonSerializationContext context) {
                return src.getAsJsonObject();
            }
        });
        return gsonBuilder.create();
    }

    public <T> T findIfModified(Class<T> classType, String id, String rev) {
        CouchDbUtil.assertNotEmpty(classType, "Class");
        CouchDbUtil.assertNotEmpty(id, "id");
        CouchDbUtil.assertNotEmpty(rev, "rev");
        URI uri = URIBuilder.buildUri(this.getDBUri()).pathEncoded(id).build();
        Header[] headers = new Header[]{new BasicHeader("If-None-Match", (Object)String.format("\"%s\"", rev))};
        return this.get(uri, classType, headers);
    }
}

