/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import java.io.Closeable;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbConfig;
import org.lightcouch.CouchDbProperties;

public class CouchDbClient
extends CouchDbClientBase
implements Closeable {
    public CouchDbClient() {
    }

    public CouchDbClient(String configFileName) {
        super(new CouchDbConfig(configFileName));
    }

    public CouchDbClient(String dbName, boolean createDbIfNotExist, String protocol, String host, int port, String username, String password) {
        super(new CouchDbConfig(new CouchDbProperties(dbName, createDbIfNotExist, protocol, host, port, username, password)));
    }

    public CouchDbClient(CouchDbProperties properties) {
        super(new CouchDbConfig(properties));
    }

    @Override
    CloseableHttpClient createHttpClient(CouchDbProperties props, CredentialsProvider credentialsProvider) {
        try {
            Registry<ConnectionSocketFactory> registry = this.createRegistry(props);
            PoolingHttpClientConnectionManager ccm = this.createConnectionManager(props, registry);
            HttpClientBuilder clientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)ccm).setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)props.getSocketTimeout())).setCookieSpec("strict").build());
            if (props.getProxyHost() != null) {
                clientBuilder.setProxy(new HttpHost(props.getProxyHost(), props.getProxyPort()));
            }
            if (credentialsProvider != null) {
                clientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
            this.registerInterceptors(clientBuilder);
            return clientBuilder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error Creating HTTPClient: ", e);
        }
    }

    @Override
    BasicCredentialsProvider initializeCredentials(CouchDbProperties props) {
        BasicCredentialsProvider credsProvider = null;
        if (props.getUsername() != null) {
            credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(props.getHost(), props.getPort()), (Credentials)new UsernamePasswordCredentials(props.getUsername(), props.getPassword().toCharArray()));
            props.clearPassword();
        }
        return credsProvider;
    }

    @Override
    HttpContext createContext() {
        BasicHttpContext context = new BasicHttpContext();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme auth = new BasicScheme();
        if (this.credentialsProvider != null) {
            Credentials credentials = this.credentialsProvider.getCredentials(new AuthScope(this.host), (HttpContext)context);
            auth.initPreemptive(credentials);
            authCache.put(this.host, (AuthScheme)auth);
            context.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
        return context;
    }

    private PoolingHttpClientConnectionManager createConnectionManager(CouchDbProperties props, Registry<ConnectionSocketFactory> registry) {
        PoolingHttpClientConnectionManager ccm = props.getConnectionTTL() > 0 ? new PoolingHttpClientConnectionManager(registry, PoolConcurrencyPolicy.STRICT, TimeValue.ofMilliseconds((long)props.getConnectionTTL()), null) : new PoolingHttpClientConnectionManager(registry);
        if (props.getMaxConnections() != 0) {
            ccm.setMaxTotal(props.getMaxConnections());
            ccm.setDefaultMaxPerRoute(props.getMaxConnections());
        }
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)props.getConnectionTimeout()));
        if (props.getSocketTimeout() > 0) {
            connectionConfigBuilder.setSocketTimeout(Timeout.ofMilliseconds((long)props.getSocketTimeout()));
        }
        ccm.setDefaultConnectionConfig(connectionConfigBuilder.build());
        return ccm;
    }

    private Registry<ConnectionSocketFactory> createRegistry(CouchDbProperties props) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        RegistryBuilder registry = RegistryBuilder.create();
        if ("https".equals(props.getProtocol())) {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            return registry.register("https", (Object)new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)new NoopHostnameVerifier())).build();
        }
        return registry.register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
    }

    private void registerInterceptors(HttpClientBuilder clientBuilder) {
        clientBuilder.addRequestInterceptorFirst(new HttpRequestInterceptor(){

            public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws IOException {
                if (CouchDbClientBase.log.isInfoEnabled()) {
                    CouchDbClientBase.log.info((Object)("> " + request.getMethod() + " " + URLDecoder.decode(request.getRequestUri(), "UTF-8")));
                }
            }
        });
        clientBuilder.addResponseInterceptorFirst(new HttpResponseInterceptor(){

            public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws IOException {
                if (CouchDbClientBase.log.isInfoEnabled()) {
                    CouchDbClientBase.log.info((Object)("< Status: " + response.getCode()));
                }
                CouchDbClient.this.validate(response);
            }
        });
    }

    @Override
    public void shutdown() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }
}

