/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.lightcouch.CouchDbClient;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbException;
import org.lightcouch.CouchDbUtil;
import org.lightcouch.NoDocumentException;
import org.lightcouch.Page;
import org.lightcouch.URIBuilder;
import org.lightcouch.ViewResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View {
    private static final Log log = LogFactory.getLog(CouchDbClient.class);
    private static final String START_KEY = "s_k";
    private static final String START_KEY_DOC_ID = "s_k_d_i";
    private static final String CURRENT_START_KEY = "c_k";
    private static final String CURRENT_START_KEY_DOC_ID = "c_k_d_i";
    private static final String CURRENT_KEYS = "c";
    private static final String ACTION = "a";
    private static final String NEXT = "n";
    private static final String PREVIOUS = "p";
    private String key;
    private String startKey;
    private String startKeyDocId;
    private String endKey;
    private String endKeyDocId;
    private Integer limit;
    private String stale;
    private Boolean descending;
    private Integer skip;
    private Boolean group;
    private Integer groupLevel;
    private Boolean reduce;
    private Boolean includeDocs;
    private Boolean inclusiveEnd;
    private Boolean updateSeq;
    private CouchDbClientBase dbc;
    private Gson gson;
    private URIBuilder uriBuilder;
    private String allDocsKeys;

    View(CouchDbClientBase dbc, String viewId) {
        CouchDbUtil.assertNotEmpty(viewId, "View id");
        this.dbc = dbc;
        this.gson = dbc.getGson();
        String view = viewId;
        if (viewId.contains("/")) {
            String[] v = viewId.split("/");
            view = String.format("_design/%s/_view/%s", v[0], v[1]);
        }
        this.uriBuilder = URIBuilder.buildUri(dbc.getDBUri()).path(view);
    }

    public InputStream queryForStream() {
        URI uri = this.uriBuilder.build();
        if (this.allDocsKeys != null) {
            return CouchDbUtil.getStream(this.dbc.post(uri, this.allDocsKeys));
        }
        return this.dbc.get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> query(Class<T> classOfT) {
        ArrayList<Object> arrayList;
        InputStream instream = null;
        try {
            instream = this.queryForStream();
            InputStreamReader reader = new InputStreamReader(instream, Charsets.UTF_8);
            JsonArray jsonArray = new JsonParser().parse((Reader)reader).getAsJsonObject().getAsJsonArray("rows");
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement jsonElem : jsonArray) {
                JsonObject elem = jsonElem.getAsJsonObject();
                if (Boolean.TRUE.equals(this.includeDocs)) {
                    elem = jsonElem.getAsJsonObject().get("doc");
                }
                Object t = this.gson.fromJson((JsonElement)elem, classOfT);
                list.add(t);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(instream);
            throw throwable;
        }
        CouchDbUtil.close(instream);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, T> ViewResult<K, V, T> queryView(Class<K> classOfK, Class<V> classOfV, Class<T> classOfT) {
        ViewResult viewResult;
        InputStream instream = null;
        try {
            instream = this.queryForStream();
            InputStreamReader reader = new InputStreamReader(instream, Charsets.UTF_8);
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            ViewResult vr = new ViewResult();
            vr.setTotalRows(CouchDbUtil.getAsLong(json, "total_rows"));
            vr.setOffset(CouchDbUtil.getAsInt(json, "offset"));
            vr.setUpdateSeq(CouchDbUtil.getAsString(json, "update_seq"));
            JsonArray jsonArray = json.getAsJsonArray("rows");
            for (JsonElement e : jsonArray) {
                ViewResult.Rows row = new ViewResult.Rows(vr);
                row.setId(CouchDbUtil.JsonToObject(this.gson, e, "id", String.class));
                if (classOfK != null) {
                    row.setKey(CouchDbUtil.JsonToObject(this.gson, e, "key", classOfK));
                }
                if (classOfV != null) {
                    row.setValue(CouchDbUtil.JsonToObject(this.gson, e, "value", classOfV));
                }
                if (Boolean.TRUE.equals(this.includeDocs)) {
                    row.setDoc(CouchDbUtil.JsonToObject(this.gson, e, "doc", classOfT));
                }
                vr.getRows().add(row);
            }
            viewResult = vr;
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(instream);
            throw throwable;
        }
        CouchDbUtil.close(instream);
        return viewResult;
    }

    public String queryForString() {
        return this.queryValue(String.class);
    }

    public int queryForInt() {
        return this.queryValue(Integer.TYPE);
    }

    public long queryForLong() {
        return this.queryValue(Long.TYPE);
    }

    public boolean queryForBoolean() {
        return this.queryValue(Boolean.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V queryValue(Class<V> classOfV) {
        V v;
        InputStream instream = null;
        try {
            instream = this.queryForStream();
            InputStreamReader reader = new InputStreamReader(instream, Charsets.UTF_8);
            JsonArray array = new JsonParser().parse((Reader)reader).getAsJsonObject().get("rows").getAsJsonArray();
            if (array.size() != 1) {
                throw new NoDocumentException("Expecting a single result but was: " + array.size());
            }
            v = CouchDbUtil.JsonToObject(this.gson, array.get(0), "value", classOfV);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(instream);
            throw throwable;
        }
        CouchDbUtil.close(instream);
        return v;
    }

    public <T> Page<T> queryPage(int rowsPerPage, String param, Class<T> classOfT) {
        String action;
        String startKeyDocId;
        String startKey;
        String currentStartKeyDocId;
        String currentStartKey;
        if (param == null) {
            return this.queryNextPage(rowsPerPage, null, null, null, null, classOfT);
        }
        try {
            JsonObject json = new JsonParser().parse(new String(Base64.decodeBase64((byte[])param.getBytes()))).getAsJsonObject();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Paging Param Decoded = " + json));
            }
            JsonObject jsonCurrent = json.getAsJsonObject(CURRENT_KEYS);
            currentStartKey = jsonCurrent.get(CURRENT_START_KEY).getAsString();
            currentStartKeyDocId = jsonCurrent.get(CURRENT_START_KEY_DOC_ID).getAsString();
            startKey = json.get(START_KEY).getAsString();
            startKeyDocId = json.get(START_KEY_DOC_ID).getAsString();
            action = json.get(ACTION).getAsString();
        }
        catch (Exception e) {
            throw new CouchDbException("could not parse the given param!", e);
        }
        if (PREVIOUS.equals(action)) {
            return this.queryPreviousPage(rowsPerPage, currentStartKey, currentStartKeyDocId, startKey, startKeyDocId, classOfT);
        }
        return this.queryNextPage(rowsPerPage, currentStartKey, currentStartKeyDocId, startKey, startKeyDocId, classOfT);
    }

    private <T> Page<T> queryNextPage(int rowsPerPage, String currentStartKey, String currentStartKeyDocId, String startKey, String startKeyDocId, Class<T> classOfT) {
        this.limit(rowsPerPage + 1);
        this.includeDocs(true);
        if (startKey != null) {
            this.startKey(startKey);
            this.startKeyDocId(startKeyDocId);
        }
        Page page = new Page();
        ArrayList pageList = new ArrayList();
        ViewResult<String, Object, T> vr = this.queryView(String.class, Object.class, classOfT);
        List<ViewResult.Rows> rows = vr.getRows();
        int resultRows = rows.size();
        int offset = vr.getOffset();
        long totalRows = vr.getTotalRows();
        JsonObject currentKeys = new JsonObject();
        JsonObject jsonNext = new JsonObject();
        JsonObject jsonPrev = new JsonObject();
        currentKeys.addProperty(CURRENT_START_KEY, (String)rows.get(0).getKey());
        currentKeys.addProperty(CURRENT_START_KEY_DOC_ID, rows.get(0).getId());
        for (int i = 0; i < resultRows; ++i) {
            if (i == resultRows - 1 && resultRows > rowsPerPage) {
                page.setHasNext(true);
                jsonNext.addProperty(START_KEY, (String)rows.get(i).getKey());
                jsonNext.addProperty(START_KEY_DOC_ID, rows.get(i).getId());
                jsonNext.add(CURRENT_KEYS, (JsonElement)currentKeys);
                jsonNext.addProperty(ACTION, NEXT);
                page.setNextParam(Base64.encodeBase64URLSafeString((byte[])jsonNext.toString().getBytes()));
                continue;
            }
            pageList.add(rows.get(i).getDoc());
        }
        if (offset != 0) {
            page.setHasPrevious(true);
            jsonPrev.addProperty(START_KEY, currentStartKey);
            jsonPrev.addProperty(START_KEY_DOC_ID, currentStartKeyDocId);
            jsonPrev.add(CURRENT_KEYS, (JsonElement)currentKeys);
            jsonPrev.addProperty(ACTION, PREVIOUS);
            page.setPreviousParam(Base64.encodeBase64URLSafeString((byte[])jsonPrev.toString().getBytes()));
        }
        page.setResultList(pageList);
        page.setTotalResults(totalRows);
        page.setResultFrom(offset + 1);
        int resultTo = rowsPerPage > resultRows ? resultRows : rowsPerPage;
        page.setResultTo(offset + resultTo);
        page.setPageNumber((int)Math.ceil((double)page.getResultFrom() / Double.valueOf(rowsPerPage)));
        return page;
    }

    private <T> Page<T> queryPreviousPage(int rowsPerPage, String currentStartKey, String currentStartKeyDocId, String startKey, String startKeyDocId, Class<T> classOfT) {
        this.limit(rowsPerPage + 1);
        this.includeDocs(true);
        this.descending(true);
        this.startKey(currentStartKey);
        this.startKeyDocId(currentStartKeyDocId);
        Page page = new Page();
        ArrayList pageList = new ArrayList();
        ViewResult<String, Object, T> vr = this.queryView(String.class, Object.class, classOfT);
        List<ViewResult.Rows> rows = vr.getRows();
        int resultRows = rows.size();
        int offset = vr.getOffset();
        long totalRows = vr.getTotalRows();
        Collections.reverse(rows);
        JsonObject currentKeys = new JsonObject();
        JsonObject jsonNext = new JsonObject();
        JsonObject jsonPrev = new JsonObject();
        currentKeys.addProperty(CURRENT_START_KEY, (String)rows.get(0).getKey());
        currentKeys.addProperty(CURRENT_START_KEY_DOC_ID, rows.get(0).getId());
        for (int i = 0; i < resultRows; ++i) {
            if (i == resultRows - 1 && resultRows >= rowsPerPage) {
                page.setHasNext(true);
                jsonNext.addProperty(START_KEY, (String)rows.get(i).getKey());
                jsonNext.addProperty(START_KEY_DOC_ID, rows.get(i).getId());
                jsonNext.add(CURRENT_KEYS, (JsonElement)currentKeys);
                jsonNext.addProperty(ACTION, NEXT);
                page.setNextParam(Base64.encodeBase64URLSafeString((byte[])jsonNext.toString().getBytes()));
                continue;
            }
            pageList.add(rows.get(i).getDoc());
        }
        if ((long)offset != totalRows - (long)rowsPerPage - 1L) {
            page.setHasPrevious(true);
            jsonPrev.addProperty(START_KEY, currentStartKey);
            jsonPrev.addProperty(START_KEY_DOC_ID, currentStartKeyDocId);
            jsonPrev.add(CURRENT_KEYS, (JsonElement)currentKeys);
            jsonPrev.addProperty(ACTION, PREVIOUS);
            page.setPreviousParam(Base64.encodeBase64URLSafeString((byte[])jsonPrev.toString().getBytes()));
        }
        page.setResultList(pageList);
        page.setTotalResults(totalRows);
        page.setResultFrom((int)totalRows - (offset + rowsPerPage));
        int resultTo = (int)totalRows - offset - 1;
        page.setResultTo(resultTo);
        page.setPageNumber(resultTo / rowsPerPage);
        return page;
    }

    public View key(Object ... key) {
        this.key = this.getKeyAsJson(key);
        this.uriBuilder.query("key", this.key);
        return this;
    }

    public View startKey(Object ... startKey) {
        this.startKey = this.getKeyAsJson(startKey);
        this.uriBuilder.query("startkey", this.startKey);
        return this;
    }

    public View startKeyDocId(String startKeyDocId) {
        this.startKeyDocId = startKeyDocId;
        this.uriBuilder.query("startkey_docid", this.startKeyDocId);
        return this;
    }

    public View endKey(Object ... endKey) {
        this.endKey = this.getKeyAsJson(endKey);
        this.uriBuilder.query("endkey", this.endKey);
        return this;
    }

    public View endKeyDocId(String endKeyDocId) {
        this.endKeyDocId = endKeyDocId;
        this.uriBuilder.query("endkey_docid", this.endKeyDocId);
        return this;
    }

    public View limit(Integer limit) {
        this.limit = limit;
        this.uriBuilder.query("limit", this.limit);
        return this;
    }

    public View stale(String stale) {
        this.stale = stale;
        this.uriBuilder.query("stale", this.stale);
        return this;
    }

    public View descending(Boolean descending) {
        this.descending = Boolean.valueOf(this.gson.toJson((Object)descending));
        this.uriBuilder.query("descending", this.descending);
        return this;
    }

    public View skip(Integer skip) {
        this.skip = skip;
        this.uriBuilder.query("skip", this.skip);
        return this;
    }

    public View group(Boolean group) {
        this.group = group;
        this.uriBuilder.query("group", this.group);
        return this;
    }

    public View groupLevel(Integer groupLevel) {
        this.groupLevel = groupLevel;
        this.uriBuilder.query("group_level", this.groupLevel);
        return this;
    }

    public View reduce(Boolean reduce) {
        this.reduce = reduce;
        this.uriBuilder.query("reduce", this.reduce);
        return this;
    }

    public View includeDocs(Boolean includeDocs) {
        this.includeDocs = includeDocs;
        this.uriBuilder.query("include_docs", this.includeDocs);
        return this;
    }

    public View inclusiveEnd(Boolean inclusiveEnd) {
        this.inclusiveEnd = inclusiveEnd;
        this.uriBuilder.query("inclusive_end", this.inclusiveEnd);
        return this;
    }

    public View updateSeq(Boolean updateSeq) {
        this.updateSeq = updateSeq;
        this.uriBuilder.query("update_seq", this.updateSeq);
        return this;
    }

    public View keys(List<?> keys) {
        this.allDocsKeys = String.format("{%s:%s}", this.gson.toJson((Object)"keys"), this.gson.toJson(keys));
        return this;
    }

    private String getKeyAsJson(Object ... key) {
        return key.length == 1 ? this.gson.toJson(key[0]) : this.gson.toJson((Object)key);
    }
}

