/*
 * Decompiled with CFR 0.152.
 */
package org.lightcouch;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.List;
import org.apache.commons.codec.Charsets;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.lightcouch.ChangesResult;
import org.lightcouch.CouchDbClientBase;
import org.lightcouch.CouchDbException;
import org.lightcouch.CouchDbUtil;
import org.lightcouch.URIBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Changes {
    private BufferedReader reader;
    private HttpUriRequest httpRequest;
    private ChangesResult.Row nextRow;
    private boolean stop;
    private CouchDbClientBase dbc;
    private Gson gson;
    private URIBuilder uriBuilder;
    private String filter;
    private String selector;
    private List<String> docIds;

    Changes(CouchDbClientBase dbc) {
        this.dbc = dbc;
        this.gson = dbc.getGson();
        this.uriBuilder = URIBuilder.buildUri(dbc.getDBUri()).path("_changes");
    }

    public Changes continuousChanges() {
        URI uri = this.uriBuilder.query("feed", "continuous").build();
        if (this.selector == null) {
            HttpGet get = new HttpGet(uri);
            this.httpRequest = get;
            InputStream in = this.dbc.get(get);
            InputStreamReader is = new InputStreamReader(in, Charsets.UTF_8);
            this.setReader(new BufferedReader(is));
        } else {
            HttpPost post = new HttpPost(uri);
            this.httpRequest = post;
            InputStream in = this.dbc.post(post, this.selector);
            InputStreamReader is = new InputStreamReader(in, Charsets.UTF_8);
            this.setReader(new BufferedReader(is));
        }
        return this;
    }

    public boolean hasNext() {
        return this.readNextRow();
    }

    public ChangesResult.Row next() {
        return this.getNextRow();
    }

    public void stop() {
        this.stop = true;
    }

    public ChangesResult getChanges() {
        URI uri = this.uriBuilder.query("feed", "normal").build();
        if (this.selector == null && this.docIds == null) {
            return this.dbc.get(uri, ChangesResult.class);
        }
        String json = this.selector;
        if (this.docIds != null) {
            JsonObject docIdsJson = new JsonObject();
            JsonArray jArray = new JsonArray();
            for (String id : this.docIds) {
                jArray.add(id);
            }
            docIdsJson.add("doc_ids", (JsonElement)jArray);
            json = docIdsJson.toString();
        }
        return this.dbc.post(uri, json, ChangesResult.class);
    }

    public Changes since(String since) {
        this.uriBuilder.query("since", since);
        return this;
    }

    public Changes limit(int limit) {
        this.uriBuilder.query("limit", limit);
        return this;
    }

    public Changes heartBeat(long heartBeat) {
        this.uriBuilder.query("heartbeat", heartBeat);
        return this;
    }

    public Changes timeout(long timeout) {
        this.uriBuilder.query("timeout", timeout);
        return this;
    }

    public Changes filter(String filter) {
        if (this.docIds != null || this.selector != null) {
            throw new IllegalArgumentException("Filter is not compatible with selector or docIds filters");
        }
        this.uriBuilder.query("filter", filter);
        this.filter = filter;
        return this;
    }

    public Changes selector(String json) {
        if (this.docIds != null || this.filter != null) {
            throw new IllegalArgumentException("Selector is not compatible with filters or docIds filters");
        }
        this.uriBuilder.query("filter", "_selector");
        this.selector = json;
        return this;
    }

    public Changes docIds(List<String> docIds) {
        if (this.selector != null || this.filter != null) {
            throw new IllegalArgumentException("DocIds filter is not compatible with filter or selector");
        }
        this.uriBuilder.query("filter", "_doc_ids");
        this.docIds = docIds;
        return this;
    }

    public Changes includeDocs(boolean includeDocs) {
        this.uriBuilder.query("include_docs", includeDocs);
        return this;
    }

    public Changes style(String style) {
        this.uriBuilder.query("style", style);
        return this;
    }

    public Changes seqInterval(long batchSize) {
        this.uriBuilder.query("seq_interval", batchSize);
        return this;
    }

    private boolean readNextRow() {
        boolean hasNext = false;
        try {
            if (!this.stop) {
                String row = "";
                while ((row = this.getReader().readLine()).length() == 0 && !this.stop) {
                }
                if (!this.stop && !row.startsWith("{\"last_seq\":")) {
                    this.setNextRow((ChangesResult.Row)this.gson.fromJson(row, ChangesResult.Row.class));
                    hasNext = true;
                }
            }
        }
        catch (Exception e) {
            this.terminate();
            throw new CouchDbException("Error reading continuous stream.", e);
        }
        if (!hasNext) {
            this.terminate();
        }
        return hasNext;
    }

    private BufferedReader getReader() {
        return this.reader;
    }

    private void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    private ChangesResult.Row getNextRow() {
        return this.nextRow;
    }

    private void setNextRow(ChangesResult.Row nextRow) {
        this.nextRow = nextRow;
    }

    private void terminate() {
        this.httpRequest.abort();
        CouchDbUtil.close(this.getReader());
    }
}

