/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.expressions;

import android.util.Log;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonOrgMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.vijay.jsonwizard.expressions.ExternalContentLru;
import com.vijay.jsonwizard.expressions.ExternalContentResolver;
import java.util.EnumSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonExpressionResolver {
    private JSONObject dataObject;
    private DocumentContext dataDocumentContext;
    private ExternalContentLru contentCache;

    public JsonExpressionResolver(JSONObject form) throws JSONException {
        this(form, null);
    }

    public JsonExpressionResolver(JSONObject form, ExternalContentResolver contentResolver) throws JSONException {
        this.dataObject = form.has("data") ? form.getJSONObject("data") : new JSONObject("{}");
        this.dataDocumentContext = JsonPath.parse((Object)this.dataObject);
        this.contentCache = new ExternalContentLru(contentResolver, 10);
    }

    public boolean isValidExpression(String expression) {
        if (expression == null) {
            return false;
        }
        return expression.startsWith("$.") || expression.startsWith("@.");
    }

    private String extractExternalContentReference(String expression) {
        if (!expression.startsWith("@.")) {
            return null;
        }
        int extRefLimit = expression.indexOf("/");
        if (extRefLimit > -1) {
            return expression.substring(2, extRefLimit);
        }
        return null;
    }

    private String extractJsonExpression(String expression) {
        int pos = expression.indexOf("$.");
        return expression.substring(pos);
    }

    public String resolveAsString(String expression, JSONObject instance) throws JSONException {
        JSONArray array = this.resolveExpression(expression, instance);
        if (array == null || array.length() == 0) {
            return null;
        }
        if (array.isNull(0)) {
            return null;
        }
        return array.getString(0);
    }

    public JSONArray resolveAsArray(String expression, JSONObject instance) {
        JSONArray array = this.resolveExpression(expression, instance);
        if (array == null || array.length() == 0) {
            return null;
        }
        Object item = array.opt(0);
        if (item instanceof JSONArray) {
            return (JSONArray)item;
        }
        return array;
    }

    public JSONObject resolveAsObject(String expression, JSONObject instance) {
        JSONArray array = this.resolveExpression(expression, instance);
        if (array == null || array.length() == 0) {
            return null;
        }
        Object item = array.opt(0);
        if (item instanceof JSONObject) {
            return (JSONObject)item;
        }
        return null;
    }

    private JSONArray resolveExpression(String expression, JSONObject instance) {
        String localExpression = expression;
        String externalReference = this.extractExternalContentReference(expression);
        DocumentContext localContext = this.dataDocumentContext;
        if (externalReference != null) {
            localContext = (DocumentContext)this.contentCache.get(externalReference);
            if (localContext == null) {
                Log.w((String)"ExpressionResolver", (String)("resolveAsArray: external content " + externalReference + " can not be loaded"));
                return null;
            }
            localExpression = this.extractJsonExpression(expression);
            if (localExpression == null) {
                Log.w((String)"ExpressionResolver", (String)("resolveAsArray: external content expression can not be extracted " + expression));
                return null;
            }
        }
        if (instance != null) {
            localContext.put("$", "current-values", (Object)instance, new Predicate[0]);
        }
        JSONArray array = (JSONArray)localContext.read(localExpression, new Predicate[0]);
        localContext.delete("current-values", new Predicate[0]);
        return array;
    }

    public boolean existsExpression(String expression, JSONObject instance) throws JSONException {
        String localExpression = expression;
        String externalReference = this.extractExternalContentReference(expression);
        DocumentContext localContext = this.dataDocumentContext;
        if (externalReference != null) {
            localContext = (DocumentContext)this.contentCache.get(externalReference);
            if (localContext == null) {
                Log.w((String)"ExpressionResolver", (String)("resolveAsArray: external content " + externalReference + " can not be loaded"));
                return false;
            }
            localExpression = this.extractJsonExpression(expression);
            if (localExpression == null) {
                Log.w((String)"ExpressionResolver", (String)("resolveAsArray: external content expression can not be extracted " + expression));
                return false;
            }
        }
        if (instance != null) {
            localContext.put("$", "current-values", (Object)instance, new Predicate[0]);
        }
        JSONArray array = new JSONArray();
        try {
            array = (JSONArray)localContext.read(localExpression, new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            Log.d((String)"ExpressionResolver", (String)("existsExpression: checking for missing path " + localExpression));
        }
        localContext.delete("current-values", new Predicate[0]);
        if (array != null && array.length() > 0) {
            for (int i = 0; i < array.length(); ++i) {
                if (array.isNull(i)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JsonOrgJsonProvider();
            private final MappingProvider mappingProvider = new JsonOrgMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.of(Option.DEFAULT_PATH_LEAF_TO_NULL, Option.ALWAYS_RETURN_LIST);
            }
        });
    }
}

