/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.FormUtils;
import com.vijay.jsonwizard.utils.ImageUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class SignatureFactory
implements FormWidgetFactory {
    private static final int RESULT_LOAD_IMG = 1;

    public static ValidationStatus validate(ImageView imageView) {
        if (!(imageView.getTag(R.id.v_required) instanceof String) || !(imageView.getTag(R.id.error) instanceof String)) {
            return new ValidationStatus(true, null);
        }
        Boolean isRequired = Boolean.valueOf((String)imageView.getTag(R.id.v_required));
        if (!isRequired.booleanValue()) {
            return new ValidationStatus(true, null);
        }
        Object path = imageView.getTag(R.id.imagePath);
        if (path instanceof String && !TextUtils.isEmpty((CharSequence)((String)path))) {
            return new ValidationStatus(true, null);
        }
        return new ValidationStatus(false, (String)imageView.getTag(R.id.error));
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        if (visualizationMode == 2) {
            return this.getReadOnlyViews(context, jsonObject, bundle);
        }
        return this.getEditableViews(context, jsonObject, listener, bundle);
    }

    private List<View> getReadOnlyViews(Context context, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        String imagePath = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)imagePath)) {
            ArrayList<View> views = new ArrayList<View>(1);
            View rootView = LayoutInflater.from((Context)context).inflate(R.layout.item_signature, null);
            ImageView imageView = (ImageView)rootView.findViewById(R.id.image_preview);
            Bitmap bitmap = ImageUtils.loadBitmapFromFile(imagePath, ImageUtils.getDeviceWidth(context), FormUtils.dpToPixels(context, 200.0f));
            if (bitmap != null) {
                imageView.setImageBitmap(bitmap);
            } else {
                imageView.setImageResource(R.mipmap.grey_bg);
            }
            Button btn = (Button)rootView.findViewById(R.id.btn_upload);
            btn.setEnabled(false);
            btn.setText((CharSequence)bundle.resolveKey(jsonObject.getString("uploadButtonText")));
            views.add(rootView);
            return views;
        }
        return Collections.emptyList();
    }

    private List<View> getEditableViews(Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle) throws JSONException {
        String requiredValue;
        ArrayList<View> views = new ArrayList<View>(1);
        View rootView = LayoutInflater.from((Context)context).inflate(R.layout.item_image_picker, null);
        rootView.setTag(R.id.type, (Object)jsonObject.getString("type"));
        final ImageView imageView = (ImageView)rootView.findViewById(R.id.image_preview);
        imageView.setTag(R.id.key, (Object)jsonObject.getString("key"));
        imageView.setTag(R.id.type, (Object)jsonObject.getString("type"));
        JSONObject requiredObject = jsonObject.optJSONObject("v_required");
        if (requiredObject != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            imageView.setTag(R.id.v_required, (Object)requiredValue);
            imageView.setTag(R.id.error, (Object)bundle.resolveKey(requiredObject.optString("err")));
        }
        final Button clearBtn = (Button)rootView.findViewById(R.id.btn_clear);
        clearBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                imageView.setImageResource(R.mipmap.grey_bg);
                imageView.setTag(R.id.imagePath, null);
                clearBtn.setVisibility(8);
            }
        });
        String imagePath = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)imagePath)) {
            imageView.setTag(R.id.imagePath, (Object)imagePath);
            imageView.setImageBitmap(ImageUtils.loadBitmapFromFile(imagePath, ImageUtils.getDeviceWidth(context), FormUtils.dpToPixels(context, 200.0f)));
            clearBtn.setVisibility(0);
        }
        Button uploadButton = (Button)rootView.findViewById(R.id.btn_upload);
        uploadButton.setText((CharSequence)bundle.resolveKey(jsonObject.getString("uploadButtonText")));
        uploadButton.setOnClickListener((View.OnClickListener)listener);
        uploadButton.setTag(R.id.key, (Object)jsonObject.getString("key"));
        uploadButton.setTag(R.id.type, (Object)jsonObject.getString("type"));
        views.add(rootView);
        return views;
    }
}

