/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.utils;

import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.Log;
import com.vijay.jsonwizard.utils.ImageFileUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;

public class SignatureItem {
    private static final String TAG = "ImagePicker";
    private static final String TEMP_IMAGE_NAME = "tempImage";

    public static Bitmap getImageFromResult(Context context, int resultCode, Intent imageReturnedIntent) {
        Log.d((String)TAG, (String)("getImageFromResult, resultCode: " + resultCode));
        Bitmap bm = null;
        File imageFile = SignatureItem.getTempFile(context);
        if (resultCode == -1) {
            // empty if block
        }
        return bm;
    }

    private static File getTempFile(Context context) {
        File imageFile = new File(context.getExternalCacheDir(), TEMP_IMAGE_NAME);
        imageFile.getParentFile().mkdirs();
        return imageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap decodeBitmap(Context context, Uri theUri, int sampleSize) {
        AssetFileDescriptor fileDescriptor = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = sampleSize;
            try {
                fileDescriptor = context.getContentResolver().openAssetFileDescriptor(theUri, "r");
                Bitmap actuallyUsableBitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options);
                Log.d((String)TAG, (String)(options.inSampleSize + " sample method bitmap ... " + actuallyUsableBitmap.getWidth() + " " + actuallyUsableBitmap.getHeight()));
                Bitmap bitmap = actuallyUsableBitmap;
                return bitmap;
            }
            catch (FileNotFoundException e) {
                Bitmap bitmap;
                block13: {
                    Log.e((String)TAG, (String)"decodeBitmap: error", (Throwable)e);
                    bitmap = null;
                    if (fileDescriptor == null) break block13;
                    try {
                        fileDescriptor.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return bitmap;
            }
        }
        finally {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Bitmap getImageResized(Context context, Uri selectedImage) {
        Bitmap bm = SignatureItem.decodeBitmap(context, selectedImage, 1);
        bm = ImageFileUtils.scaleToFit(bm, 1600);
        return bm;
    }
}

