/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.activities;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.utils.ImageUtils;
import java.io.File;

public class SignatureActivity
extends AppCompatActivity {
    private Signature mSignature;
    private Bitmap bitmap;
    private LinearLayout mContent;
    private RelativeLayout mysignatureContainer;
    private View view;
    private View deleteButton;
    private View saveButton;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setupView();
        this.setupButtons();
    }

    private void setupView() {
        this.setContentView(R.layout.activity_signature);
        this.mysignatureContainer = (RelativeLayout)this.findViewById(R.id.mysignatureContainer);
        this.mContent = (LinearLayout)this.findViewById(R.id.mysignature);
        this.mSignature = new Signature((Context)this, null);
        this.mContent.addView((View)this.mSignature);
        this.view = this.mysignatureContainer;
    }

    private void setupButtons() {
        this.deleteButton = this.findViewById(R.id.cleanBt);
        this.deleteButton.setOnClickListener(v -> this.mSignature.clear());
        this.saveButton = this.findViewById(R.id.saveBt);
        this.saveButton.setOnClickListener(v -> {
            if (this.hasSigned()) {
                this.saveImage();
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.signature_empty), (int)1).show();
            }
        });
    }

    private void saveImage() {
        File file = new File(this.getExternalCacheDir(), "firma.jpg");
        this.bitmap = Bitmap.createBitmap((int)this.mContent.getWidth(), (int)this.mContent.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(this.bitmap);
        this.view.draw(canvas);
        this.bitmap = ImageUtils.scaleToFit(this.bitmap, 1600);
        ImageUtils.compressAndSave(this.bitmap, 80, file.getAbsolutePath());
        this.finish();
    }

    private boolean hasSigned() {
        return this.mSignature.lastTouchX != 0.0f && this.mSignature.lastTouchY != 0.0f;
    }

    private void deleteOldSignature(String path) {
        File deletedPicture = new File(path);
        deletedPicture.delete();
    }

    public class Signature
    extends View {
        private static final float STROKE_WIDTH = 3.0f;
        private static final float HALF_STROKE_WIDTH = 1.5f;
        private static final String TAG = "Signature";
        private final RectF dirtyRect;
        private final Paint paint;
        private final Path path;
        private float lastTouchX;
        private float lastTouchY;

        public Signature(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.dirtyRect = new RectF();
            this.paint = new Paint();
            this.path = new Path();
            this.paint.setAntiAlias(true);
            this.paint.setColor(-16777216);
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeJoin(Paint.Join.ROUND);
            this.paint.setStrokeWidth(3.0f);
        }

        public boolean save(View v, String storedPath) {
            boolean result = false;
            Log.v((String)"tag", (String)("Width: " + v.getWidth()));
            Log.v((String)"tag", (String)("Height: " + v.getHeight()));
            return result;
        }

        public void clear() {
            this.path.reset();
            this.lastTouchX = 0.0f;
            this.lastTouchY = 0.0f;
            this.invalidate();
        }

        protected void onDraw(Canvas canvas) {
            canvas.drawPath(this.path, this.paint);
        }

        public boolean onTouchEvent(MotionEvent event) {
            float eventX = event.getX();
            float eventY = event.getY();
            switch (event.getAction()) {
                case 0: {
                    this.path.moveTo(eventX, eventY);
                    this.lastTouchX = eventX;
                    this.lastTouchY = eventY;
                    return true;
                }
                case 1: 
                case 2: {
                    this.resetDirtyRect(eventX, eventY);
                    int historySize = event.getHistorySize();
                    for (int i = 0; i < historySize; ++i) {
                        float historicalX = event.getHistoricalX(i);
                        float historicalY = event.getHistoricalY(i);
                        this.expandDirtyRect(historicalX, historicalY);
                        this.path.lineTo(historicalX, historicalY);
                    }
                    this.path.lineTo(eventX, eventY);
                    break;
                }
                default: {
                    Log.d((String)TAG, (String)("Ignored touch event: " + event.toString()));
                    return false;
                }
            }
            this.invalidate((int)(this.dirtyRect.left - 1.5f), (int)(this.dirtyRect.top - 1.5f), (int)(this.dirtyRect.right + 1.5f), (int)(this.dirtyRect.bottom + 1.5f));
            this.lastTouchX = eventX;
            this.lastTouchY = eventY;
            return true;
        }

        private void expandDirtyRect(float historicalX, float historicalY) {
            if (historicalX < this.dirtyRect.left) {
                this.dirtyRect.left = historicalX;
            } else if (historicalX > this.dirtyRect.right) {
                this.dirtyRect.right = historicalX;
            }
            if (historicalY < this.dirtyRect.top) {
                this.dirtyRect.top = historicalY;
            } else if (historicalY > this.dirtyRect.bottom) {
                this.dirtyRect.bottom = historicalY;
            }
        }

        private void resetDirtyRect(float eventX, float eventY) {
            this.dirtyRect.left = Math.min(this.lastTouchX, eventX);
            this.dirtyRect.right = Math.max(this.lastTouchX, eventX);
            this.dirtyRect.top = Math.min(this.lastTouchY, eventY);
            this.dirtyRect.bottom = Math.max(this.lastTouchY, eventY);
        }
    }
}

