/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.barcode;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetector;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.barcode.barcodescanning.BarcodeGraphic;
import com.vijay.jsonwizard.barcode.barcodescanning.BarcodeScanningProcessor;
import com.vijay.jsonwizard.barcode.common.CameraImageGraphic;
import com.vijay.jsonwizard.barcode.common.CameraSource;
import com.vijay.jsonwizard.barcode.common.CameraSourcePreview;
import com.vijay.jsonwizard.barcode.common.GraphicOverlay;
import java.io.IOException;
import java.util.ArrayList;

@KeepName
public final class LivePreviewActivity
extends AppCompatActivity
implements ActivityCompat.OnRequestPermissionsResultCallback,
CompoundButton.OnCheckedChangeListener,
View.OnClickListener {
    private static final String TAG = "LivePreviewActivity";
    private static final int PERMISSION_REQUESTS = 1;
    private static final String PARAM_BARCODE = "barcode";
    private static final String PARAM_ERROR = "error";
    private CameraSource cameraSource = null;
    private CameraSourcePreview preview;
    private GraphicOverlay graphicOverlay;
    private BarcodeScanningProcessor barcodeScanningProcessor;
    private TextView editText;

    private static boolean isPermissionGranted(Context context, String permission2) {
        if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0) {
            Log.i((String)TAG, (String)("Permission granted: " + permission2));
            return true;
        }
        Log.i((String)TAG, (String)("Permission NOT granted: " + permission2));
        return false;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d((String)TAG, (String)"onCreate");
        this.setContentView(R.layout.activity_live_preview);
        this.preview = (CameraSourcePreview)this.findViewById(R.id.firePreview);
        if (this.preview == null) {
            Log.d((String)TAG, (String)"Preview is null");
        }
        this.graphicOverlay = (GraphicOverlay)this.findViewById(R.id.fireFaceOverlay);
        if (this.graphicOverlay == null) {
            Log.d((String)TAG, (String)"graphicOverlay is null");
        }
        ToggleButton facingSwitch = (ToggleButton)this.findViewById(R.id.facingSwitch);
        facingSwitch.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        final Button submit = (Button)this.findViewById(R.id.submit);
        submit.setOnClickListener((View.OnClickListener)this);
        this.editText = (TextView)this.findViewById(R.id.selectedCode);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                submit.setEnabled(true);
            }
        });
        if (Camera.getNumberOfCameras() == 1) {
            facingSwitch.setVisibility(8);
        }
        if (this.allPermissionsGranted()) {
            this.isVisionModuleInstalled();
            this.createCameraSource();
        } else {
            this.getRuntimePermissions();
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        Log.d((String)TAG, (String)"Set facing");
        if (this.cameraSource != null) {
            if (isChecked) {
                this.cameraSource.setFacing(1);
            } else {
                this.cameraSource.setFacing(0);
            }
        }
        this.preview.stop();
        this.startCameraSource();
    }

    private void createCameraSource() {
        if (this.cameraSource == null) {
            this.cameraSource = new CameraSource((Activity)this, this.graphicOverlay);
        }
        try {
            Log.i((String)TAG, (String)"Using Barcode Detector Processor");
            this.barcodeScanningProcessor = new BarcodeScanningProcessor();
            this.cameraSource.setMachineLearningFrameProcessor(this.barcodeScanningProcessor);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Can not create image processor: ", (Throwable)e);
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)("Can not create image processor: " + e.getMessage()), (int)1).show();
        }
    }

    private void startCameraSource() {
        if (this.cameraSource != null) {
            try {
                if (this.preview == null) {
                    Log.d((String)TAG, (String)"resume: Preview is null");
                }
                if (this.graphicOverlay == null) {
                    Log.d((String)TAG, (String)"resume: graphOverlay is null");
                }
                this.preview.start(this.cameraSource, this.graphicOverlay);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Unable to start camera source.", (Throwable)e);
                this.cameraSource.release();
                this.cameraSource = null;
            }
        }
    }

    public void onResume() {
        super.onResume();
        Log.d((String)TAG, (String)"onResume");
        this.startCameraSource();
    }

    protected void onPause() {
        super.onPause();
        this.preview.stop();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.cameraSource != null) {
            this.cameraSource.release();
        }
    }

    private String[] getRequiredPermissions() {
        String[] permissions = new String[]{"android.permission.CAMERA"};
        return permissions;
    }

    private boolean allPermissionsGranted() {
        for (String permission2 : this.getRequiredPermissions()) {
            if (LivePreviewActivity.isPermissionGranted((Context)this, permission2)) continue;
            return false;
        }
        return true;
    }

    private void getRuntimePermissions() {
        ArrayList<String> allNeededPermissions = new ArrayList<String>();
        for (String permission2 : this.getRequiredPermissions()) {
            if (LivePreviewActivity.isPermissionGranted((Context)this, permission2)) continue;
            allNeededPermissions.add(permission2);
        }
        if (!allNeededPermissions.isEmpty()) {
            ActivityCompat.requestPermissions((Activity)this, (String[])allNeededPermissions.toArray(new String[0]), (int)1);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, @NonNull int[] grantResults) {
        Log.i((String)TAG, (String)"Permission granted!");
        if (this.allPermissionsGranted()) {
            this.createCameraSource();
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private BarcodeGraphic getGraphAtPos(GraphicOverlay overlay, float x, float y) {
        BarcodeGraphic selected = null;
        for (GraphicOverlay.Graphic graph : overlay.getGraphics()) {
            BarcodeGraphic barcodeGraphic;
            if (!(graph instanceof BarcodeGraphic) || !(barcodeGraphic = (BarcodeGraphic)graph).contains(x, y)) continue;
            Log.d((String)"GraphicOverlay", (String)"getGraphAtPos: winner!");
            selected = barcodeGraphic;
        }
        return selected;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            Log.d((String)TAG, (String)"dispatchTouchEvent: event");
            float x = event.getRawX();
            float y = event.getRawY();
            int[] coordinates = new int[2];
            this.graphicOverlay.getLocationOnScreen(coordinates);
            BarcodeGraphic graph = this.getGraphAtPos(this.graphicOverlay, x -= (float)coordinates[0], y -= (float)coordinates[1]);
            if (graph != null) {
                CameraImageGraphic lastImage = this.barcodeScanningProcessor.getLastImage();
                this.barcodeScanningProcessor.pause();
                this.cameraSource.stop();
                String barcodeValue = graph.getBarcode().getDisplayValue();
                Log.d((String)TAG, (String)("dispatchTouchEvent: Selected = " + barcodeValue));
                this.graphicOverlay.highlight(graph);
                this.refreshOverlay(this.graphicOverlay, lastImage);
                this.editText.setText((CharSequence)barcodeValue);
            }
        }
        return super.dispatchTouchEvent(event);
    }

    private void refreshOverlay(GraphicOverlay overlay, CameraImageGraphic cameraImage) {
        ArrayList<GraphicOverlay.Graphic> graphics = new ArrayList<GraphicOverlay.Graphic>(overlay.getGraphics());
        overlay.clear();
        for (GraphicOverlay.Graphic graphic : graphics) {
            overlay.add(graphic);
        }
        overlay.postInvalidate();
    }

    public void onClick(View v) {
        if (v != null && v.getId() == R.id.submit) {
            Log.d((String)TAG, (String)"onClick: Submit!!!");
            Intent result = new Intent();
            result.putExtra(PARAM_BARCODE, this.editText.getText().toString());
            this.setResult(-1, result);
            this.finish();
        }
    }

    private void isVisionModuleInstalled() {
        Boolean isAvailable = false;
        FirebaseVisionBarcodeDetector detector = FirebaseVision.getInstance().getVisionBarcodeDetector();
        int w = 32;
        int h = 32;
        Bitmap.Config conf = Bitmap.Config.ARGB_4444;
        Bitmap bmp = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)conf);
        Task task = detector.detectInImage(FirebaseVisionImage.fromBitmap((Bitmap)bmp));
        task.addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                Log.d((String)LivePreviewActivity.TAG, (String)"onCreate: wait for install");
                Intent result = new Intent();
                result.putExtra(LivePreviewActivity.PARAM_ERROR, "");
                LivePreviewActivity.this.setResult(-1, result);
                LivePreviewActivity.this.finish();
            }
        });
    }
}

