/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.Nullable;
import com.google.android.material.textfield.TextInputEditText;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.customviews.GenericTextWatcher;
import com.vijay.jsonwizard.customviews.MaterialTextInputLayout;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.ExpressionResolverContextUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.vijay.jsonwizard.validators.textinputlayout.MaxLengthValidator;
import com.vijay.jsonwizard.validators.textinputlayout.MinLengthValidator;
import com.vijay.jsonwizard.validators.textinputlayout.RegexpValidator;
import com.vijay.jsonwizard.validators.textinputlayout.RequiredValidator;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MaterialEditTextFactory
implements FormWidgetFactory {
    public static ValidationStatus validate(MaterialTextInputLayout materialTextInputLayout) {
        boolean validate = materialTextInputLayout.validate();
        if (!validate) {
            return new ValidationStatus(false, materialTextInputLayout.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(stepName, context, jsonObject, bundle, resolver);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(stepName, context, jsonObject, bundle, resolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(String stepName, Context context, JSONObject jsonObject, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        String editType;
        String numericValue;
        JSONObject numericObject;
        String urlValue;
        JSONObject urlObject;
        String emailValue;
        JSONObject emailObject;
        String regexValue;
        String requiredValue;
        JSONObject requiredObject;
        String maxLengthValue;
        JSONObject maxLengthObject;
        String minLengthValue;
        JSONObject minLengthObject;
        String readonlyValue = jsonObject.optString("readonly");
        boolean readonly = false;
        if (resolver.isValidExpression(readonlyValue)) {
            JSONObject currentValues = ExpressionResolverContextUtils.getCurrentValues(context, stepName);
            readonly = resolver.existsExpression(readonlyValue, currentValues);
        } else {
            readonly = Boolean.TRUE.toString().equalsIgnoreCase(readonlyValue);
        }
        if (readonly) {
            return this.getReadOnlyViewsFromJson(stepName, context, jsonObject, bundle, resolver);
        }
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialTextInputLayout textInputLayout = (MaterialTextInputLayout)LayoutInflater.from((Context)context).inflate(R.layout.item_material_edit_text, null);
        TextInputEditText editText = (TextInputEditText)textInputLayout.getEditText();
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        textInputLayout.setHint(hint);
        textInputLayout.setErrorEnabled(true);
        editText.setId(View.generateViewId());
        textInputLayout.setTag(R.id.key, jsonObject.getString("key"));
        textInputLayout.setTag(R.id.type, jsonObject.getString("type"));
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String value = jsonObject.optString("value");
        if (resolver.isValidExpression(value)) {
            JSONObject currentValues = ExpressionResolverContextUtils.getCurrentValues(context, stepName);
            value = resolver.resolveAsString(value, currentValues);
        }
        if (!TextUtils.isEmpty((CharSequence)value)) {
            String resolvedValue;
            if (resolver.isValidExpression(value)) {
                resolvedValue = resolver.resolveAsString(value, this.getCurrentValues(context, stepName));
                if (resolvedValue == null) {
                    resolvedValue = "";
                }
            } else {
                resolvedValue = value;
            }
            editText.setText((CharSequence)resolvedValue);
        }
        if (!TextUtils.isEmpty((CharSequence)jsonObject.optString("lines"))) {
            editText.setSingleLine(false);
            editText.setLines(jsonObject.optInt("lines"));
        }
        if ((minLengthObject = jsonObject.optJSONObject("v_min_length")) != null && !TextUtils.isEmpty((CharSequence)(minLengthValue = minLengthObject.optString("value")))) {
            int minLength = Integer.parseInt(minLengthValue);
            textInputLayout.addValidator(new MinLengthValidator(minLengthObject.getString("err"), minLength));
        }
        if ((maxLengthObject = jsonObject.optJSONObject("v_max_length")) != null && !TextUtils.isEmpty((CharSequence)(maxLengthValue = maxLengthObject.optString("value")))) {
            int maxLength = Integer.parseInt(maxLengthValue);
            textInputLayout.addValidator(new MaxLengthValidator(maxLengthObject.getString("err"), maxLength));
        }
        if ((requiredObject = jsonObject.optJSONObject("v_required")) != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            boolean required = false;
            if (resolver.isValidExpression(requiredValue)) {
                JSONObject currentValues = ExpressionResolverContextUtils.getCurrentValues(context, stepName);
                required = resolver.existsExpression(requiredValue, currentValues);
            } else {
                required = Boolean.TRUE.toString().equalsIgnoreCase(requiredValue);
            }
            if (required) {
                textInputLayout.addValidator(new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
            }
        }
        textInputLayout.initTextWatchers();
        JSONObject regexObject = jsonObject.optJSONObject("v_regex");
        if (regexObject != null && !TextUtils.isEmpty((CharSequence)(regexValue = regexObject.optString("value")))) {
            textInputLayout.addValidator(new RegexpValidator(bundle.resolveKey(regexObject.getString("err")), regexValue));
        }
        if ((emailObject = jsonObject.optJSONObject("v_email")) != null && !TextUtils.isEmpty((CharSequence)(emailValue = emailObject.optString("value"))) && Boolean.TRUE.toString().equalsIgnoreCase(emailValue)) {
            textInputLayout.addValidator(new RegexpValidator(bundle.resolveKey(emailObject.getString("err")), Patterns.EMAIL_ADDRESS.toString()));
        }
        if ((urlObject = jsonObject.optJSONObject("v_url")) != null && !TextUtils.isEmpty((CharSequence)(urlValue = urlObject.optString("value"))) && Boolean.TRUE.toString().equalsIgnoreCase(urlValue)) {
            textInputLayout.addValidator(new RegexpValidator(bundle.resolveKey(urlObject.getString("err")), Patterns.WEB_URL.toString()));
        }
        if ((numericObject = jsonObject.optJSONObject("v_numeric")) != null && !TextUtils.isEmpty((CharSequence)(numericValue = numericObject.optString("value"))) && Boolean.TRUE.toString().equalsIgnoreCase(numericValue)) {
            textInputLayout.addValidator(new RegexpValidator(bundle.resolveKey(numericObject.getString("err")), "[0-9]+"));
        }
        if (!TextUtils.isEmpty((CharSequence)(editType = jsonObject.optString("edit_type"))) && editType.equals("number")) {
            editText.setRawInputType(8194);
        }
        editText.addTextChangedListener((TextWatcher)new GenericTextWatcher(stepName, (View)editText));
        views.add((View)textInputLayout);
        return views;
    }

    private List<View> getReadOnlyViewsFromJson(String stepName, Context context, JSONObject jsonObject, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialTextInputLayout materialTextInputLayout = (MaterialTextInputLayout)LayoutInflater.from((Context)context).inflate(R.layout.item_material_edit_text, null);
        EditText editText = materialTextInputLayout.getEditText();
        editText.setId(View.generateViewId());
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        materialTextInputLayout.setHint(hint);
        materialTextInputLayout.setTag(R.id.key, jsonObject.getString("key"));
        materialTextInputLayout.setTag(R.id.type, jsonObject.getString("type"));
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            String resolvedValue;
            if (resolver.isValidExpression(value)) {
                resolvedValue = resolver.resolveAsString(value, this.getCurrentValues(context, stepName));
                if (resolvedValue == null) {
                    resolvedValue = "";
                }
            } else {
                resolvedValue = value;
            }
            editText.setText((CharSequence)resolvedValue);
        }
        if (!TextUtils.isEmpty((CharSequence)jsonObject.optString("lines"))) {
            editText.setSingleLine(false);
            editText.setLines(jsonObject.optInt("lines"));
        }
        editText.setEnabled(false);
        views.add((View)materialTextInputLayout);
        return views;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context, String stepName) throws JSONException {
        return ExpressionResolverContextUtils.getCurrentValues(context, stepName);
    }
}

