/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.textfield.TextInputEditText;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.customviews.MaterialTextInputLayout;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.fragments.JsonFormFragment;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.ClickableFormWidget;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.DateUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class DatePickerFactory
implements FormWidgetFactory,
ClickableFormWidget {
    private static final String TAG = "DatePickerFactory";

    public static ValidationStatus validate(MaterialTextInputLayout materialTextInputLayout) {
        boolean validate = materialTextInputLayout.validate();
        if (!validate) {
            return new ValidationStatus(false, materialTextInputLayout.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(context, jsonObject, bundle, listener);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle, CommonListener listener) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialTextInputLayout materialTextInputLayout = (MaterialTextInputLayout)LayoutInflater.from((Context)context).inflate(R.layout.item_material_edit_text, null);
        EditText editText = materialTextInputLayout.getEditText();
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        String minDate = jsonObject.optString("minDate");
        String maxDate = jsonObject.optString("maxDate");
        materialTextInputLayout.setHint(hint);
        materialTextInputLayout.setId(View.generateViewId());
        materialTextInputLayout.setTag(R.id.key, jsonObject.getString("key"));
        materialTextInputLayout.setTag(R.id.type, "date_picker");
        materialTextInputLayout.setTag(R.id.v_pattern, bundle.resolveKey(jsonObject.getString("pattern")));
        materialTextInputLayout.setTag(R.id.minDate, minDate);
        materialTextInputLayout.setTag(R.id.maxDate, maxDate);
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)"date_picker");
        editText.setTag(R.id.v_pattern, (Object)bundle.resolveKey(jsonObject.getString("pattern")));
        editText.setTag(R.id.minDate, (Object)minDate);
        editText.setTag(R.id.maxDate, (Object)maxDate);
        editText.setOnFocusChangeListener((View.OnFocusChangeListener)listener);
        editText.setOnClickListener((View.OnClickListener)listener);
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            Date date = DateUtils.parseJSONDate(value);
            editText.setText((CharSequence)new SimpleDateFormat((String)editText.getTag(R.id.v_pattern)).format(date));
        }
        views.add((View)materialTextInputLayout);
        return views;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialTextInputLayout textInputLayout = (MaterialTextInputLayout)LayoutInflater.from((Context)context).inflate(R.layout.item_material_edit_text, null);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        TextInputEditText editText = (TextInputEditText)textInputLayout.getEditText();
        textInputLayout.setHint(hint);
        editText.setId(View.generateViewId());
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        textInputLayout.setTag(R.id.key, jsonObject.getString("key"));
        textInputLayout.setTag(R.id.type, jsonObject.getString("type"));
        String widgetPattern = bundle.resolveKey(jsonObject.getString("pattern"));
        editText.setTag(R.id.v_pattern, (Object)widgetPattern);
        textInputLayout.setTag(R.id.v_pattern, widgetPattern);
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            Date date = DateUtils.parseJSONDate(value);
            SimpleDateFormat widgetDateFormat = new SimpleDateFormat(widgetPattern);
            editText.setText((CharSequence)widgetDateFormat.format(date));
        }
        editText.setEnabled(false);
        views.add((View)textInputLayout);
        return views;
    }

    @Override
    public void onClick(JsonFormFragment jsonFormFragment, View v) {
        jsonFormFragment.hideKeyBoard();
        DatePickerListener datePickerListener = new DatePickerListener((TextInputEditText)v, jsonFormFragment.getActivity().getSupportFragmentManager());
        datePickerListener.openDatePicker(v);
    }

    @Override
    public void onFocusChange(JsonFormFragment jsonFormFragment, boolean focus, View v) {
        if (focus) {
            jsonFormFragment.hideKeyBoard();
            DatePickerListener datePickerListener = new DatePickerListener((TextInputEditText)v, jsonFormFragment.getActivity().getSupportFragmentManager());
            datePickerListener.openDatePicker(v);
        }
    }

    private class DatePickerListener {
        private MaterialDatePicker d;
        private TextInputEditText dateText;
        private static final String TAG = "DatePickerListener";
        private FragmentManager fragmentManager;

        private DatePickerListener(TextInputEditText materialEditText, FragmentManager fragmentManager) {
            this.dateText = materialEditText;
            this.fragmentManager = fragmentManager;
        }

        private void openDatePicker(View view) {
            Date date = new Date();
            String dateStr = this.dateText.getText().toString();
            if (dateStr != null && !"".equals(dateStr)) {
                try {
                    date = SimpleDateFormat.getDateInstance().parse(dateStr);
                }
                catch (ParseException e) {
                    Log.e((String)TAG, (String)("Error parsing " + dateStr + ": " + e.getMessage()));
                }
            }
            String minDateStr = (String)view.getTag(R.id.minDate);
            String maxDateStr = (String)view.getTag(R.id.maxDate);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            CalendarConstraints.Builder constraintBuilder = new CalendarConstraints.Builder();
            constraintBuilder.setOpenAt(calendar.getTimeInMillis());
            String pattern = (String)this.dateText.getTag(R.id.v_pattern);
            Date minDate = this.resolveDate(minDateStr, pattern);
            Date maxDate = this.resolveDate(maxDateStr, pattern);
            if (minDate != null && maxDate != null) {
                constraintBuilder.setStart(minDate.getTime());
                constraintBuilder.setEnd(maxDate.getTime());
            }
            MaterialDatePicker.Builder builder = MaterialDatePicker.Builder.datePicker();
            builder.setCalendarConstraints(constraintBuilder.build());
            this.d = builder.build();
            this.d.addOnPositiveButtonClickListener(new MaterialPickerOnPositiveButtonClickListener(){

                public void onPositiveButtonClick(Object selection) {
                    Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    utc.setTimeInMillis((Long)selection);
                    SimpleDateFormat format = new SimpleDateFormat(DatePickerListener.this.dateText.getTag(R.id.v_pattern).toString());
                    String formatted = format.format(utc.getTime());
                    DatePickerListener.this.dateText.setText((CharSequence)formatted);
                    DatePickerListener.this.d.dismiss();
                }
            });
            this.d.addOnNegativeButtonClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DatePickerListener.this.d.dismiss();
                }
            });
            FragmentActivity dialog = this.d.getActivity();
            this.d.show(this.fragmentManager, "DATE_PICKER");
        }

        private Date resolveDate(String dateStr, String pattern) {
            DateFormat sdf = TextUtils.isEmpty((CharSequence)pattern) ? SimpleDateFormat.getDateInstance() : new SimpleDateFormat(pattern);
            try {
                return sdf.parse(dateStr);
            }
            catch (ParseException e) {
                Log.e((String)TAG, (String)("Error parsing " + dateStr + ": " + e.getMessage()));
                return null;
            }
        }
    }
}

