/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.barcode.common;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.images.Size;
import com.vijay.jsonwizard.barcode.common.FrameMetadata;
import com.vijay.jsonwizard.barcode.common.GraphicOverlay;
import com.vijay.jsonwizard.barcode.common.VisionImageProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"MissingPermission"})
public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private static final String TAG = "MIDemoApp:CameraSource";
    private static final int DUMMY_TEXTURE_NAME = 100;
    private static final float ASPECT_RATIO_TOLERANCE = 0.01f;
    private final float requestedFps = 20.0f;
    private final int requestedPreviewWidth = 960;
    private final int requestedPreviewHeight = 720;
    private final boolean requestedAutoFocus = true;
    private final GraphicOverlay graphicOverlay;
    private final FrameProcessingRunnable processingRunnable;
    private final Object processorLock = new Object();
    private final Map<byte[], ByteBuffer> bytesToByteBuffer = new IdentityHashMap<byte[], ByteBuffer>();
    protected Activity activity;
    protected int facing = 0;
    private Camera camera;
    private int rotation;
    private Size previewSize;
    private SurfaceTexture dummySurfaceTexture;
    private boolean usingSurfaceTexture;
    private Thread processingThread;
    private VisionImageProcessor frameProcessor;

    public CameraSource(Activity activity, GraphicOverlay overlay) {
        this.activity = activity;
        this.graphicOverlay = overlay;
        this.graphicOverlay.clear();
        this.processingRunnable = new FrameProcessingRunnable();
        if (Camera.getNumberOfCameras() == 1) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
            this.facing = cameraInfo.facing;
        }
    }

    private static int getIdForRequestedCamera(int facing) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != facing) continue;
            return i;
        }
        return -1;
    }

    private static SizePair selectSizePair(Camera camera, int desiredWidth, int desiredHeight) {
        List<SizePair> validPreviewSizes = CameraSource.generateValidPreviewSizeList(camera);
        SizePair selectedPair = null;
        int minDiff = Integer.MAX_VALUE;
        for (SizePair sizePair : validPreviewSizes) {
            Size size = sizePair.previewSize();
            int diff = Math.abs(size.getWidth() - desiredWidth) + Math.abs(size.getHeight() - desiredHeight);
            if (diff >= minDiff) continue;
            selectedPair = sizePair;
            minDiff = diff;
        }
        return selectedPair;
    }

    private static List<SizePair> generateValidPreviewSizeList(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        List supportedPreviewSizes = parameters.getSupportedPreviewSizes();
        List supportedPictureSizes = parameters.getSupportedPictureSizes();
        ArrayList<SizePair> validPreviewSizes = new ArrayList<SizePair>();
        block0: for (Camera.Size previewSize : supportedPreviewSizes) {
            float previewAspectRatio = (float)previewSize.width / (float)previewSize.height;
            for (Camera.Size pictureSize : supportedPictureSizes) {
                float pictureAspectRatio = (float)pictureSize.width / (float)pictureSize.height;
                if (!(Math.abs(previewAspectRatio - pictureAspectRatio) < 0.01f)) continue;
                validPreviewSizes.add(new SizePair(previewSize, pictureSize));
                continue block0;
            }
        }
        if (validPreviewSizes.size() == 0) {
            Log.w((String)TAG, (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size previewSize : supportedPreviewSizes) {
                validPreviewSizes.add(new SizePair(previewSize, null));
            }
        }
        return validPreviewSizes;
    }

    @SuppressLint(value={"InlinedApi"})
    private static int[] selectPreviewFpsRange(Camera camera, float desiredPreviewFps) {
        int desiredPreviewFpsScaled = (int)(desiredPreviewFps * 1000.0f);
        int[] selectedFpsRange = null;
        int minDiff = Integer.MAX_VALUE;
        List previewFpsRangeList = camera.getParameters().getSupportedPreviewFpsRange();
        for (int[] range : previewFpsRangeList) {
            int deltaMin = desiredPreviewFpsScaled - range[0];
            int deltaMax = desiredPreviewFpsScaled - range[1];
            int diff = Math.abs(deltaMin) + Math.abs(deltaMax);
            if (diff >= minDiff) continue;
            selectedFpsRange = range;
            minDiff = diff;
        }
        return selectedFpsRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.processorLock;
        synchronized (object) {
            this.stop();
            this.processingRunnable.release();
            this.cleanScreen();
            if (this.frameProcessor != null) {
                this.frameProcessor.stop();
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    @RequiresPermission(value="android.permission.CAMERA")
    public synchronized CameraSource start() throws IOException {
        if (this.camera != null) {
            return this;
        }
        this.camera = this.createCamera();
        this.dummySurfaceTexture = new SurfaceTexture(100);
        this.camera.setPreviewTexture(this.dummySurfaceTexture);
        this.usingSurfaceTexture = true;
        this.camera.startPreview();
        this.processingThread = new Thread(this.processingRunnable);
        this.processingRunnable.setActive(true);
        this.processingThread.start();
        return this;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public synchronized CameraSource start(SurfaceHolder surfaceHolder) throws IOException {
        if (this.camera != null) {
            return this;
        }
        this.camera = this.createCamera();
        this.camera.setPreviewDisplay(surfaceHolder);
        this.camera.startPreview();
        this.processingThread = new Thread(this.processingRunnable);
        this.processingRunnable.setActive(true);
        this.processingThread.start();
        this.usingSurfaceTexture = false;
        return this;
    }

    public synchronized void stop() {
        this.processingRunnable.setActive(false);
        if (this.processingThread != null) {
            try {
                this.processingThread.join();
            }
            catch (InterruptedException e) {
                Log.d((String)TAG, (String)"Frame processing thread interrupted on release.");
            }
            this.processingThread = null;
        }
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
            try {
                if (this.usingSurfaceTexture) {
                    this.camera.setPreviewTexture(null);
                } else {
                    this.camera.setPreviewDisplay(null);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Failed to clear camera preview: " + e));
            }
            this.camera.release();
            this.camera = null;
        }
        this.bytesToByteBuffer.clear();
    }

    public synchronized void setFacing(int facing) {
        if (facing != 0 && facing != 1) {
            throw new IllegalArgumentException("Invalid camera: " + facing);
        }
        this.facing = facing;
    }

    public Size getPreviewSize() {
        return this.previewSize;
    }

    public int getCameraFacing() {
        return this.facing;
    }

    @SuppressLint(value={"InlinedApi"})
    private Camera createCamera() throws IOException {
        int requestedCameraId = CameraSource.getIdForRequestedCamera(this.facing);
        if (requestedCameraId == -1) {
            throw new IOException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)requestedCameraId);
        SizePair sizePair = CameraSource.selectSizePair(camera, 960, 720);
        if (sizePair == null) {
            throw new IOException("Could not find suitable preview size.");
        }
        Size pictureSize = sizePair.pictureSize();
        this.previewSize = sizePair.previewSize();
        int[] previewFpsRange = CameraSource.selectPreviewFpsRange(camera, 20.0f);
        if (previewFpsRange == null) {
            throw new IOException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters = camera.getParameters();
        if (pictureSize != null) {
            parameters.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
        }
        parameters.setPreviewSize(this.previewSize.getWidth(), this.previewSize.getHeight());
        parameters.setPreviewFpsRange(previewFpsRange[0], previewFpsRange[1]);
        parameters.setPreviewFormat(17);
        this.setRotation(camera, parameters, requestedCameraId);
        if (parameters.getSupportedFocusModes().contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        } else {
            Log.i((String)TAG, (String)"Camera auto focus is not supported on this device.");
        }
        camera.setParameters(parameters);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new CameraPreviewCallback());
        camera.addCallbackBuffer(this.createPreviewBuffer(this.previewSize));
        camera.addCallbackBuffer(this.createPreviewBuffer(this.previewSize));
        camera.addCallbackBuffer(this.createPreviewBuffer(this.previewSize));
        camera.addCallbackBuffer(this.createPreviewBuffer(this.previewSize));
        return camera;
    }

    private void setRotation(Camera camera, Camera.Parameters parameters, int cameraId) {
        int displayAngle;
        int angle;
        WindowManager windowManager = (WindowManager)this.activity.getSystemService("window");
        int degrees = 0;
        int rotation = windowManager.getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Bad rotation value: " + rotation));
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            angle = (cameraInfo.orientation + degrees) % 360;
            displayAngle = (360 - angle) % 360;
        } else {
            displayAngle = angle = (cameraInfo.orientation - degrees + 360) % 360;
        }
        this.rotation = angle / 90;
        camera.setDisplayOrientation(displayAngle);
        parameters.setRotation(angle);
    }

    @SuppressLint(value={"InlinedApi"})
    private byte[] createPreviewBuffer(Size previewSize) {
        int bitsPerPixel = ImageFormat.getBitsPerPixel((int)17);
        long sizeInBits = (long)previewSize.getHeight() * (long)previewSize.getWidth() * (long)bitsPerPixel;
        int bufferSize = (int)Math.ceil((double)sizeInBits / 8.0) + 1;
        byte[] byteArray = new byte[bufferSize];
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        if (!buffer.hasArray() || buffer.array() != byteArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.bytesToByteBuffer.put(byteArray, buffer);
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMachineLearningFrameProcessor(VisionImageProcessor processor) {
        Object object = this.processorLock;
        synchronized (object) {
            this.cleanScreen();
            if (this.frameProcessor != null) {
                this.frameProcessor.stop();
            }
            this.frameProcessor = processor;
        }
    }

    private void cleanScreen() {
        this.graphicOverlay.clear();
    }

    private class FrameProcessingRunnable
    implements Runnable {
        private final Object lock = new Object();
        private boolean active = true;
        private ByteBuffer pendingFrameData;

        FrameProcessingRunnable() {
        }

        @SuppressLint(value={"Assert"})
        void release() {
            assert (CameraSource.this.processingThread.getState() == Thread.State.TERMINATED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setActive(boolean active) {
            Object object = this.lock;
            synchronized (object) {
                this.active = active;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setNextFrame(byte[] data, Camera camera) {
            Object object = this.lock;
            synchronized (object) {
                if (this.pendingFrameData != null) {
                    camera.addCallbackBuffer(this.pendingFrameData.array());
                    this.pendingFrameData = null;
                }
                if (!CameraSource.this.bytesToByteBuffer.containsKey(data)) {
                    Log.d((String)CameraSource.TAG, (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.pendingFrameData = (ByteBuffer)CameraSource.this.bytesToByteBuffer.get(data);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public void run() {
            while (true) {
                ByteBuffer data;
                Object object = this.lock;
                synchronized (object) {
                    while (this.active && this.pendingFrameData == null) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException e) {
                            Log.d((String)CameraSource.TAG, (String)"Frame processing loop terminated.", (Throwable)e);
                            return;
                        }
                    }
                    if (!this.active) {
                        return;
                    }
                    data = this.pendingFrameData;
                    this.pendingFrameData = null;
                }
                try {
                    object = CameraSource.this.processorLock;
                    synchronized (object) {
                        Log.d((String)CameraSource.TAG, (String)"Process an image");
                        CameraSource.this.frameProcessor.process(data, new FrameMetadata.Builder().setWidth(CameraSource.this.previewSize.getWidth()).setHeight(CameraSource.this.previewSize.getHeight()).setRotation(CameraSource.this.rotation).setCameraFacing(CameraSource.this.facing).build(), CameraSource.this.graphicOverlay);
                        continue;
                    }
                }
                catch (Throwable t) {
                    Log.e((String)CameraSource.TAG, (String)"Exception thrown from receiver.", (Throwable)t);
                    continue;
                }
                finally {
                    CameraSource.this.camera.addCallbackBuffer(data.array());
                    continue;
                }
                break;
            }
        }
    }

    private class CameraPreviewCallback
    implements Camera.PreviewCallback {
        private CameraPreviewCallback() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            CameraSource.this.processingRunnable.setNextFrame(data, camera);
        }
    }

    private static class SizePair {
        private final Size preview;
        private Size picture;

        SizePair(Camera.Size previewSize, @Nullable Camera.Size pictureSize) {
            this.preview = new Size(previewSize.width, previewSize.height);
            if (pictureSize != null) {
                this.picture = new Size(pictureSize.width, pictureSize.height);
            }
        }

        Size previewSize() {
            return this.preview;
        }

        @Nullable
        Size pictureSize() {
            return this.picture;
        }
    }
}

