/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.customviews.MaterialTextInputLayout;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.CarouselAdapter;
import com.vijay.jsonwizard.utils.CarouselItem;
import com.vijay.jsonwizard.utils.ExpressionResolverContextUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.yarolegovich.discretescrollview.DSVOrientation;
import com.yarolegovich.discretescrollview.DiscreteScrollView;
import com.yarolegovich.discretescrollview.transform.DiscreteScrollItemTransformer;
import com.yarolegovich.discretescrollview.transform.ScaleTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CarouselFactory
implements FormWidgetFactory {
    private static final String TAG = "CarouselFactory";

    public static ValidationStatus validate(DiscreteScrollView dsv) {
        if (!(dsv.getTag(R.id.v_required) instanceof String) || !(dsv.getTag(R.id.error) instanceof String)) {
            return new ValidationStatus(true, null);
        }
        Boolean isRequired = Boolean.valueOf((String)dsv.getTag(R.id.v_required));
        if (!isRequired.booleanValue()) {
            return new ValidationStatus(true, null);
        }
        int selectedItemPosition = dsv.getCurrentItem();
        if (selectedItemPosition > 0) {
            return new ValidationStatus(true, null);
        }
        return new ValidationStatus(false, (String)dsv.getTag(R.id.error));
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(stepName, context, jsonObject, listener, bundle, resolver, resourceResolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver) throws JSONException {
        JSONArray imagesJson;
        String requiredValue;
        ArrayList<View> views = new ArrayList<View>(1);
        DiscreteScrollView scrollView = (DiscreteScrollView)LayoutInflater.from((Context)context).inflate(R.layout.item_carousel, null);
        scrollView.setId(View.generateViewId());
        scrollView.setTag(R.id.key, (Object)jsonObject.getString("key"));
        scrollView.setTag(R.id.type, (Object)jsonObject.getString("type"));
        JSONObject requiredObject = jsonObject.optJSONObject("v_required");
        if (requiredObject != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            scrollView.setTag(R.id.v_required, (Object)requiredValue);
            scrollView.setTag(R.id.error, (Object)bundle.resolveKey(requiredObject.optString("err")));
        }
        String valueToSelect = "";
        int indexToSelect = -1;
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            valueToSelect = value;
        }
        String valuesExpression = this.getValuesAsJsonExpression(jsonObject, resolver);
        JSONArray valuesJson = null;
        if (valuesExpression == null) {
            valuesJson = jsonObject.optJSONArray("values");
        } else {
            JSONObject currentValues = this.getCurrentValues(context, stepName);
            valuesJson = resolver.resolveAsArray(valuesExpression, currentValues);
        }
        String imagesExpression = this.getImagesAsJsonExpression(jsonObject, resolver);
        if (imagesExpression == null) {
            imagesJson = jsonObject.optJSONArray("images");
        } else {
            JSONObject currentValues = this.getCurrentValues(context, stepName);
            imagesJson = resolver.resolveAsArray(imagesExpression, currentValues);
        }
        String[] values = this.getValues(valuesJson);
        String[] images = this.getValues(imagesJson);
        ArrayList<String> listValues = new ArrayList<String>(Arrays.asList(values));
        ArrayList<String> listNames = new ArrayList<String>(Arrays.asList(values));
        ArrayList<String> listImages = new ArrayList<String>(Arrays.asList(images));
        String otherOption = bundle.resolveKey(jsonObject.optString("other"));
        String chooseOption = bundle.resolveKey(jsonObject.optString("hint"));
        chooseOption = TextUtils.isEmpty((CharSequence)chooseOption) ? context.getString(R.string.image_picker) : chooseOption;
        listValues.add(0, null);
        listNames.add(0, chooseOption);
        listImages.add(0, Integer.toString(R.mipmap.choose_icon));
        if (!TextUtils.isEmpty((CharSequence)otherOption)) {
            listValues.add(otherOption);
            listNames.add(otherOption);
            listImages.add(Integer.toString(R.mipmap.other_icon));
        }
        values = listValues.toArray(values);
        indexToSelect = this.getSelectedIdx(values, valueToSelect);
        if (values != null && values.length > 1) {
            ArrayList<CarouselItem> data = new ArrayList<CarouselItem>();
            for (int i = 0; i < listValues.size(); ++i) {
                String imagePath = (String)listImages.get(i);
                if (!this.isInteger(imagePath)) {
                    imagePath = resourceResolver.resolvePath(context, imagePath);
                }
                data.add(new CarouselItem((String)listNames.get(i), (String)listValues.get(i), imagePath));
            }
            scrollView.setOrientation(DSVOrientation.HORIZONTAL);
            scrollView.setSlideOnFling(true);
            scrollView.setAdapter((RecyclerView.Adapter)new CarouselAdapter(data));
            scrollView.addOnItemChangedListener((DiscreteScrollView.OnItemChangedListener)listener);
            scrollView.scrollToPosition(indexToSelect);
            scrollView.setItemTransitionTimeMillis(120);
            scrollView.setItemTransformer((DiscreteScrollItemTransformer)new ScaleTransformer.Builder().setMinScale(0.8f).build());
        }
        views.add((View)scrollView);
        return views;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context, String stepName) throws JSONException {
        return ExpressionResolverContextUtils.getCurrentValues(context, stepName);
    }

    private String[] getValues(JSONArray valuesJson) {
        String[] values = null;
        if (valuesJson != null && valuesJson.length() > 0) {
            int valuesJsonLength = valuesJson.length();
            values = new String[valuesJsonLength];
            for (int i = 0; i < valuesJsonLength; ++i) {
                values[i] = valuesJson.optString(i);
            }
        }
        return values;
    }

    private int getSelectedIdx(String[] values, String valueToSelect) {
        int indexToSelect = -1;
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                if (!valueToSelect.equals(values[i])) continue;
                indexToSelect = i;
                break;
            }
        }
        return indexToSelect;
    }

    private String getValuesAsJsonExpression(JSONObject jsonObject, JsonExpressionResolver resolver) {
        String valuesExpression = jsonObject.optString("values");
        if (resolver.isValidExpression(valuesExpression)) {
            return valuesExpression;
        }
        return null;
    }

    private String getImagesAsJsonExpression(JSONObject jsonObject, JsonExpressionResolver resolver) {
        String valuesExpression = jsonObject.optString("images");
        if (resolver.isValidExpression(valuesExpression)) {
            return valuesExpression;
        }
        return null;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialTextInputLayout textInputLayout = (MaterialTextInputLayout)LayoutInflater.from((Context)context).inflate(R.layout.item_material_edit_text, null);
        EditText editText = textInputLayout.getEditText();
        editText.setId(View.generateViewId());
        textInputLayout.setTag(R.id.key, jsonObject.getString("key"));
        textInputLayout.setTag(R.id.type, jsonObject.getString("type"));
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        editText.setText((CharSequence)jsonObject.optString("value"));
        editText.setEnabled(false);
        views.add((View)textInputLayout);
        return views;
    }

    private boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

