/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceViewerFactory
implements FormWidgetFactory {
    private static final String TAG = "ResourceViewerWidget";

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws Exception {
        String resourcePath;
        ArrayList<View> views = new ArrayList<View>(1);
        View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_resource_label, null);
        RelativeLayout wrapper = (RelativeLayout)parentView.findViewById(R.id.wrapper);
        wrapper.setTag(R.id.type, (Object)"resource_view");
        TextView label = (TextView)parentView.findViewById(R.id.label);
        ImageView icon = (ImageView)parentView.findViewById(R.id.icon);
        String resource = jsonObject.getString("resource");
        if (resolver.isValidExpression(resource)) {
            JSONObject currentValues = this.getCurrentValues(context);
            resource = resolver.resolveAsString(resource, currentValues);
        }
        if ((resourcePath = resourceResolver.resolvePath(context, resource)) != null && new File(resourcePath).exists()) {
            wrapper.setTag(R.id.value, (Object)resourcePath);
        } else {
            wrapper.setTag(R.id.value, (Object)resource);
        }
        String labelText = bundle.resolveKey(jsonObject.optString("label"));
        String iconPath = bundle.resolveKey(jsonObject.optString("icon"));
        if (resolver.isValidExpression(labelText)) {
            JSONObject currentValues = this.getCurrentValues(context);
            labelText = resolver.resolveAsString(labelText, currentValues);
        } else {
            labelText = bundle.resolveKey(labelText);
        }
        wrapper.setTag(R.id.label, (Object)labelText);
        wrapper.setOnClickListener((View.OnClickListener)listener);
        if (TextUtils.isEmpty((CharSequence)labelText) && TextUtils.isEmpty((CharSequence)iconPath)) {
            Log.w((String)TAG, (String)"A resource_viewer widget should have at leas one of 'icon' or 'label' properties");
        } else {
            label.setText((CharSequence)labelText);
            if (!TextUtils.isEmpty((CharSequence)iconPath)) {
                String path = resourceResolver.resolvePath(context, iconPath);
                Bitmap bitmap = BitmapFactory.decodeFile((String)path);
                icon.setImageBitmap(bitmap);
            }
            if (jsonObject.has("config")) {
                JSONObject config;
                String expression = jsonObject.optString("config");
                if (resolver.isValidExpression(expression)) {
                    JSONObject currentValues = this.getCurrentValues(context);
                    config = resolver.resolveAsObject(expression, currentValues);
                } else {
                    config = jsonObject.getJSONObject("config");
                }
                this.configure(context, wrapper, label, icon, config);
            }
        }
        views.add(parentView);
        return views;
    }

    private void configure(Context context, RelativeLayout wrapper, TextView label, ImageView icon, JSONObject config) {
        Double size;
        String color2 = config.optString("color");
        int colorValue = -16776961;
        if (!TextUtils.isEmpty((CharSequence)color2)) {
            colorValue = Color.parseColor((String)color2);
        }
        label.setTextColor(colorValue);
        String iconColor = config.optString("icon_color");
        if (!TextUtils.isEmpty((CharSequence)iconColor)) {
            icon.setColorFilter(Color.parseColor((String)iconColor));
        }
        if ((size = Double.valueOf(config.optDouble("size"))) != null) {
            label.setTextSize(size.floatValue());
        }
        Integer iconWidth = config.optInt("icon_width");
        Integer iconHeight = config.optInt("icon_height");
        int width = -2;
        if (iconWidth != null) {
            width = (int)this.dpsToPx(context, iconWidth);
        }
        int height = -2;
        if (iconHeight != null) {
            height = (int)this.dpsToPx(context, iconHeight);
        }
        RelativeLayout.LayoutParams iconParams = new RelativeLayout.LayoutParams(width, height);
        RelativeLayout.LayoutParams labelParams = new RelativeLayout.LayoutParams(-2, -2);
        String iconAlignment = config.optString("icon_position");
        Integer marginVal = config.optInt("icon_margin", 8);
        int margin = (int)this.dpsToPx(context, marginVal);
        switch (iconAlignment) {
            case "start": {
                iconParams.addRule(15, -1);
                iconParams.setMarginEnd(margin);
                labelParams.addRule(17, R.id.icon);
                labelParams.addRule(15, -1);
                break;
            }
            case "bottom": {
                iconParams.addRule(14, -1);
                iconParams.addRule(3, R.id.label);
                iconParams.topMargin = margin;
                labelParams.addRule(14, -1);
                break;
            }
            case "end": {
                iconParams.addRule(15, -1);
                iconParams.addRule(17, R.id.label);
                iconParams.setMarginStart(margin);
                labelParams.addRule(15, -1);
                break;
            }
            default: {
                iconParams.addRule(14, -1);
                iconParams.bottomMargin = margin;
                labelParams.addRule(3, R.id.icon);
                labelParams.addRule(14, -1);
            }
        }
        icon.setLayoutParams((ViewGroup.LayoutParams)iconParams);
        label.setLayoutParams((ViewGroup.LayoutParams)labelParams);
        String alignment = config.optString("align");
        if (!TextUtils.isEmpty((CharSequence)alignment)) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            switch (alignment) {
                case "end": {
                    params.gravity = 0x800005;
                    break;
                }
                case "start": {
                    params.gravity = 0x800003;
                    break;
                }
                default: {
                    params.gravity = 17;
                }
            }
            wrapper.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }

    private float dpsToPx(Context context, int value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

