/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.barcode.barcodescanning;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.firebase.ml.common.FirebaseMLException;
import com.google.firebase.ml.vision.FirebaseVision;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcodeDetector;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.vijay.jsonwizard.barcode.VisionProcessorBase;
import com.vijay.jsonwizard.barcode.barcodescanning.BarcodeGraphic;
import com.vijay.jsonwizard.barcode.common.CameraImageGraphic;
import com.vijay.jsonwizard.barcode.common.FrameMetadata;
import com.vijay.jsonwizard.barcode.common.GraphicOverlay;
import java.io.IOException;
import java.util.List;

public class BarcodeScanningProcessor
extends VisionProcessorBase<List<FirebaseVisionBarcode>> {
    private static final String TAG = "BarcodeScanProc";
    private final FirebaseVisionBarcodeDetector detector = FirebaseVision.getInstance().getVisionBarcodeDetector();
    private boolean pause = false;
    private CameraImageGraphic lastImage = null;

    @Override
    public void stop() {
        try {
            this.detector.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Exception thrown while trying to close Barcode Detector: " + e));
        }
    }

    @Override
    protected Task<List<FirebaseVisionBarcode>> detectInImage(FirebaseVisionImage image) {
        return this.detector.detectInImage(image);
    }

    @Override
    protected void onSuccess(@Nullable Bitmap originalCameraImage, @NonNull List<FirebaseVisionBarcode> barcodes, @NonNull FrameMetadata frameMetadata, @NonNull GraphicOverlay graphicOverlay) {
        if (!this.pause) {
            graphicOverlay.clear();
            if (originalCameraImage != null) {
                CameraImageGraphic imageGraphic = new CameraImageGraphic(graphicOverlay, originalCameraImage);
                graphicOverlay.add(imageGraphic);
                this.lastImage = imageGraphic;
            }
            for (int i = 0; i < barcodes.size(); ++i) {
                FirebaseVisionBarcode barcode = barcodes.get(i);
                BarcodeGraphic barcodeGraphic = new BarcodeGraphic(graphicOverlay, barcode);
                graphicOverlay.add(barcodeGraphic);
            }
        }
        graphicOverlay.postInvalidate();
    }

    @Override
    protected void onFailure(@NonNull Exception e) {
        FirebaseMLException mle;
        if (!(e instanceof FirebaseMLException) || (mle = (FirebaseMLException)e).getCode() == 14) {
            // empty if block
        }
        Log.e((String)TAG, (String)("Barcode detection failed " + e));
    }

    @Override
    public void pause() {
        this.pause = true;
    }

    public CameraImageGraphic getLastImage() {
        return this.lastImage;
    }
}

