/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.barcode.barcodescanning;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.google.firebase.ml.vision.barcode.FirebaseVisionBarcode;
import com.vijay.jsonwizard.barcode.common.GraphicOverlay;

public class BarcodeGraphic
extends GraphicOverlay.Graphic {
    private static final int TEXT_COLOR = -1;
    private static final float TEXT_SIZE = 54.0f;
    private static final float STROKE_WIDTH = 4.0f;
    private final Paint rectPaint;
    private final Paint barcodePaint;
    private final FirebaseVisionBarcode barcode;
    private RectF rect;
    private Rect textRect;

    BarcodeGraphic(GraphicOverlay overlay, FirebaseVisionBarcode barcode) {
        super(overlay);
        this.barcode = barcode;
        this.rectPaint = new Paint();
        this.rectPaint.setColor(-1);
        this.rectPaint.setStyle(Paint.Style.STROKE);
        this.rectPaint.setStrokeWidth(4.0f);
        this.barcodePaint = new Paint();
        this.barcodePaint.setColor(-1);
        this.barcodePaint.setTextSize(54.0f);
        this.rect = new RectF(barcode.getBoundingBox());
        this.rect.left = this.translateX(this.rect.left);
        this.rect.top = this.translateY(this.rect.top);
        this.rect.right = this.translateX(this.rect.right);
        this.rect.bottom = this.translateY(this.rect.bottom);
        this.textRect = new Rect();
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.barcode == null) {
            throw new IllegalStateException("Attempting to draw a null barcode.");
        }
        canvas.drawRect(this.rect, this.rectPaint);
        String text = this.barcode.getRawValue();
        this.barcodePaint.getTextBounds(text, 0, text.length(), this.textRect);
        this.textRect.left = (int)((float)this.textRect.left + this.rect.left);
        this.textRect.right = (int)((float)this.textRect.right + this.rect.left);
        this.textRect.top = (int)((float)this.textRect.top + this.rect.bottom);
        this.textRect.bottom = (int)((float)this.textRect.bottom + this.rect.bottom);
        canvas.drawText(text, this.rect.left, this.rect.bottom, this.barcodePaint);
    }

    public void removeHighlight() {
        this.rectPaint.setColor(-1);
        this.barcodePaint.setColor(-1);
    }

    public void highlight() {
        this.rectPaint.setColor(-65536);
        this.barcodePaint.setColor(-65536);
    }

    public FirebaseVisionBarcode getBarcode() {
        return this.barcode;
    }

    public boolean contains(float x, float y) {
        return this.rect.contains(x, y) || this.textRect.contains((int)x, (int)y);
    }
}

