/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.maps;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.location.SettingsClient;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.maps.MapsUtils;

public class MapsActivity
extends AppCompatActivity
implements OnMapReadyCallback {
    public static final String EXTRA_INITIAL_LOCATION = "INITIAL_LOCATION";
    public static final String EXTRA_USE_ACCURACY = "USE_ACCURACY";
    public static final String EXTRA_RESULT_LOCATION = "RESULT_LOCATION";
    public static final String EXTRA_CUSTOM_MARKER_ICON = "CUSTOM_MARKER_ICON";
    private static final String TAG = "JsonFormActivity";
    private static final int REQUEST_CODE_LOCATION = 80;
    private static final int REQUEST_CHECK_SETTINGS = 801;
    private GoogleMap mMap;
    private String mInitialPos;
    private String mMarkerPosition;
    private Marker mMarker;
    private boolean mIncludeAccuracy;
    private String mMarkerIcon;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_maps);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.tb_top);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setTitle(R.string.choose_a_location);
        Intent intent = this.getIntent();
        this.mIncludeAccuracy = intent.getBooleanExtra(EXTRA_USE_ACCURACY, false);
        if (intent.hasExtra(EXTRA_INITIAL_LOCATION)) {
            try {
                this.mInitialPos = intent.getStringExtra(EXTRA_INITIAL_LOCATION);
            }
            catch (IllegalArgumentException e) {
                Log.w((String)TAG, (String)"Invalid initial position", (Throwable)e);
                this.attemptMarkCurrentLocation();
            }
        } else {
            this.attemptMarkCurrentLocation();
        }
        if (intent.hasExtra(EXTRA_CUSTOM_MARKER_ICON)) {
            this.mMarkerIcon = intent.getStringExtra(EXTRA_CUSTOM_MARKER_ICON);
        }
        SupportMapFragment mapFragment = (SupportMapFragment)this.getSupportFragmentManager().findFragmentById(R.id.map);
        mapFragment.getMapAsync((OnMapReadyCallback)this);
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 801) {
            if (resultCode == -1) {
                this.attemptMarkCurrentLocation();
            } else {
                this.markDefaultPosition();
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.menu_location_picker, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_choose) {
            Intent data = new Intent();
            data.putExtra(EXTRA_RESULT_LOCATION, this.mMarkerPosition);
            this.setResult(-1, data);
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 80) {
            boolean grantedAny = false;
            for (int grantResult : grantResults) {
                if (grantResult != 0) continue;
                grantedAny = true;
                break;
            }
            if (grantedAny) {
                this.attemptMarkCurrentLocation();
            } else {
                Log.w((String)TAG, (String)"Current location permission not granted");
                this.markDefaultPosition();
            }
        }
    }

    public void onMapReady(GoogleMap googleMap) {
        this.mMap = googleMap;
        this.mMap.setMinZoomPreference(8.0f);
        this.mMap.setMaxZoomPreference(18.0f);
        if (this.mInitialPos != null) {
            this.updateMapMarker(this.mInitialPos, true);
        }
        this.mMap.setOnCameraMoveListener(new GoogleMap.OnCameraMoveListener(){

            public void onCameraMove() {
                MapsActivity.this.mMarkerPosition = MapsActivity.this.getPositionWithOptionalAccuracy(((MapsActivity)MapsActivity.this).mMap.getCameraPosition().target, -1.0f);
                MapsActivity.this.updateMapMarker(MapsActivity.this.mMarkerPosition, false);
            }
        });
    }

    private void attemptMarkCurrentLocation() {
        if (!this.checkPermission("android.permission.ACCESS_FINE_LOCATION") && !this.checkPermission("android.permission.ACCESS_COARSE_LOCATION")) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.requestPermissions(new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"}, 80);
            } else {
                this.markDefaultPosition();
            }
        } else {
            FusedLocationProviderClient fusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)this);
            fusedLocationClient.getLastLocation().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Location>(){

                public void onComplete(@NonNull Task<Location> task) {
                    Location location = (Location)task.getResult();
                    if (location != null) {
                        MapsActivity.this.updateMarkerLocation(location);
                    } else {
                        Log.w((String)MapsActivity.TAG, (String)"Could not obtain last location", (Throwable)task.getException());
                        MapsActivity.this.initLocationRequest();
                    }
                }
            });
        }
    }

    private void markDefaultPosition() {
        String position;
        String defaultLocation = this.getResources().getString(R.string.default_location);
        if (MapsUtils.isValidPositionString(defaultLocation)) {
            LatLng latLng = MapsUtils.parse(defaultLocation);
            position = this.getPositionWithOptionalAccuracy(latLng, 0.0f);
        } else {
            position = this.getPositionWithOptionalAccuracy(new LatLng(0.0, 0.0), 0.0f);
        }
        this.updateMapMarker(position, true);
    }

    private void updateMarkerLocation(Location location) {
        double lat = location.getLatitude();
        double lng = location.getLongitude();
        LatLng latLng = new LatLng(lat, lng);
        float accuracy = location.getAccuracy();
        this.mInitialPos = this.getPositionWithOptionalAccuracy(latLng, accuracy);
        this.updateMapMarker(this.mInitialPos, true);
    }

    private void initLocationRequest() {
        final LocationRequest locationRequest = LocationRequest.create();
        locationRequest.setInterval(5000L);
        locationRequest.setFastestInterval(500L);
        locationRequest.setPriority(100);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
        SettingsClient client = LocationServices.getSettingsClient((Activity)this);
        client.checkLocationSettings(builder.build()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<LocationSettingsResponse>(){

            @SuppressLint(value={"MissingPermission"})
            public void onSuccess(LocationSettingsResponse locationSettingsResponse) {
                Log.e((String)MapsActivity.TAG, (String)"Location settings OK");
                MapsActivity.this.requestCurrentLocation(locationRequest);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                Log.e((String)MapsActivity.TAG, (String)"Invalid location settings", (Throwable)e);
                if (e instanceof ResolvableApiException) {
                    try {
                        ResolvableApiException resolvable = (ResolvableApiException)e;
                        resolvable.startResolutionForResult((Activity)MapsActivity.this, 801);
                    }
                    catch (IntentSender.SendIntentException sendIntentException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @SuppressLint(value={"MissingPermission"})
    private void requestCurrentLocation(LocationRequest locationRequest) {
        final FusedLocationProviderClient fusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)this);
        LocationCallback locationCallback = new LocationCallback(){

            public void onLocationAvailability(LocationAvailability locationAvailability) {
                Log.d((String)MapsActivity.TAG, (String)("location available: " + locationAvailability.isLocationAvailable()));
            }

            public void onLocationResult(LocationResult locationResult) {
                Log.d((String)MapsActivity.TAG, (String)"Obtained location result");
                if (locationResult != null) {
                    MapsActivity.this.updateMarkerLocation(locationResult.getLastLocation());
                    fusedLocationClient.removeLocationUpdates((LocationCallback)this);
                }
            }
        };
        fusedLocationClient.requestLocationUpdates(locationRequest, locationCallback, Looper.getMainLooper()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void onSuccess(Void aVoid) {
                Log.d((String)MapsActivity.TAG, (String)"Location request updates started");
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                Log.e((String)MapsActivity.TAG, (String)"Location request updates failed to start", (Throwable)e);
            }
        });
    }

    private boolean checkPermission(String permission2) {
        return ActivityCompat.checkSelfPermission((Context)this, (String)permission2) == 0;
    }

    private void updateMapMarker(String markerPosition, boolean repositionCamera) {
        if (this.mMap != null) {
            LatLng latLng = MapsUtils.parse(markerPosition);
            if (this.mMarker == null) {
                this.mMap.clear();
                MarkerOptions markerOptions = new MarkerOptions().position(latLng);
                if (this.mMarkerIcon != null) {
                    markerOptions.icon(BitmapDescriptorFactory.fromPath((String)this.mMarkerIcon));
                }
                this.mMarker = this.mMap.addMarker(markerOptions);
            } else {
                this.mMarker.setPosition(latLng);
            }
            if (repositionCamera) {
                CameraPosition pos = CameraPosition.builder().target(latLng).zoom(18.0f).build();
                this.mMap.moveCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)pos));
            }
            this.mMarkerPosition = markerPosition;
        }
    }

    private String getPositionWithOptionalAccuracy(LatLng latLng, float accuracy) {
        if (this.mIncludeAccuracy) {
            return MapsUtils.toString(latLng, accuracy);
        }
        return MapsUtils.toString(latLng);
    }
}

