/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.barcode;

import android.graphics.Bitmap;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.ml.vision.common.FirebaseVisionImage;
import com.google.firebase.ml.vision.common.FirebaseVisionImageMetadata;
import com.vijay.jsonwizard.barcode.common.BitmapUtils;
import com.vijay.jsonwizard.barcode.common.FrameMetadata;
import com.vijay.jsonwizard.barcode.common.GraphicOverlay;
import com.vijay.jsonwizard.barcode.common.VisionImageProcessor;
import java.nio.ByteBuffer;

public abstract class VisionProcessorBase<T>
implements VisionImageProcessor {
    @GuardedBy(value="this")
    private ByteBuffer latestImage;
    @GuardedBy(value="this")
    private FrameMetadata latestImageMetaData;
    @GuardedBy(value="this")
    private ByteBuffer processingImage;
    @GuardedBy(value="this")
    private FrameMetadata processingMetaData;
    private boolean paused = false;

    @Override
    public synchronized void process(ByteBuffer data, FrameMetadata frameMetadata, GraphicOverlay graphicOverlay) {
        this.latestImage = data;
        this.latestImageMetaData = frameMetadata;
        if (this.processingImage == null && this.processingMetaData == null) {
            this.processLatestImage(graphicOverlay);
        }
    }

    @Override
    public void process(Bitmap bitmap, GraphicOverlay graphicOverlay) {
        this.detectInVisionImage(null, FirebaseVisionImage.fromBitmap((Bitmap)bitmap), null, graphicOverlay);
    }

    private synchronized void processLatestImage(GraphicOverlay graphicOverlay) {
        this.processingImage = this.latestImage;
        this.processingMetaData = this.latestImageMetaData;
        this.latestImage = null;
        this.latestImageMetaData = null;
        if (this.processingImage != null && this.processingMetaData != null) {
            this.processImage(this.processingImage, this.processingMetaData, graphicOverlay);
        }
    }

    private void processImage(ByteBuffer data, FrameMetadata frameMetadata, GraphicOverlay graphicOverlay) {
        FirebaseVisionImageMetadata metadata = new FirebaseVisionImageMetadata.Builder().setFormat(17).setWidth(frameMetadata.getWidth()).setHeight(frameMetadata.getHeight()).setRotation(frameMetadata.getRotation()).build();
        Bitmap bitmap = BitmapUtils.getBitmap(data, frameMetadata);
        this.detectInVisionImage(bitmap, FirebaseVisionImage.fromByteBuffer((ByteBuffer)data, (FirebaseVisionImageMetadata)metadata), frameMetadata, graphicOverlay);
    }

    private void detectInVisionImage(final Bitmap originalCameraImage, FirebaseVisionImage image, final FrameMetadata metadata, final GraphicOverlay graphicOverlay) {
        this.detectInImage(image).addOnSuccessListener(new OnSuccessListener<T>(){

            public void onSuccess(T results) {
                VisionProcessorBase.this.onSuccess(originalCameraImage, results, metadata, graphicOverlay);
                VisionProcessorBase.this.processLatestImage(graphicOverlay);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                VisionProcessorBase.this.onFailure(e);
            }
        });
    }

    @Override
    public void pause() {
    }

    @Override
    public void stop() {
    }

    protected abstract Task<T> detectInImage(FirebaseVisionImage var1);

    protected abstract void onSuccess(@Nullable Bitmap var1, @NonNull T var2, @NonNull FrameMetadata var3, @NonNull GraphicOverlay var4);

    protected abstract void onFailure(@NonNull Exception var1);
}

