/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rengwuxian.materialedittext.validation.METValidator;
import com.rey.material.util.ViewUtil;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.maps.LocationPart;
import com.vijay.jsonwizard.maps.LocationTextWatcher;
import com.vijay.jsonwizard.maps.LocationValueReporter;
import com.vijay.jsonwizard.maps.MapsUtils;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import com.vijay.jsonwizard.validators.edittext.EqualsValidator;
import com.vijay.jsonwizard.validators.edittext.RequiredValidator;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationPickerFactory
implements FormWidgetFactory {
    public static final String KEY_SUFFIX_LATITUDE = "_latitude";
    public static final String KEY_SUFFIX_LONGITUDE = "_longitude";
    public static final String KEY_SUFFIX_ACCURACY = "_accuracy";
    private static final String TAG = "JsonFormActivity";
    private static final int INPUT_TYPE_DECIMAL_NUMBER = 12290;

    public static ValidationStatus validate(MaterialEditText editText) {
        boolean validate = editText.validate();
        if (!validate) {
            return new ValidationStatus(false, editText.getError().toString());
        }
        return new ValidationStatus(true, null);
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws Exception {
        List<View> views;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle, resourceResolver);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(stepName, context, jsonObject, listener, bundle, resolver, resourceResolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver) throws JSONException {
        String requiredValue;
        JSONObject requiredObject;
        String readonlyValue = jsonObject.optString("readonly");
        boolean readonly = false;
        if (resolver.isValidExpression(readonlyValue)) {
            JSONObject currentValues = this.getCurrentValues(context);
            readonly = resolver.existsExpression(readonlyValue, currentValues);
        } else {
            readonly = Boolean.TRUE.toString().equalsIgnoreCase(readonlyValue);
        }
        if (readonly) {
            return this.getReadOnlyViewsFromJson(context, jsonObject, bundle, resourceResolver);
        }
        String jsonKey = jsonObject.getString("key");
        String jsonInputType = jsonObject.getString("type");
        ArrayList<View> views = new ArrayList<View>(1);
        View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_location_text, null);
        parentView.setTag(R.id.key, (Object)jsonKey);
        parentView.setTag(R.id.type, (Object)jsonInputType);
        boolean accuracyEnabled = jsonObject.has("accuracy") && jsonObject.getBoolean("accuracy");
        parentView.setTag(R.id.accuracy, (Object)accuracyEnabled);
        if (jsonObject.has("icon")) {
            String customIcon = jsonObject.getString("icon");
            customIcon = resourceResolver.resolvePath(context, customIcon);
            parentView.setTag(R.id.custom_icon, (Object)customIcon);
        }
        View mapContainer = parentView.findViewById(R.id.map_container);
        mapContainer.setId(View.generateViewId());
        mapContainer.setTag((Object)R.id.map_container);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        TextView label = (TextView)parentView.findViewById(R.id.location_label);
        label.setText((CharSequence)hint);
        View inputContainer = parentView.findViewById(R.id.value_container);
        inputContainer.setTag(R.id.key, (Object)jsonKey);
        inputContainer.setTag(R.id.type, (Object)jsonInputType);
        MaterialEditText etLatitude = (MaterialEditText)parentView.findViewById(R.id.location_latitude);
        etLatitude.setId(ViewUtil.generateViewId());
        etLatitude.setInputType(12290);
        etLatitude.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LATITUDE));
        etLatitude.setTag(R.id.type, (Object)jsonInputType);
        MaterialEditText etLongitude = (MaterialEditText)parentView.findViewById(R.id.location_longitude);
        etLongitude.setId(ViewUtil.generateViewId());
        etLongitude.setInputType(12290);
        etLongitude.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LONGITUDE));
        etLongitude.setTag(R.id.type, (Object)jsonInputType);
        MaterialEditText etAccuracy = (MaterialEditText)parentView.findViewById(R.id.location_accuracy);
        etAccuracy.setId(ViewUtil.generateViewId());
        etAccuracy.setInputType(12290);
        etAccuracy.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_ACCURACY));
        etAccuracy.setTag(R.id.type, (Object)jsonInputType);
        if (accuracyEnabled) {
            etAccuracy.setVisibility(0);
        } else {
            etAccuracy.setVisibility(8);
        }
        ImageView imageView = (ImageView)parentView.findViewById(R.id.icon);
        String key = jsonKey;
        imageView.setTag(R.id.key, (Object)jsonKey);
        imageView.setTag(R.id.type, (Object)jsonInputType);
        View.OnClickListener onClickListenerWithValue = this.getOnClickListenerWithValue(parentView, (EditText)etLatitude, (EditText)etLongitude, (EditText)etAccuracy, listener, accuracyEnabled);
        imageView.setOnClickListener(onClickListenerWithValue);
        mapContainer.setOnClickListener(onClickListenerWithValue);
        String value = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)value)) {
            String customIcon = null;
            if (jsonObject.has("icon")) {
                customIcon = jsonObject.getString("icon");
                customIcon = resourceResolver.resolvePath(context, customIcon);
            }
            this.fillDefaultValue(context, etLatitude, etLongitude, etAccuracy, mapContainer.getId(), key, value, customIcon);
        }
        if ((requiredObject = jsonObject.optJSONObject("v_required")) != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            boolean required = false;
            if (resolver.isValidExpression(requiredValue)) {
                JSONObject currentValues = this.getCurrentValues(context);
                required = resolver.existsExpression(requiredValue, currentValues);
            } else {
                required = Boolean.TRUE.toString().equalsIgnoreCase(requiredValue);
            }
            if (required) {
                etLatitude.addValidator((METValidator)new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
                etLongitude.addValidator((METValidator)new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
                if (accuracyEnabled) {
                    etAccuracy.addValidator((METValidator)new RequiredValidator(bundle.resolveKey(requiredObject.getString("err"))));
                }
            }
        }
        JSONObject accuracyValidator = jsonObject.optJSONObject("v_exact_position");
        if (accuracyEnabled && accuracyValidator != null) {
            etAccuracy.addValidator((METValidator)new EqualsValidator("-1", bundle.resolveKey(accuracyValidator.getString("err")), true));
        }
        LocationValueReporter valueReporter = TextUtils.isEmpty((CharSequence)value) ? new LocationValueReporter(stepName, parentView, accuracyEnabled) : new LocationValueReporter(stepName, parentView, value, accuracyEnabled);
        etLatitude.addTextChangedListener((TextWatcher)new LocationTextWatcher(LocationPart.LATITUDE, valueReporter));
        etLongitude.addTextChangedListener((TextWatcher)new LocationTextWatcher(LocationPart.LONGITUDE, valueReporter));
        if (accuracyEnabled) {
            etAccuracy.addTextChangedListener((TextWatcher)new LocationTextWatcher(LocationPart.ACCURACY, valueReporter));
        }
        views.add(parentView);
        return views;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle, ResourceResolver resourceResolver) throws JSONException {
        String value;
        boolean accuracyEnabled;
        ArrayList<View> views = new ArrayList<View>(1);
        View parentView = LayoutInflater.from((Context)context).inflate(R.layout.item_location_text, null);
        View mapContainer = parentView.findViewById(R.id.map_container);
        mapContainer.setId(View.generateViewId());
        mapContainer.setTag((Object)R.id.map_container);
        String hint = bundle.resolveKey(jsonObject.getString("hint"));
        TextView label = (TextView)parentView.findViewById(R.id.location_label);
        label.setText((CharSequence)hint);
        String jsonKey = jsonObject.getString("key");
        String jsonType = jsonObject.getString("type");
        MaterialEditText etLatitude = (MaterialEditText)parentView.findViewById(R.id.location_latitude);
        etLatitude.setId(ViewUtil.generateViewId());
        etLatitude.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LATITUDE));
        etLatitude.setTag(R.id.type, (Object)jsonType);
        etLatitude.setEnabled(false);
        MaterialEditText etLongitude = (MaterialEditText)parentView.findViewById(R.id.location_longitude);
        etLongitude.setId(ViewUtil.generateViewId());
        etLongitude.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_LONGITUDE));
        etLongitude.setTag(R.id.type, (Object)jsonType);
        etLongitude.setEnabled(false);
        MaterialEditText etAccuracy = (MaterialEditText)parentView.findViewById(R.id.location_accuracy);
        etAccuracy.setId(ViewUtil.generateViewId());
        etAccuracy.setTag(R.id.key, (Object)(jsonKey + KEY_SUFFIX_ACCURACY));
        etAccuracy.setTag(R.id.type, (Object)jsonType);
        etAccuracy.setEnabled(false);
        boolean bl = accuracyEnabled = jsonObject.has("accuracy") && jsonObject.getBoolean("accuracy");
        if (accuracyEnabled) {
            etAccuracy.setVisibility(0);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = jsonObject.optString("value")))) {
            String customIcon = null;
            if (jsonObject.has("icon")) {
                customIcon = jsonObject.getString("icon");
                customIcon = resourceResolver.resolvePath(context, customIcon);
            }
            this.fillDefaultValue(context, etLatitude, etLongitude, etAccuracy, mapContainer.getId(), jsonKey, value, customIcon);
        } else {
            mapContainer.setVisibility(8);
        }
        ImageView imageView = (ImageView)parentView.findViewById(R.id.icon);
        imageView.setClickable(false);
        imageView.setEnabled(false);
        imageView.setVisibility(8);
        views.add(parentView);
        return views;
    }

    private void fillDefaultValue(Context context, MaterialEditText etLatitude, MaterialEditText etLongitude, MaterialEditText etAccuracy, int mapContainerId, String key, String value, String customIcon) {
        String[] parts = value.split(",");
        if (parts.length > 0) {
            etLatitude.setText((CharSequence)parts[0].trim());
        }
        if (parts.length > 1) {
            etLongitude.setText((CharSequence)parts[1].trim());
        }
        if (parts.length > 2) {
            etAccuracy.setText((CharSequence)parts[2].trim());
        }
        if (context instanceof FragmentActivity) {
            MapsUtils.loadStaticMap((FragmentActivity)context, mapContainerId, key, value, customIcon);
        } else {
            Log.w((String)TAG, (String)"Context is not a FragmentActivity");
        }
    }

    private View.OnClickListener getOnClickListenerWithValue(final View parentView, final EditText etLatitude, final EditText etLongitude, final EditText etAccuracy, final CommonListener listener, final boolean accuracy) {
        return new View.OnClickListener(){

            public void onClick(View v) {
                String value = accuracy ? MapsUtils.toString(etLatitude.getText().toString(), etLongitude.getText().toString(), etAccuracy.getText().toString()) : MapsUtils.toString(etLatitude.getText().toString(), etLongitude.getText().toString());
                parentView.setTag(R.id.value, (Object)value);
                listener.onClick(parentView);
            }
        };
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }
}

