/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.utils.FormUtils;
import com.vijay.jsonwizard.utils.ImageUtils;
import com.vijay.jsonwizard.utils.ValidationStatus;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ImagePickerFactory
implements FormWidgetFactory {
    public static ValidationStatus validate(ImageView imageView) {
        if (!(imageView.getTag(R.id.v_required) instanceof String) || !(imageView.getTag(R.id.error) instanceof String)) {
            return new ValidationStatus(true, null);
        }
        Boolean isRequired = Boolean.valueOf((String)imageView.getTag(R.id.v_required));
        if (!isRequired.booleanValue()) {
            return new ValidationStatus(true, null);
        }
        Object path = imageView.getTag(R.id.imagePath);
        if (path instanceof String && !TextUtils.isEmpty((CharSequence)((String)path))) {
            return new ValidationStatus(true, null);
        }
        return new ValidationStatus(false, (String)imageView.getTag(R.id.error));
    }

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        String requiredValue;
        ArrayList<View> views = new ArrayList<View>(1);
        ImageView imageView = new ImageView(context);
        imageView.setImageDrawable(context.getResources().getDrawable(R.mipmap.grey_bg));
        imageView.setTag(R.id.key, (Object)jsonObject.getString("key"));
        imageView.setTag(R.id.type, (Object)jsonObject.getString("type"));
        JSONObject requiredObject = jsonObject.optJSONObject("v_required");
        if (requiredObject != null && !TextUtils.isEmpty((CharSequence)(requiredValue = requiredObject.getString("value")))) {
            imageView.setTag(R.id.v_required, (Object)requiredValue);
            imageView.setTag(R.id.error, (Object)bundle.resolveKey(requiredObject.optString("err")));
        }
        imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        imageView.setLayoutParams((ViewGroup.LayoutParams)FormUtils.getLayoutParams(-1, FormUtils.dpToPixels(context, 200.0f), 0, 0, 0, (int)context.getResources().getDimension(R.dimen.default_bottom_margin)));
        String imagePath = jsonObject.optString("value");
        if (!TextUtils.isEmpty((CharSequence)imagePath)) {
            imageView.setTag(R.id.imagePath, (Object)imagePath);
            imageView.setImageBitmap(ImageUtils.loadBitmapFromFile(imagePath, ImageUtils.getDeviceWidth(context), FormUtils.dpToPixels(context, 200.0f)));
        }
        views.add((View)imageView);
        Button uploadButton = new Button(context);
        uploadButton.setText((CharSequence)bundle.resolveKey(jsonObject.getString("uploadButtonText")));
        uploadButton.setLayoutParams((ViewGroup.LayoutParams)FormUtils.getLayoutParams(-2, -2, 0, 0, 0, (int)context.getResources().getDimension(R.dimen.default_bottom_margin)));
        uploadButton.setOnClickListener((View.OnClickListener)listener);
        uploadButton.setTag(R.id.key, (Object)jsonObject.getString("key"));
        uploadButton.setTag(R.id.type, (Object)jsonObject.getString("type"));
        views.add((View)uploadButton);
        return views;
    }
}

