/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;
import com.rengwuxian.materialedittext.MaterialEditText;
import com.rey.material.util.ViewUtil;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.customviews.RadioButton;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.utils.FormUtils;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RadioButtonFactory
implements FormWidgetFactory {
    private final String H_ORIENTATION_VALUE = "horizontal";

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(context, jsonObject, listener, bundle, resolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        views.add((View)FormUtils.getTextViewWith(context, 16, bundle.resolveKey(jsonObject.getString("label")), jsonObject.getString("key"), jsonObject.getString("type"), FormUtils.getLayoutParams(-1, -2, 0, 0, 0, 0), "font/Roboto-Bold.ttf"));
        String orientationStr = (String)jsonObject.get("orientation");
        boolean horizontal = "horizontal".equals(orientationStr);
        int layoutOrientation = horizontal ? 0 : 1;
        int layoutWidth = horizontal ? -2 : -1;
        JSONArray options = null;
        String valuesExpression = this.getValuesAsJsonExpression(jsonObject, resolver);
        if (valuesExpression != null) {
            JSONObject currentValues = this.getCurrentValues(context);
            options = resolver.resolveAsArray(valuesExpression, currentValues);
        } else {
            options = jsonObject.getJSONArray("options");
        }
        int optionsLength = options.length();
        if (optionsLength > 0) {
            RadioGroup rg = new RadioGroup(context);
            rg.setOrientation(layoutOrientation);
            for (int i = 0; i < optionsLength; ++i) {
                JSONObject item = options.getJSONObject(i);
                RadioButton radioButton = (RadioButton)LayoutInflater.from((Context)context).inflate(R.layout.item_radiobutton, null);
                radioButton.setId(i);
                radioButton.setText(bundle.resolveKey(item.getString("text")));
                radioButton.setTag(R.id.key, jsonObject.getString("key"));
                radioButton.setTag(R.id.type, jsonObject.getString("type"));
                radioButton.setTag(R.id.childKey, item.getString("key"));
                radioButton.setGravity(16);
                radioButton.setTextSize(16.0f);
                radioButton.setTypeface(Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"font/Roboto-Regular.ttf"));
                radioButton.setOnCheckedChangeListener(listener);
                if (!TextUtils.isEmpty((CharSequence)jsonObject.optString("value")) && jsonObject.optString("value").equals(item.getString("key"))) {
                    radioButton.setChecked(true);
                }
                radioButton.setLayoutParams((ViewGroup.LayoutParams)FormUtils.getLayoutParams(layoutWidth, -2, 0, 0, 0, (int)context.getResources().getDimension(R.dimen.extra_bottom_margin)));
                rg.addView((View)radioButton);
            }
            views.add((View)rg);
        }
        return views;
    }

    private String getValuesAsJsonExpression(JSONObject jsonObject, JsonExpressionResolver resolver) {
        String valuesExpression = jsonObject.optString("options");
        if (resolver.isValidExpression(valuesExpression)) {
            return valuesExpression;
        }
        return null;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        MaterialEditText editText = (MaterialEditText)LayoutInflater.from((Context)context).inflate(R.layout.item_edit_text, null);
        editText.setId(ViewUtil.generateViewId());
        String label = bundle.resolveKey(jsonObject.getString("label"));
        editText.setHint((CharSequence)label);
        editText.setFloatingLabelText((CharSequence)label);
        editText.setTag(R.id.key, (Object)jsonObject.getString("key"));
        editText.setTag(R.id.type, (Object)jsonObject.getString("type"));
        String value = jsonObject.optString("value");
        editText.setText((CharSequence)this.resolveValueText(value, jsonObject, bundle));
        editText.setEnabled(false);
        views.add((View)editText);
        return views;
    }

    private String resolveValueText(String value, JSONObject jsonObject, JsonFormBundle bundle) throws JSONException {
        String valueText = "";
        if (value != null && !"".equals(value)) {
            JSONArray options = jsonObject.getJSONArray("options");
            for (int i = 0; i < options.length(); ++i) {
                JSONObject item = options.getJSONObject(i);
                if (!value.equals(item.optString("key"))) continue;
                valueText = bundle.resolveKey(item.optString("text"));
                break;
            }
        }
        return valueText;
    }
}

