/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.widgets;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.customviews.CheckBox;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.FormWidgetFactory;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.utils.FormUtils;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckBoxFactory
implements FormWidgetFactory {
    private static final String TAG = "CheckBoxFactory";

    @Override
    public List<View> getViewsFromJson(String stepName, Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) throws JSONException {
        List<View> views = null;
        switch (visualizationMode) {
            case 2: {
                views = this.getReadOnlyViewsFromJson(context, jsonObject, bundle, resolver);
                break;
            }
            default: {
                views = this.getEditableViewsFromJson(context, jsonObject, listener, bundle, resolver);
            }
        }
        return views;
    }

    private List<View> getEditableViewsFromJson(Context context, JSONObject jsonObject, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        views.add((View)FormUtils.getTextViewWith(context, 16, bundle.resolveKey(jsonObject.getString("label")), jsonObject.getString("key"), jsonObject.getString("type"), FormUtils.getLayoutParams(-1, -2, 0, 0, 0, 0), "font/Roboto-Bold.ttf"));
        JSONArray options = jsonObject.getJSONArray("options");
        for (int i = 0; i < options.length(); ++i) {
            JSONObject item = options.getJSONObject(i);
            if (!this.isVisible(item, context, resolver)) continue;
            CheckBox checkBox = (CheckBox)LayoutInflater.from((Context)context).inflate(R.layout.item_checkbox, null);
            checkBox.setText(bundle.resolveKey(item.getString("text")));
            checkBox.setTag(R.id.key, jsonObject.getString("key"));
            checkBox.setTag(R.id.type, jsonObject.getString("type"));
            checkBox.setTag(R.id.childKey, item.getString("key"));
            checkBox.setGravity(16);
            checkBox.setTextSize(16.0f);
            checkBox.setTypeface(Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"font/Roboto-Regular.ttf"));
            checkBox.setOnCheckedChangeListener(listener);
            if (!TextUtils.isEmpty((CharSequence)item.optString("value"))) {
                checkBox.setChecked(item.optBoolean("value"));
            }
            if (i == options.length() - 1) {
                checkBox.setLayoutParams((ViewGroup.LayoutParams)FormUtils.getLayoutParams(-1, -2, 0, 0, 0, (int)context.getResources().getDimension(R.dimen.extra_bottom_margin)));
            }
            views.add((View)checkBox);
        }
        return views;
    }

    private List<View> getReadOnlyViewsFromJson(Context context, JSONObject jsonObject, JsonFormBundle bundle, JsonExpressionResolver resolver) throws JSONException {
        ArrayList<View> views = new ArrayList<View>(1);
        views.add((View)FormUtils.getTextViewWith(context, 16, bundle.resolveKey(jsonObject.getString("label")), jsonObject.getString("key"), jsonObject.getString("type"), FormUtils.getLayoutParams(-1, -2, 0, 0, 0, (int)context.getResources().getDimension(R.dimen.extra_bottom_margin)), "font/Roboto-Bold.ttf"));
        JSONArray options = jsonObject.getJSONArray("options");
        for (int i = 0; i < options.length(); ++i) {
            JSONObject item = options.getJSONObject(i);
            if (!this.isVisible(item, context, resolver) || TextUtils.isEmpty((CharSequence)item.optString("value")) || !item.optBoolean("value")) continue;
            views.add((View)FormUtils.getTextViewWith(context, 16, bundle.resolveKey(item.getString("text")), item.getString("key"), null, FormUtils.getLayoutParams(-1, -2, 0, 0, 0, (int)context.getResources().getDimension(R.dimen.default_bottom_margin)), "font/Roboto-Regular.ttf"));
        }
        return views;
    }

    private boolean isVisible(JSONObject jsonObject, Context context, JsonExpressionResolver resolver) {
        String showExpression = jsonObject.optString("show");
        if (TextUtils.isEmpty((CharSequence)showExpression)) {
            return true;
        }
        if (resolver.isValidExpression(showExpression)) {
            try {
                JSONObject currentValues = this.getCurrentValues(context);
                return resolver.existsExpression(showExpression, currentValues);
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("isVisible: Error evaluating expression " + showExpression), (Throwable)e);
                return false;
            }
        }
        return "true".equalsIgnoreCase(showExpression);
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }
}

