/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.mvp;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.vijay.jsonwizard.mvp.ViewState;

public abstract class BaseFragment<VS extends ViewState>
extends Fragment {
    protected VS mViewState;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null || this.mViewState == null) {
            this.mViewState = this.createViewState();
            ((ViewState)this.mViewState).setSavedInstance(false);
        } else {
            ((ViewState)this.mViewState).setSavedInstance(true);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int layoutRes = this.getLayoutRes();
        if (layoutRes == 0) {
            throw new IllegalArgumentException("getLayoutRes() returned 0, which is not allowed. If you don't want to use getLayoutRes() but implement your own view for this fragment manually, then you have to override onCreateView();");
        }
        View v = inflater.inflate(layoutRes, container, false);
        return v;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    protected int getLayoutRes() {
        return 0;
    }

    protected abstract VS createViewState();

    public VS getViewState() {
        return this.mViewState;
    }
}

