/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.interactors;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import com.vijay.jsonwizard.expressions.JsonExpressionResolver;
import com.vijay.jsonwizard.i18n.JsonFormBundle;
import com.vijay.jsonwizard.interfaces.CommonListener;
import com.vijay.jsonwizard.interfaces.JsonApi;
import com.vijay.jsonwizard.utils.JsonFormUtils;
import com.vijay.jsonwizard.widgets.WidgetFactoryRegistry;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonFormInteractor {
    private static final String TAG = "JsonFormInteractor";
    private static final JsonFormInteractor INSTANCE = new JsonFormInteractor();

    private JsonFormInteractor() {
    }

    public List<View> fetchFormElements(String stepName, Context context, JSONObject parentJson, CommonListener listener, JsonFormBundle bundle, JsonExpressionResolver resolver, ResourceResolver resourceResolver, int visualizationMode) {
        Log.d((String)TAG, (String)"fetchFormElements called");
        ArrayList<View> viewsFromJson = new ArrayList<View>(5);
        try {
            JSONArray fields = parentJson.getJSONArray("fields");
            for (int i = 0; i < fields.length(); ++i) {
                JSONObject childJson = fields.getJSONObject(i);
                if (!this.isVisible(childJson, context, resolver)) continue;
                try {
                    List<View> views = WidgetFactoryRegistry.getWidgetFactory(childJson.getString("type")).getViewsFromJson(stepName, context, childJson, listener, bundle, resolver, resourceResolver, visualizationMode);
                    if (views.size() <= 0) continue;
                    viewsFromJson.addAll(views);
                    continue;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Exception occurred in making child view at index : " + i + " : Exception is : " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Json exception occurred : " + e.getMessage()), (Throwable)e);
        }
        return viewsFromJson;
    }

    private boolean isVisible(JSONObject jsonObject, Context context, JsonExpressionResolver resolver) {
        String showExpression = jsonObject.optString("show");
        if (!TextUtils.isEmpty((CharSequence)showExpression)) {
            if (resolver.isValidExpression(showExpression)) {
                try {
                    JSONObject currentValues = this.getCurrentValues(context);
                    return resolver.existsExpression(showExpression, currentValues);
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)("isVisible: Error evaluating expression " + showExpression), (Throwable)e);
                    return false;
                }
            }
            return "true".equalsIgnoreCase(showExpression);
        }
        String hideExpression = jsonObject.optString("hide");
        if (!TextUtils.isEmpty((CharSequence)hideExpression)) {
            if (resolver.isValidExpression(hideExpression)) {
                try {
                    JSONObject currentValues = this.getCurrentValues(context);
                    return !resolver.existsExpression(hideExpression, currentValues);
                }
                catch (JSONException e) {
                    Log.e((String)TAG, (String)("isVisible: Error evaluating expression " + showExpression), (Throwable)e);
                    return true;
                }
            }
            return !"true".equalsIgnoreCase(hideExpression);
        }
        return true;
    }

    @Nullable
    private JSONObject getCurrentValues(Context context) throws JSONException {
        JSONObject currentValues = null;
        if (context instanceof JsonApi) {
            String currentJsonState = ((JsonApi)context).currentJsonState();
            JSONObject currentJsonObject = new JSONObject(currentJsonState);
            currentValues = JsonFormUtils.extractDataFromForm(currentJsonObject, false);
        }
        return currentValues;
    }

    public static JsonFormInteractor getInstance() {
        return INSTANCE;
    }
}

