/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.demo.resources;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.vijay.jsonwizard.demo.resources.ResourceResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class AssetsResourceResolver
implements ResourceResolver {
    private static final String TAG = "AssetsResourceResolver";

    @Override
    public String resolvePath(Context context, String id2) {
        String imagePath = id2;
        if (!TextUtils.isEmpty((CharSequence)imagePath)) {
            imagePath = AssetsResourceResolver.moveAssetToCache(context, imagePath, "imagenes");
        }
        return imagePath;
    }

    private static String moveAssetToCache(Context context, String assetName, String assetFolderName) {
        File f = new File(context.getCacheDir() + File.separator + assetName);
        if (!f.exists()) {
            try (InputStream is = context.getAssets().open(assetFolderName + File.separator + assetName);
                 FileOutputStream fos = new FileOutputStream(f);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = is.read(buffer)) > 0) {
                    fos.write(buffer, 0, length);
                }
                fos.flush();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("moveAssetToCache: Error moving asset " + assetFolderName + " to cache"), (Throwable)e);
                return null;
            }
        }
        return f.getAbsolutePath();
    }
}

