/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.content.FileProvider;
import android.util.Log;
import com.vijay.jsonwizard.R;
import com.vijay.jsonwizard.utils.ImageFileUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ImagePicker {
    private static final String TAG = "ImagePicker";
    private static final String TEMP_IMAGE_NAME = "tempImage";

    public static Intent getPickImageIntent(Context context) {
        Intent chooserIntent = null;
        List<Intent> intentList = new ArrayList<Intent>();
        Intent pickIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        Intent takePhotoIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        takePhotoIntent.putExtra("return-data", true);
        Uri uri = FileProvider.getUriForFile((Context)context, (String)context.getApplicationContext().getPackageName(), (File)ImagePicker.getTempFile(context));
        takePhotoIntent.putExtra("output", (Parcelable)uri);
        intentList = ImagePicker.addIntentsToList(context, intentList, pickIntent);
        intentList = ImagePicker.addIntentsToList(context, intentList, takePhotoIntent);
        if (intentList.size() > 0) {
            chooserIntent = Intent.createChooser((Intent)intentList.remove(intentList.size() - 1), (CharSequence)context.getString(R.string.image_picker));
            chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", intentList.toArray(new Parcelable[0]));
        }
        return chooserIntent;
    }

    private static List<Intent> addIntentsToList(Context context, List<Intent> list, Intent intent) {
        List resInfo = context.getPackageManager().queryIntentActivities(intent, 0);
        for (ResolveInfo resolveInfo : resInfo) {
            String packageName = resolveInfo.activityInfo.packageName;
            Intent targetedIntent = new Intent(intent);
            targetedIntent.setPackage(packageName);
            list.add(targetedIntent);
            Log.d((String)TAG, (String)("Intent: " + intent.getAction() + " package: " + packageName));
        }
        return list;
    }

    public static Bitmap getImageFromResult(Context context, int resultCode, Intent imageReturnedIntent) {
        Log.d((String)TAG, (String)("getImageFromResult, resultCode: " + resultCode));
        Bitmap bm = null;
        File imageFile = ImagePicker.getTempFile(context);
        if (resultCode == -1) {
            boolean isCamera = imageReturnedIntent == null || imageReturnedIntent.getData() == null || imageReturnedIntent.getData().toString().contains(imageFile.toString());
            Uri selectedImage = isCamera ? FileProvider.getUriForFile((Context)context, (String)context.getApplicationContext().getPackageName(), (File)ImagePicker.getTempFile(context)) : imageReturnedIntent.getData();
            Log.d((String)TAG, (String)("selectedImage: " + selectedImage));
            bm = ImagePicker.getImageResized(context, selectedImage);
            int rotation = ImagePicker.getRotation(context, selectedImage, isCamera);
            bm = ImagePicker.rotate(bm, rotation);
        }
        return bm;
    }

    private static File getTempFile(Context context) {
        File imageFile = new File(context.getExternalCacheDir(), TEMP_IMAGE_NAME);
        imageFile.getParentFile().mkdirs();
        return imageFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap decodeBitmap(Context context, Uri theUri, int sampleSize) {
        AssetFileDescriptor fileDescriptor = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = sampleSize;
            try {
                fileDescriptor = context.getContentResolver().openAssetFileDescriptor(theUri, "r");
                Bitmap actuallyUsableBitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options);
                Log.d((String)TAG, (String)(options.inSampleSize + " sample method bitmap ... " + actuallyUsableBitmap.getWidth() + " " + actuallyUsableBitmap.getHeight()));
                Bitmap bitmap = actuallyUsableBitmap;
                return bitmap;
            }
            catch (FileNotFoundException e) {
                Bitmap bitmap;
                block13: {
                    Log.e((String)TAG, (String)"decodeBitmap: error", (Throwable)e);
                    bitmap = null;
                    if (fileDescriptor == null) break block13;
                    try {
                        fileDescriptor.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return bitmap;
            }
        }
        finally {
            if (fileDescriptor != null) {
                try {
                    fileDescriptor.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Bitmap getImageResized(Context context, Uri selectedImage) {
        Bitmap bm = ImagePicker.decodeBitmap(context, selectedImage, 1);
        bm = ImageFileUtils.scaleToFit(bm, 1600);
        return bm;
    }

    private static int getRotation(Context context, Uri imageUri, boolean isCamera) {
        int rotation = isCamera ? ImagePicker.getRotationFromCamera(context, imageUri) : ImagePicker.getRotationFromGallery(context, imageUri);
        Log.d((String)TAG, (String)("Image rotation: " + rotation));
        return rotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getRotationFromCamera(Context context, Uri imageFile) {
        int rotate = 0;
        InputStream inputStream = null;
        try {
            ExifInterface exif;
            context.getContentResolver().notifyChange(imageFile, null);
            if (Build.VERSION.SDK_INT > 23) {
                inputStream = context.getContentResolver().openInputStream(imageFile);
                exif = new ExifInterface(inputStream);
            } else {
                exif = new ExifInterface(imageFile.getPath());
            }
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    return rotate;
                }
                case 3: {
                    rotate = 180;
                    return rotate;
                }
                case 6: {
                    rotate = 90;
                    return rotate;
                }
            }
            return rotate;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getRotationFromCamera: error", (Throwable)e);
            return rotate;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    Log.e((String)TAG, (String)"getRotationFromCamera: error closing stream", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRotationFromGallery(Context context, Uri imageUri) {
        int result = 0;
        String[] columns = new String[]{"orientation"};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(imageUri, columns, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int orientationColumnIndex = cursor.getColumnIndex(columns[0]);
                result = cursor.getInt(orientationColumnIndex);
            }
        }
        return result;
    }

    private static Bitmap rotate(Bitmap bm, int rotation) {
        if (rotation != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotation);
            return Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)matrix, (boolean)true);
        }
        return bm;
    }
}

