/*
 * Decompiled with CFR 0.152.
 */
package com.vijay.jsonwizard.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import androidx.collection.LruCache;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class ImageUtils {
    private static final String TAG = "ImageUtils";
    private static LruCache<String, Bitmap> mBitmapLruCache = new LruCache(10000000);

    public static Bitmap loadBitmapFromFile(String path, int requiredWidth, int requiredHeight) {
        String key = path + ":" + requiredWidth + ":" + requiredHeight;
        Bitmap bitmap = (Bitmap)mBitmapLruCache.get((Object)key);
        if (bitmap != null) {
            Log.d((String)"ImagePickerFactory", (String)"Found in cache.");
            return bitmap;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, requiredWidth, requiredHeight);
        options.inJustDecodeBounds = false;
        bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        mBitmapLruCache.put((Object)key, (Object)bitmap);
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static int getDeviceWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        return display.getWidth();
    }

    public static boolean saveToFile(Bitmap bitmap, File file) {
        int COMPRESSION_RATIO = 80;
        try {
            File folder = new File(file.getParent());
            if (!folder.exists()) {
                folder.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fos);
            fos.flush();
            fos.close();
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error compressing bitmap", (Throwable)e);
            return false;
        }
    }

    public static boolean compressAndSave(Bitmap uncompressedBitmap, int compressionRatio, String filePath) {
        try {
            if (compressionRatio > 0 && compressionRatio <= 100) {
                File file = new File(filePath);
                File folder = new File(file.getParent());
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                uncompressedBitmap.compress(Bitmap.CompressFormat.JPEG, compressionRatio, (OutputStream)fos);
                fos.flush();
                fos.close();
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error compressing bitmap", (Throwable)e);
        }
        return false;
    }

    public static Bitmap scaleToFit(Bitmap unscaledBitmap, int maxSize) {
        Bitmap scaledBitmap = null;
        if (unscaledBitmap.getWidth() > maxSize || unscaledBitmap.getHeight() > maxSize) {
            Rect srcRect = ImageUtils.calculateSrcRect(unscaledBitmap.getWidth(), unscaledBitmap.getHeight(), maxSize, maxSize, ScalingLogic.FIT);
            Rect destRect = ImageUtils.calculateDestRect(unscaledBitmap.getWidth(), unscaledBitmap.getHeight(), maxSize, maxSize, ScalingLogic.FIT);
            scaledBitmap = Bitmap.createBitmap((int)destRect.width(), (int)destRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(scaledBitmap);
            canvas.drawBitmap(unscaledBitmap, srcRect, destRect, new Paint(2));
        } else {
            scaledBitmap = unscaledBitmap;
        }
        return scaledBitmap;
    }

    public static Rect calculateSrcRect(int srcWidth, int srcHeight, int dstWidth, int dstHeight, ScalingLogic scalingLogic) {
        if (scalingLogic == ScalingLogic.CROP) {
            float srcAspect = (float)srcWidth / (float)srcHeight;
            float dstAspect = (float)dstWidth / (float)dstHeight;
            if (srcAspect > dstAspect) {
                int srcRectWidth = (int)((float)srcHeight * dstAspect);
                int srcRectLeft = (srcWidth - srcRectWidth) / 2;
                return new Rect(srcRectLeft, 0, srcRectLeft + srcRectWidth, srcHeight);
            }
            int srcRectHeight = (int)((float)srcWidth / dstAspect);
            int scrRectTop = (srcHeight - srcRectHeight) / 2;
            return new Rect(0, scrRectTop, srcWidth, scrRectTop + srcRectHeight);
        }
        return new Rect(0, 0, srcWidth, srcHeight);
    }

    public static Rect calculateDestRect(int srcWidth, int srcHeight, int dstWidth, int dstHeight, ScalingLogic logic) {
        if (logic == ScalingLogic.FIT) {
            float srcAspect = (float)srcWidth / (float)srcHeight;
            float dstAspect = (float)dstWidth / (float)dstHeight;
            if (srcAspect > dstAspect) {
                return new Rect(0, 0, dstWidth, (int)((float)dstWidth / srcAspect));
            }
            return new Rect(0, 0, (int)((float)dstHeight * srcAspect), dstHeight);
        }
        return new Rect(0, 0, dstWidth, dstHeight);
    }

    public static enum ScalingLogic {
        CROP,
        FIT;

    }
}

