/*
 * Decompiled with CFR 0.152.
 */
package br.com.ilhasoft.support.validation.util;

import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

public class ViewTagHelper {
    public static <Type> void appendValue(int tagId, View view, Type value) {
        Object object = view.getTag(tagId);
        if (object != null && object instanceof List) {
            ((List)object).add(value);
        } else {
            ArrayList<Type> typeList = new ArrayList<Type>();
            typeList.add(value);
            view.setTag(tagId, typeList);
        }
    }

    public static List<View> getViewsByTag(ViewGroup root, int tagId) {
        ArrayList<View> views = new ArrayList<View>();
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = root.getChildAt(i);
            if (child instanceof ViewGroup) {
                views.addAll(ViewTagHelper.getViewsByTag((ViewGroup)child, tagId));
            }
            ViewTagHelper.addViewWhenContainsTag(tagId, views, child);
        }
        return views;
    }

    public static List<View> filterViewWithTag(int tagId, View view) {
        ArrayList<View> viewsWithTags = new ArrayList<View>();
        ViewTagHelper.addViewWhenContainsTag(tagId, viewsWithTags, view);
        return viewsWithTags;
    }

    public static <ViewType extends View> List<View> filterViewsWithTag(int tagId, List<ViewType> views) {
        ArrayList<View> viewsWithTags = new ArrayList<View>();
        for (View view : views) {
            ViewTagHelper.addViewWhenContainsTag(tagId, viewsWithTags, view);
        }
        return viewsWithTags;
    }

    private static void addViewWhenContainsTag(int tagId, List<View> views, View view) {
        Object tagValue = view.getTag(tagId);
        if (tagValue != null) {
            views.add(view);
        }
    }
}

