/*
 * Decompiled with CFR 0.152.
 */
package br.com.ilhasoft.support.validation.util;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewParent;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.databinding.adapters.ListenerUtil;
import br.com.ilhasoft.support.validation.R;
import com.google.android.material.textfield.TextInputLayout;

public class EditTextHandler {
    public static void removeError(TextView textView) {
        EditTextHandler.setError(textView, null);
    }

    public static void setError(TextView textView, String errorMessage) {
        TextInputLayout textInputLayout = EditTextHandler.getTextInputLayout(textView);
        if (textInputLayout != null) {
            textInputLayout.setErrorEnabled(!TextUtils.isEmpty((CharSequence)errorMessage));
            textInputLayout.setError((CharSequence)errorMessage);
        } else {
            textView.setError((CharSequence)errorMessage);
        }
    }

    @Nullable
    private static TextInputLayout getTextInputLayout(TextView textView) {
        TextInputLayout textInputLayout = null;
        ViewParent parent = textView.getParent();
        while (parent instanceof View) {
            if (parent instanceof TextInputLayout) {
                textInputLayout = (TextInputLayout)parent;
                break;
            }
            parent = parent.getParent();
        }
        return textInputLayout;
    }

    public static void disableErrorOnChanged(final TextView textView) {
        if (ListenerUtil.getListener((View)textView, (int)R.id.text_watcher_clear_error) != null) {
            return;
        }
        TextWatcher textWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                EditTextHandler.setError(textView, null);
            }

            public void afterTextChanged(Editable s) {
            }
        };
        textView.addTextChangedListener(textWatcher);
        ListenerUtil.trackListener((View)textView, (Object)textView, (int)R.id.text_watcher_clear_error);
    }
}

