/*
 * Decompiled with CFR 0.152.
 */
package br.com.ilhasoft.support.validation.binding;

import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.databinding.BindingAdapter;
import br.com.ilhasoft.support.validation.R;
import br.com.ilhasoft.support.validation.rule.TypeRule;
import br.com.ilhasoft.support.validation.util.EditTextHandler;
import br.com.ilhasoft.support.validation.util.ErrorMessageHelper;
import br.com.ilhasoft.support.validation.util.ViewTagHelper;

public class TypeBindings {
    @BindingAdapter(value={"validateType", "validateTypeMessage", "validateTypeAutoDismiss"}, requireAll=false)
    public static void bindingTypeValidation(TextView view, String fieldTypeText, String errorMessage, boolean autoDismiss) {
        if (autoDismiss) {
            EditTextHandler.disableErrorOnChanged(view);
        }
        TypeRule.FieldType fieldType = TypeBindings.getFieldTypeByText(fieldTypeText);
        try {
            String handledErrorMessage = ErrorMessageHelper.getStringOrDefault((View)view, errorMessage, fieldType.errorMessageId);
            ViewTagHelper.appendValue(R.id.validator_rule, (View)view, fieldType.instantiate(view, handledErrorMessage));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    private static TypeRule.FieldType getFieldTypeByText(String fieldTypeText) {
        TypeRule.FieldType fieldType = TypeRule.FieldType.None;
        for (TypeRule.FieldType type : TypeRule.FieldType.values()) {
            if (!type.toString().equalsIgnoreCase(fieldTypeText)) continue;
            fieldType = type;
            break;
        }
        return fieldType;
    }
}

