/*
 * Decompiled with CFR 0.152.
 */
package br.com.ilhasoft.support.validation;

import android.view.View;
import android.view.ViewGroup;
import androidx.databinding.ViewDataBinding;
import br.com.ilhasoft.support.validation.R;
import br.com.ilhasoft.support.validation.rule.Rule;
import br.com.ilhasoft.support.validation.util.ViewTagHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Validator {
    private static final int FIELD_VALIDATION_MODE = 0;
    private static final int FORM_VALIDATION_MODE = 1;
    private ViewDataBinding target;
    private ValidationListener validationListener;
    private int mode = 0;
    private final Set<View> disabledViews;

    public Validator(ViewDataBinding target) {
        this.target = target;
        this.disabledViews = new HashSet<View>();
    }

    public void setValidationListener(ValidationListener validationListener) {
        this.validationListener = validationListener;
    }

    public void toValidate() {
        if (this.validationListener == null) {
            throw new IllegalArgumentException("Validation listener should not be null.");
        }
        if (this.validate()) {
            this.validationListener.onValidationSuccess();
        } else {
            this.validationListener.onValidationError();
        }
    }

    public boolean validate() {
        List<View> viewWithValidations = this.getViewsWithValidation();
        return this.isAllViewsValid(viewWithValidations);
    }

    public boolean validate(View view) {
        List<View> viewWithValidations = this.getViewsWithValidation(view);
        return this.isAllViewsValid(viewWithValidations);
    }

    public <ViewType extends View> boolean validate(List<ViewType> views) {
        List<View> viewWithValidations = this.getViewsWithValidation(views);
        return this.isAllViewsValid(viewWithValidations);
    }

    private boolean isAllViewsValid(List<View> viewWithValidations) {
        boolean allViewsValid = true;
        for (View viewWithValidation : viewWithValidations) {
            boolean viewValid = true;
            List rules = (List)viewWithValidation.getTag(R.id.validator_rule);
            for (Rule rule : rules) {
                viewValid = viewValid && this.isRuleValid(rule);
                allViewsValid = allViewsValid && viewValid;
            }
            if (this.mode != 0 || viewValid) continue;
            break;
        }
        return allViewsValid;
    }

    private boolean isRuleValid(Rule rule) {
        return this.disabledViews.contains(rule.getView()) || rule.validate();
    }

    public void disableValidation(View view) {
        this.disabledViews.add(view);
    }

    public void enableValidation(View view) {
        this.disabledViews.remove(view);
    }

    public void enableFormValidationMode() {
        this.mode = 1;
    }

    public void enableFieldValidationMode() {
        this.mode = 0;
    }

    private List<View> getViewsWithValidation() {
        if (this.target.getRoot() instanceof ViewGroup) {
            return ViewTagHelper.getViewsByTag((ViewGroup)this.target.getRoot(), R.id.validator_rule);
        }
        return Collections.singletonList(this.target.getRoot());
    }

    private <ViewType extends View> List<View> getViewsWithValidation(List<ViewType> views) {
        return ViewTagHelper.filterViewsWithTag(R.id.validator_rule, views);
    }

    private List<View> getViewsWithValidation(View view) {
        return ViewTagHelper.filterViewWithTag(R.id.validator_rule, view);
    }

    public static interface ValidationListener {
        public void onValidationSuccess();

        public void onValidationError();
    }
}

