/*
 * Decompiled with CFR 0.152.
 */
package br.com.ilhasoft.support.validation.rule;

import android.widget.TextView;
import br.com.ilhasoft.support.validation.rule.TypeRule;
import br.com.ilhasoft.support.validation.util.EditTextHandler;

public class CpfTypeRule
extends TypeRule {
    public CpfTypeRule(TextView view, String errorMessage) {
        super(view, TypeRule.FieldType.Cpf, errorMessage);
    }

    @Override
    protected boolean isValid(TextView view) {
        String rawCpf = view.getText().toString().trim().replaceAll("[^\\d]", "");
        return rawCpf.length() == 11 && this.cpfDv(rawCpf, 1) == Character.getNumericValue(rawCpf.charAt(9)) && this.cpfDv(rawCpf, 2) == Character.getNumericValue(rawCpf.charAt(10));
    }

    private int cpfDv(String rawCpf, int step) {
        int dv = 11 - this.cpfSum(rawCpf, step) % 11;
        return dv == 10 || dv == 11 ? 0 : dv;
    }

    private int cpfSum(String rawCPF, int step) {
        int sum = 0;
        int count = 8 + step;
        int baseMultiplier = 9 + step;
        for (int i = 0; i < count; ++i) {
            sum += (baseMultiplier - i) * Character.getNumericValue(rawCPF.charAt(i));
        }
        return sum;
    }

    @Override
    protected void onValidationSucceeded(TextView view) {
        super.onValidationSucceeded(view);
        EditTextHandler.removeError(view);
    }

    @Override
    protected void onValidationFailed(TextView view) {
        super.onValidationFailed(view);
        EditTextHandler.setError(view, this.errorMessage);
    }
}

