/*
 * Decompiled with CFR 0.152.
 */
package br.com.ilhasoft.support.validation.binding;

import android.databinding.BindingAdapter;
import android.view.View;
import android.widget.TextView;
import br.com.ilhasoft.support.validation.R;
import br.com.ilhasoft.support.validation.rule.EmptyRule;
import br.com.ilhasoft.support.validation.rule.MaxLengthRule;
import br.com.ilhasoft.support.validation.rule.MinLengthRule;
import br.com.ilhasoft.support.validation.util.EditTextHandler;
import br.com.ilhasoft.support.validation.util.ErrorMessageHelper;
import br.com.ilhasoft.support.validation.util.ViewTagHelper;

public class LengthBindings {
    @BindingAdapter(value={"validateMinLength", "validateMinLengthMessage", "validateMinLengthAutoDismiss"}, requireAll=false)
    public static void bindingMinLength(TextView view, int minLength, String errorMessage, Boolean autoDismiss) {
        if (autoDismiss == null || autoDismiss.booleanValue()) {
            EditTextHandler.disableErrorOnChanged(view);
        }
        String handledErrorMessage = ErrorMessageHelper.getStringOrDefault((View)view, errorMessage, R.string.error_message_min_length, minLength);
        ViewTagHelper.appendValue(R.id.validator_rule, (View)view, new MinLengthRule(view, minLength, handledErrorMessage));
    }

    @BindingAdapter(value={"validateMaxLength", "validateMaxLengthMessage", "validateMaxLengthAutoDismiss"}, requireAll=false)
    public static void bindingMaxLength(TextView view, int maxLength, String errorMessage, Boolean autoDismiss) {
        if (autoDismiss == null || autoDismiss.booleanValue()) {
            EditTextHandler.disableErrorOnChanged(view);
        }
        String handledErrorMessage = ErrorMessageHelper.getStringOrDefault((View)view, errorMessage, R.string.error_message_max_length, maxLength);
        ViewTagHelper.appendValue(R.id.validator_rule, (View)view, new MaxLengthRule(view, maxLength, handledErrorMessage));
    }

    @BindingAdapter(value={"validateEmpty", "validateEmptyMessage", "validateEmptyAutoDismiss"}, requireAll=false)
    public static void bindingEmpty(TextView view, boolean empty, String errorMessage, Boolean autoDismiss) {
        if (autoDismiss == null || autoDismiss.booleanValue()) {
            EditTextHandler.disableErrorOnChanged(view);
        }
        String handledErrorMessage = ErrorMessageHelper.getStringOrDefault((View)view, errorMessage, R.string.error_message_empty_validation);
        ViewTagHelper.appendValue(R.id.validator_rule, (View)view, new EmptyRule(view, empty, handledErrorMessage));
    }
}

