/*
 * Decompiled with CFR 0.152.
 */
package br.com.ilhasoft.support.validation.rule;

import android.view.View;

public abstract class Rule<ViewType extends View, ValueType> {
    protected ValueType value;
    protected ViewType view;

    public Rule(ViewType view, ValueType value) {
        this.view = view;
        this.value = value;
    }

    public final boolean validate() {
        boolean valid = this.isValid(this.view);
        if (valid) {
            this.onValidationSucceeded(this.view);
        } else {
            this.onValidationFailed(this.view);
        }
        return valid;
    }

    protected abstract boolean isValid(ViewType var1);

    protected void onValidationSucceeded(ViewType view) {
    }

    protected void onValidationFailed(ViewType view) {
    }

    public ViewType getView() {
        return this.view;
    }
}

