/*
 * Decompiled with CFR 0.152.
 */
package br.com.ilhasoft.support.validation.rule;

import android.widget.TextView;
import br.com.ilhasoft.support.validation.R;
import br.com.ilhasoft.support.validation.rule.TypeRule;
import br.com.ilhasoft.support.validation.util.EditTextHandler;

public class CpfTypeRule
extends TypeRule {
    public CpfTypeRule(TextView view) {
        super(view, TypeRule.FieldType.Cpf);
    }

    @Override
    protected boolean isValid(TextView view) {
        if (view.getText().toString().trim().replaceAll("[^\\d]", "").length() < 11) {
            return false;
        }
        String rawCPF = view.getText().toString().trim().replaceAll("[^\\d]", "");
        int stepOne = this.cpfSum(rawCPF, 1) * 10 % 11;
        int stepTwo = this.cpfSum(rawCPF, 2) * 10 % 11;
        return stepOne == Character.getNumericValue(rawCPF.charAt(9)) && stepTwo == Character.getNumericValue(rawCPF.charAt(10));
    }

    private int cpfSum(String rawCPF, int step) {
        int sum = 0;
        int count = 8 + step;
        int baseMultiplier = 9 + step;
        for (int i = 0; i < count; ++i) {
            sum += (baseMultiplier - i) * Character.getNumericValue(rawCPF.charAt(i));
        }
        return sum;
    }

    @Override
    protected void onValidationSucceeded(TextView view) {
        super.onValidationSucceeded(view);
        EditTextHandler.removeError(view);
    }

    @Override
    protected void onValidationFailed(TextView view) {
        super.onValidationFailed(view);
        EditTextHandler.setError(view, view.getContext().getString(R.string.error_message_cpf_validation));
    }
}

