/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import de.codecrafters.tableview.R;
import de.codecrafters.tableview.TableDataAdapter;
import de.codecrafters.tableview.TableDataRowBackgroundColorProvider;
import de.codecrafters.tableview.TableHeaderAdapter;
import de.codecrafters.tableview.TableHeaderView;
import de.codecrafters.tableview.colorizers.TableDataRowColorizer;
import de.codecrafters.tableview.listeners.OnScrollListener;
import de.codecrafters.tableview.listeners.SwipeToRefreshListener;
import de.codecrafters.tableview.listeners.TableDataClickListener;
import de.codecrafters.tableview.listeners.TableDataLongClickListener;
import de.codecrafters.tableview.listeners.TableHeaderClickListener;
import de.codecrafters.tableview.model.TableColumnModel;
import de.codecrafters.tableview.model.TableColumnWeightModel;
import de.codecrafters.tableview.providers.TableDataRowBackgroundProvider;
import de.codecrafters.tableview.toolkit.TableDataRowBackgroundProviders;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TableView<T>
extends LinearLayout {
    private static final String LOG_TAG = TableView.class.getName();
    private static final int DEFAULT_COLUMN_COUNT = 4;
    private static final int DEFAULT_HEADER_ELEVATION = 1;
    private static final int DEFAULT_HEADER_COLOR = -3355444;
    private final Set<TableDataLongClickListener<T>> dataLongClickListeners = new HashSet<TableDataLongClickListener<T>>();
    private final Set<TableDataClickListener<T>> dataClickListeners = new HashSet<TableDataClickListener<T>>();
    private final Set<OnScrollListener> onScrollListeners = new HashSet<OnScrollListener>();
    private TableDataRowBackgroundProvider<? super T> dataRowBackgroundProvider = TableDataRowBackgroundProviders.similarRowColor(0);
    private TableColumnModel columnModel;
    private TableHeaderView tableHeaderView;
    private SwipeRefreshLayout swipeRefreshLayout;
    private ListView tableDataView;
    private TableDataAdapter<T> tableDataAdapter;
    private TableHeaderAdapter tableHeaderAdapter;
    private int headerElevation;
    private int headerColor;

    public TableView(Context context) {
        this(context, null);
    }

    public TableView(Context context, AttributeSet attributes) {
        this(context, attributes, 16842868);
    }

    public TableView(Context context, AttributeSet attributes, int styleAttributes) {
        super(context, attributes, styleAttributes);
        this.setOrientation(1);
        this.setAttributes(attributes);
        this.setupTableHeaderView(attributes);
        this.setupTableDataView(attributes, styleAttributes);
    }

    protected void setHeaderView(TableHeaderView headerView) {
        this.tableHeaderView = headerView;
        this.tableHeaderView.setAdapter(this.tableHeaderAdapter);
        this.tableHeaderView.setBackgroundColor(this.headerColor);
        this.tableHeaderView.setId(R.id.table_header_view);
        if (this.getChildCount() == 2) {
            this.removeViewAt(0);
        }
        this.addView((View)this.tableHeaderView, 0);
        this.setHeaderElevation(this.headerElevation);
        this.forceRefresh();
    }

    public boolean isSwipeToRefreshEnabled() {
        return this.swipeRefreshLayout.isEnabled();
    }

    public void setSwipeToRefreshEnabled(boolean enabled) {
        this.swipeRefreshLayout.setEnabled(enabled);
    }

    public void setSwipeToRefreshListener(final SwipeToRefreshListener listener) {
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                listener.onRefresh(new SwipeToRefreshListener.RefreshIndicator(){

                    @Override
                    public void hide() {
                        TableView.this.swipeRefreshLayout.setRefreshing(false);
                    }

                    @Override
                    public void show() {
                        TableView.this.swipeRefreshLayout.setRefreshing(true);
                    }

                    @Override
                    public boolean isVisible() {
                        return TableView.this.swipeRefreshLayout.isRefreshing();
                    }
                });
            }
        });
    }

    public void setHeaderBackground(@DrawableRes int resId) {
        this.tableHeaderView.setBackgroundResource(resId);
    }

    public void setHeaderBackgroundColor(@ColorInt int color) {
        this.tableHeaderView.setBackgroundColor(color);
        this.swipeRefreshLayout.setColorSchemeColors(new int[]{color});
    }

    public void setHeaderElevation(int elevation) {
        ViewCompat.setElevation((View)this.tableHeaderView, (float)elevation);
    }

    @Deprecated
    public void setDataRowColorizer(TableDataRowColorizer<? super T> colorizer) {
        this.setDataRowBackgroundProvider(new TableDataRowBackgroundColorProvider<T>(colorizer));
    }

    public void setDataRowBackgroundProvider(TableDataRowBackgroundProvider<? super T> backgroundProvider) {
        this.dataRowBackgroundProvider = backgroundProvider;
        this.tableDataAdapter.setRowBackgroundProvider(this.dataRowBackgroundProvider);
    }

    public void addDataClickListener(TableDataClickListener<T> listener) {
        this.dataClickListeners.add(listener);
    }

    public void addDataLongClickListener(TableDataLongClickListener<T> listener) {
        this.dataLongClickListeners.add(listener);
    }

    public void addOnScrollListener(OnScrollListener onScrollListener) {
        this.onScrollListeners.add(onScrollListener);
    }

    public void removeOnScrollListener(OnScrollListener onScrollListener) {
        this.onScrollListeners.remove(onScrollListener);
    }

    @Deprecated
    public void removeTableDataClickListener(TableDataClickListener<T> listener) {
        this.dataClickListeners.remove(listener);
    }

    public void removeDataClickListener(TableDataClickListener<T> listener) {
        this.dataClickListeners.remove(listener);
    }

    public void removeDataLongClickListener(TableDataLongClickListener<T> listener) {
        this.dataLongClickListeners.remove(listener);
    }

    public void addHeaderClickListener(TableHeaderClickListener listener) {
        this.tableHeaderView.addHeaderClickListener(listener);
    }

    @Deprecated
    public void removeHeaderListener(TableHeaderClickListener listener) {
        this.tableHeaderView.removeHeaderClickListener(listener);
    }

    public void removeHeaderClickListener(TableHeaderClickListener listener) {
        this.tableHeaderView.removeHeaderClickListener(listener);
    }

    public TableHeaderAdapter getHeaderAdapter() {
        return this.tableHeaderAdapter;
    }

    public void setHeaderAdapter(TableHeaderAdapter headerAdapter) {
        this.tableHeaderAdapter = headerAdapter;
        this.tableHeaderAdapter.setColumnModel(this.columnModel);
        this.tableHeaderView.setAdapter(this.tableHeaderAdapter);
        this.forceRefresh();
    }

    public TableDataAdapter<T> getDataAdapter() {
        return this.tableDataAdapter;
    }

    public void setDataAdapter(TableDataAdapter<T> dataAdapter) {
        this.tableDataAdapter = dataAdapter;
        this.tableDataAdapter.setColumnModel(this.columnModel);
        this.tableDataAdapter.setRowBackgroundProvider(this.dataRowBackgroundProvider);
        this.tableDataView.setAdapter(this.tableDataAdapter);
        this.forceRefresh();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setColumnModel(TableColumnModel columnModel) {
        this.columnModel = columnModel;
        this.tableHeaderAdapter.setColumnModel(this.columnModel);
        this.tableDataAdapter.setColumnModel(this.columnModel);
        this.forceRefresh();
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public void setColumnCount(int columnCount) {
        this.columnModel.setColumnCount(columnCount);
        this.forceRefresh();
    }

    @Deprecated
    public void setColumnWeight(int columnIndex, int columnWeight) {
        if (this.columnModel instanceof TableColumnWeightModel) {
            TableColumnWeightModel columnWeightModel = (TableColumnWeightModel)this.columnModel;
            columnWeightModel.setColumnWeight(columnIndex, columnWeight);
            this.forceRefresh();
        }
    }

    @Deprecated
    public int getColumnWeight(int columnIndex) {
        if (this.columnModel instanceof TableColumnWeightModel) {
            TableColumnWeightModel columnWeightModel = (TableColumnWeightModel)this.columnModel;
            return columnWeightModel.getColumnWeight(columnIndex);
        }
        return -1;
    }

    public void setSaveEnabled(boolean enabled) {
        super.setSaveEnabled(enabled);
        this.tableHeaderView.setSaveEnabled(enabled);
        this.tableDataView.setSaveEnabled(enabled);
    }

    private void forceRefresh() {
        if (this.tableHeaderView != null) {
            this.tableHeaderView.invalidate();
            this.tableHeaderAdapter.notifyDataSetChanged();
        }
        if (this.tableDataView != null) {
            this.tableDataView.invalidate();
            this.tableDataAdapter.notifyDataSetChanged();
        }
    }

    private void setAttributes(AttributeSet attributes) {
        TypedArray styledAttributes = this.getContext().obtainStyledAttributes(attributes, R.styleable.TableView);
        this.headerColor = styledAttributes.getInt(R.styleable.TableView_tableView_headerColor, -3355444);
        this.headerElevation = styledAttributes.getInt(R.styleable.TableView_tableView_headerElevation, 1);
        int columnCount = styledAttributes.getInt(R.styleable.TableView_tableView_columnCount, 4);
        this.columnModel = new TableColumnWeightModel(columnCount);
        styledAttributes.recycle();
    }

    private void setupTableHeaderView(AttributeSet attributes) {
        this.tableHeaderAdapter = this.isInEditMode() ? new EditModeTableHeaderAdapter(this.getContext()) : new DefaultTableHeaderAdapter(this.getContext());
        TableHeaderView tableHeaderView = new TableHeaderView(this.getContext());
        tableHeaderView.setBackgroundColor(-3355444);
        this.setHeaderView(tableHeaderView);
    }

    private void setupTableDataView(AttributeSet attributes, int styleAttributes) {
        LinearLayout.LayoutParams dataViewLayoutParams = new LinearLayout.LayoutParams(this.getWidthAttribute(attributes), -1);
        this.tableDataAdapter = this.isInEditMode() ? new EditModeTableDataAdapter(this.getContext()) : new DefaultTableDataAdapter(this.getContext());
        this.tableDataAdapter.setRowBackgroundProvider(this.dataRowBackgroundProvider);
        this.tableDataView = new ListView(this.getContext(), attributes, styleAttributes);
        this.tableDataView.setOnItemClickListener((AdapterView.OnItemClickListener)new InternalDataClickListener());
        this.tableDataView.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)new InternalDataLongClickListener());
        this.tableDataView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.tableDataView.setAdapter(this.tableDataAdapter);
        this.tableDataView.setId(R.id.table_data_view);
        this.tableDataView.setOnScrollListener((AbsListView.OnScrollListener)new InternalOnScrollListener());
        this.swipeRefreshLayout = new SwipeRefreshLayout(this.getContext());
        this.swipeRefreshLayout.setLayoutParams((ViewGroup.LayoutParams)dataViewLayoutParams);
        this.swipeRefreshLayout.addView((View)this.tableDataView);
        this.swipeRefreshLayout.setColorSchemeColors(new int[]{this.headerColor});
        this.swipeRefreshLayout.setEnabled(false);
        this.addView((View)this.swipeRefreshLayout);
    }

    private int getWidthAttribute(AttributeSet attributes) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attributes, new int[]{16842996});
        int layoutWidth = ta.getLayoutDimension(0, -1);
        ta.recycle();
        return layoutWidth;
    }

    private class EditModeTableDataAdapter
    extends TableDataAdapter<T> {
        private static final float TEXT_SIZE = 16.0f;

        public EditModeTableDataAdapter(Context context) {
            super(context, TableView.this.columnModel, new ArrayList());
        }

        @Override
        public View getCellView(int rowIndex, int columnIndex, ViewGroup parent) {
            TextView textView = new TextView(this.getContext());
            textView.setText((CharSequence)this.getResources().getString(R.string.default_cell, new Object[]{columnIndex, rowIndex}));
            textView.setPadding(20, 10, 20, 10);
            textView.setTextSize(16.0f);
            return textView;
        }

        public int getCount() {
            return 50;
        }
    }

    private class EditModeTableHeaderAdapter
    extends TableHeaderAdapter {
        private static final float TEXT_SIZE = 18.0f;

        public EditModeTableHeaderAdapter(Context context) {
            super(context, TableView.this.columnModel);
        }

        @Override
        public View getHeaderView(int columnIndex, ViewGroup parentView) {
            TextView textView = new TextView(this.getContext());
            textView.setText((CharSequence)this.getResources().getString(R.string.default_header, new Object[]{columnIndex}));
            textView.setPadding(20, 40, 20, 40);
            textView.setTypeface(textView.getTypeface(), 1);
            textView.setTextSize(18.0f);
            return textView;
        }
    }

    private class DefaultTableDataAdapter
    extends TableDataAdapter<T> {
        public DefaultTableDataAdapter(Context context) {
            super(context, TableView.this.columnModel, new ArrayList());
        }

        @Override
        public View getCellView(int rowIndex, int columnIndex, ViewGroup parentView) {
            return new TextView(this.getContext());
        }
    }

    private class DefaultTableHeaderAdapter
    extends TableHeaderAdapter {
        public DefaultTableHeaderAdapter(Context context) {
            super(context, TableView.this.columnModel);
        }

        @Override
        public View getHeaderView(int columnIndex, ViewGroup parentView) {
            TextView view = new TextView(this.getContext());
            view.setText((CharSequence)" ");
            view.setPadding(20, 40, 20, 40);
            return view;
        }
    }

    private class InternalOnScrollListener
    implements AbsListView.OnScrollListener {
        private InternalOnScrollListener() {
        }

        public void onScrollStateChanged(AbsListView absListView, int scrollStateValue) {
            OnScrollListener.ScrollState scrollState = OnScrollListener.ScrollState.fromValue(scrollStateValue);
            for (OnScrollListener onScrollListener : TableView.this.onScrollListeners) {
                onScrollListener.onScrollStateChanged(TableView.this.tableDataView, scrollState);
            }
        }

        public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            for (OnScrollListener onScrollListener : TableView.this.onScrollListeners) {
                onScrollListener.onScroll(TableView.this.tableDataView, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }
    }

    private class InternalDataLongClickListener
    implements AdapterView.OnItemLongClickListener {
        private InternalDataLongClickListener() {
        }

        public boolean onItemLongClick(AdapterView<?> parent, View view, int rowIndex, long id2) {
            return this.informAllListeners(rowIndex);
        }

        private boolean informAllListeners(int rowIndex) {
            Object clickedObject = TableView.this.tableDataAdapter.getItem(rowIndex);
            boolean isConsumed = false;
            for (TableDataLongClickListener listener : TableView.this.dataLongClickListeners) {
                try {
                    isConsumed |= listener.onDataLongClicked(rowIndex, clickedObject);
                }
                catch (Throwable t) {
                    Log.w((String)LOG_TAG, (String)("Caught Throwable on listener notification: " + t.toString()));
                }
            }
            return isConsumed;
        }
    }

    private class InternalDataClickListener
    implements AdapterView.OnItemClickListener {
        private InternalDataClickListener() {
        }

        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
            this.informAllListeners(i);
        }

        private void informAllListeners(int rowIndex) {
            Object clickedObject = TableView.this.tableDataAdapter.getItem(rowIndex);
            for (TableDataClickListener listener : TableView.this.dataClickListeners) {
                try {
                    listener.onDataClicked(rowIndex, clickedObject);
                }
                catch (Throwable t) {
                    Log.w((String)LOG_TAG, (String)("Caught Throwable on listener notification: " + t.toString()));
                }
            }
        }
    }
}

