/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import de.codecrafters.tableview.TableHeaderAdapter;
import de.codecrafters.tableview.listeners.TableHeaderClickListener;
import java.util.HashSet;
import java.util.Set;

class TableHeaderView
extends ListView {
    private final Set<TableHeaderClickListener> listeners = new HashSet<TableHeaderClickListener>();
    private TableHeaderAdapter adapter;

    public TableHeaderView(Context context) {
        super(context);
        this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -2));
    }

    public void setAdapter(TableHeaderAdapter adapter) {
        this.adapter = adapter;
        super.setAdapter((ListAdapter)adapter);
    }

    public TableHeaderAdapter getAdapter() {
        return this.adapter;
    }

    public void invalidate() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
        super.invalidate();
    }

    protected Set<TableHeaderClickListener> getHeaderClickListeners() {
        return this.listeners;
    }

    public void addHeaderClickListener(TableHeaderClickListener listener) {
        this.listeners.add(listener);
    }

    public void removeHeaderClickListener(TableHeaderClickListener listener) {
        this.listeners.remove(listener);
    }
}

