/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview.model;

import android.content.Context;
import android.util.DisplayMetrics;
import de.codecrafters.tableview.model.TableColumnModel;
import java.util.HashMap;
import java.util.Map;

public class TableColumnDpWidthModel
implements TableColumnModel {
    private static final int DEFAULT_COLUMN_WIDTH_IN_DP = 100;
    private final Map<Integer, Integer> columnWidths = new HashMap<Integer, Integer>();
    private final DisplayMetrics displayMetrics;
    private int columnCount;
    private int defaultColumnWidth;

    public TableColumnDpWidthModel(Context context, int columnCount) {
        this(context, columnCount, 100);
    }

    public TableColumnDpWidthModel(DisplayMetrics displayMetrics, int columnCount) {
        this(displayMetrics, columnCount, 100);
    }

    public TableColumnDpWidthModel(Context context, int columnCount, int defaultColumnWidthInDp) {
        this(context.getResources().getDisplayMetrics(), columnCount, defaultColumnWidthInDp);
    }

    public TableColumnDpWidthModel(DisplayMetrics displayMetrics, int columnCount, int defaultColumnWidthInDp) {
        this.displayMetrics = displayMetrics;
        this.columnCount = columnCount;
        this.defaultColumnWidth = this.toPixel(defaultColumnWidthInDp);
    }

    public void setColumnWidth(int columnIndex, int columnWidthInDp) {
        this.columnWidths.put(columnIndex, this.toPixel(columnWidthInDp));
    }

    @Override
    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getColumnWidth(int columnIndex, int tableWidthInPx) {
        Integer columnWidth = this.columnWidths.get(columnIndex);
        if (columnWidth == null) {
            return this.defaultColumnWidth;
        }
        return columnWidth;
    }

    private int toPixel(int dp) {
        return Math.round((float)dp * (this.displayMetrics.xdpi / 160.0f));
    }
}

