/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import de.codecrafters.tableview.InternalHeaderClickListener;
import de.codecrafters.tableview.R;
import de.codecrafters.tableview.SortState;
import de.codecrafters.tableview.TableHeaderView;
import de.codecrafters.tableview.providers.SortStateViewProvider;
import de.codecrafters.tableview.toolkit.SortStateViewProviders;

class SortableTableHeaderView
extends TableHeaderView {
    private static final String LOG_TAG = SortableTableHeaderView.class.toString();
    private final SparseArray<ImageView> sortViews = new SparseArray();
    private final SparseArray<SortState> sortStates = new SparseArray();
    private SortStateViewProvider sortStateViewProvider = SortStateViewProviders.darkArrows();

    public SortableTableHeaderView(Context context) {
        super(context);
    }

    public void resetSortViews() {
        int columnIndex;
        int i;
        for (i = 0; i < this.sortStates.size(); ++i) {
            columnIndex = this.sortStates.keyAt(i);
            SortState columnSortState = (SortState)((Object)this.sortStates.get(columnIndex));
            if (columnSortState != SortState.NOT_SORTABLE) {
                columnSortState = SortState.SORTABLE;
            }
            this.sortStates.put(columnIndex, (Object)columnSortState);
        }
        for (i = 0; i < this.sortStates.size(); ++i) {
            columnIndex = this.sortStates.keyAt(i);
            ImageView sortView = (ImageView)this.sortViews.get(columnIndex);
            SortState sortState = (SortState)((Object)this.sortStates.get(columnIndex));
            this.setSortStateToView(sortState, sortView);
        }
    }

    public void setSortState(int columnIndex, SortState sortState) {
        ImageView sortView = (ImageView)this.sortViews.get(columnIndex);
        if (sortView == null) {
            Log.e((String)LOG_TAG, (String)("SortView not found for columnIndex with index " + columnIndex));
            return;
        }
        this.sortStates.put(columnIndex, (Object)sortState);
        this.setSortStateToView(sortState, sortView);
    }

    private void setSortStateToView(SortState state, ImageView view) {
        int imageRes = this.sortStateViewProvider.getSortStateViewResource(state);
        view.setImageResource(imageRes);
        if (imageRes == 0) {
            view.setVisibility(8);
        } else {
            view.setVisibility(0);
        }
    }

    public SortStateViewProvider getSortStateViewProvider() {
        return this.sortStateViewProvider;
    }

    public void setSortStateViewProvider(SortStateViewProvider provider) {
        this.sortStateViewProvider = provider;
        this.renderHeaderViews();
    }

    @Override
    protected void renderHeaderViews() {
        this.removeAllViews();
        int tableWidth = 0;
        if (this.getParent() instanceof View) {
            tableWidth = ((View)this.getParent()).getWidth();
        }
        for (int columnIndex = 0; columnIndex < this.adapter.getColumnCount(); ++columnIndex) {
            LinearLayout headerLayout = (LinearLayout)this.adapter.getLayoutInflater().inflate(R.layout.sortable_header, (ViewGroup)this, false);
            headerLayout.setOnClickListener((View.OnClickListener)new InternalHeaderClickListener(columnIndex, this.getHeaderClickListeners()));
            View headerView = this.adapter.getHeaderView(columnIndex, (ViewGroup)headerLayout);
            if (headerView == null) {
                headerView = new TextView(this.getContext());
            }
            ((FrameLayout)headerLayout.findViewById(R.id.container)).addView(headerView);
            ImageView sortView = (ImageView)headerLayout.findViewById(R.id.sort_view);
            this.sortViews.put(columnIndex, (Object)sortView);
            SortState sortState = (SortState)((Object)this.sortStates.get(columnIndex));
            if (sortState == null) {
                sortState = SortState.NOT_SORTABLE;
                this.sortStates.put(columnIndex, (Object)sortState);
            }
            this.setSortStateToView(sortState, sortView);
            int width = this.adapter.getColumnModel().getColumnWidth(columnIndex, tableWidth);
            int height = -2;
            this.addView((View)headerLayout, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, -2));
        }
    }
}

