/*
 * Decompiled with CFR 0.152.
 */
package com.hyperion.methodmonitor.business;

import android.os.Looper;
import android.text.TextUtils;
import com.hyperion.methodmonitor.business.MethodTimeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MethodTimeManager {
    public static final String RETURN_TEXT = "..";
    private static volatile MethodTimeManager sInstance;
    private boolean mIsEnable;
    private boolean mIsOpen = true;
    private List<List<MethodTimeInfo>> mCache = new ArrayList<List<MethodTimeInfo>>();
    private Map<String, MethodTimeInfo> mReadyStopCache = new ConcurrentHashMap<String, MethodTimeInfo>();

    private MethodTimeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodTimeManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<MethodTimeManager> clazz = MethodTimeManager.class;
        synchronized (MethodTimeManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new MethodTimeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setEnable(boolean mIsEnable) {
        this.mIsEnable = mIsEnable;
    }

    public boolean isEnable() {
        return this.mIsEnable;
    }

    public void setOpen(boolean mIsOpen) {
        this.mIsOpen = mIsOpen;
    }

    public synchronized void onMethodStart(String className, String methodName, String methodDescriptor) {
        if (!this.mIsEnable || !this.mIsOpen) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)className) || TextUtils.isEmpty((CharSequence)methodName) || TextUtils.isEmpty((CharSequence)methodDescriptor)) {
            return;
        }
        String[] arrays = className.split("/");
        if (arrays.length == 0) {
            return;
        }
        String parentPackagePartName = null;
        for (int i = 0; i < arrays.length; ++i) {
            List<Object> list = null;
            if (i < this.mCache.size()) {
                list = this.mCache.get(i);
            } else {
                list = new ArrayList();
                this.mCache.add(list);
            }
            if (list == null) {
                list = new ArrayList();
            }
            this.mCache.set(i, list);
            MethodTimeInfo info = null;
            if (i == arrays.length - 1) {
                info = new MethodTimeInfo();
                info.mParentPackagePartName = parentPackagePartName;
                info.mClassName = arrays[i];
                info.mMethodName = methodName;
                info.mMethodDesc = methodDescriptor;
                info.mStartTime = System.currentTimeMillis();
                this.mReadyStopCache.put(this.generateKey(className, methodName, methodDescriptor), info);
            } else {
                info = new MethodTimeInfo();
                info.mParentPackagePartName = parentPackagePartName;
                info.mPackagePartName = arrays[i];
                parentPackagePartName = arrays[i];
            }
            if (list.contains(info)) continue;
            list.add(info);
        }
    }

    public void onMethodEnd(String className, String methodName, String methodDescriptor) {
        if (!this.mIsEnable || !this.mIsOpen) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)className) || TextUtils.isEmpty((CharSequence)methodName) || TextUtils.isEmpty((CharSequence)methodDescriptor)) {
            return;
        }
        MethodTimeInfo methodTimeInfo = this.mReadyStopCache.remove(this.generateKey(className, methodName, methodDescriptor));
        if (methodTimeInfo == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)methodTimeInfo.mPackagePartName)) {
            return;
        }
        methodTimeInfo.mStopTime = System.currentTimeMillis();
    }

    public synchronized List<MethodTimeInfo> getMethodTimeInfo(int level, String parentPackagePartName, long execTime) {
        if (level < 0 || level >= this.mCache.size()) {
            return null;
        }
        ArrayList<MethodTimeInfo> result = new ArrayList<MethodTimeInfo>();
        if (level != 0) {
            MethodTimeInfo returnInfo = new MethodTimeInfo();
            returnInfo.mPackagePartName = RETURN_TEXT;
            result.add(returnInfo);
        }
        for (MethodTimeInfo info : this.mCache.get(level)) {
            if (this.getExecTime(info, level) < execTime) continue;
            if (TextUtils.isEmpty((CharSequence)parentPackagePartName)) {
                result.add(info);
                continue;
            }
            if (!TextUtils.equals((CharSequence)info.mParentPackagePartName, (CharSequence)parentPackagePartName)) continue;
            result.add(info);
        }
        return result;
    }

    private long getExecTime(MethodTimeInfo info, int level) {
        if (info == null) {
            return 0L;
        }
        if (TextUtils.isEmpty((CharSequence)info.mPackagePartName)) {
            return info.mStopTime - info.mStartTime;
        }
        List<MethodTimeInfo> methodTimeInfos = this.mCache.get(level + 1);
        long maxExecTime = 0L;
        for (MethodTimeInfo methodTimeInfo : methodTimeInfos) {
            long execTime;
            if (!TextUtils.equals((CharSequence)methodTimeInfo.mParentPackagePartName, (CharSequence)info.mPackagePartName) || (execTime = this.getExecTime(methodTimeInfo, level + 1)) <= maxExecTime) continue;
            maxExecTime = execTime;
        }
        return maxExecTime;
    }

    private String generateKey(String className, String methodName, String methodDescriptor) {
        return className + methodName + methodDescriptor;
    }
}

