/*
 * Decompiled with CFR 0.152.
 */
package com.hyperion.methodmonitor.business;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.hyperion.methodmonitor.business.MethodTimeInfo;
import com.hyperion.methodmonitor.business.R;
import com.hyperion.methodmonitor.business.Utils;
import java.util.ArrayList;
import java.util.List;

public class MethodTimeAdapter
extends RecyclerView.Adapter {
    private static final int TYPE_PACKAGE = 1;
    private static final int TYPE_CLASS = 2;
    private Context mContext;
    private List<MethodTimeInfo> mMethodTimeInfos = new ArrayList<MethodTimeInfo>();
    private OnOperateCallback mOnOperateCallback;

    public MethodTimeAdapter(Context mContext) {
        this.mContext = mContext;
    }

    public void setMethodTimeInfos(List<MethodTimeInfo> mMethodTimeInfos) {
        if (mMethodTimeInfos == null) {
            mMethodTimeInfos = new ArrayList<MethodTimeInfo>();
        }
        this.mMethodTimeInfos.clear();
        this.mMethodTimeInfos.addAll(mMethodTimeInfos);
        this.notifyDataSetChanged();
    }

    public void setOnOperateCallback(OnOperateCallback mOnOperateCallback) {
        this.mOnOperateCallback = mOnOperateCallback;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_package, parent, false);
            return new PackageHolder(itemView);
        }
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_class, parent, false);
        return new ClassHolder(itemView);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        final MethodTimeInfo methodTimeInfo = this.mMethodTimeInfos.get(position);
        if (holder instanceof PackageHolder) {
            PackageHolder packageHolder = (PackageHolder)holder;
            packageHolder.mNameView.setText((CharSequence)methodTimeInfo.mPackagePartName);
            packageHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TextUtils.equals((CharSequence)"..", (CharSequence)methodTimeInfo.mPackagePartName)) {
                        if (MethodTimeAdapter.this.mOnOperateCallback != null) {
                            MethodTimeAdapter.this.mOnOperateCallback.onBack();
                        }
                    } else if (MethodTimeAdapter.this.mOnOperateCallback != null) {
                        MethodTimeAdapter.this.mOnOperateCallback.onNext(methodTimeInfo);
                    }
                }
            });
        } else if (holder instanceof ClassHolder) {
            ClassHolder classHolder = (ClassHolder)holder;
            classHolder.mNameView.setText((CharSequence)methodTimeInfo.mClassName);
            classHolder.mMethodView.setText((CharSequence)(methodTimeInfo.mMethodName + methodTimeInfo.mMethodDesc));
            classHolder.mStartView.setText((CharSequence)String.format(this.mContext.getString(R.string.method_time_start_time), Utils.format(methodTimeInfo.mStartTime)));
            classHolder.mDurationView.setText((CharSequence)String.format(this.mContext.getString(R.string.method_time_duration_time), String.valueOf(methodTimeInfo.mStopTime - methodTimeInfo.mStartTime)));
        }
    }

    public int getItemCount() {
        return this.mMethodTimeInfos.size();
    }

    public int getItemViewType(int position) {
        MethodTimeInfo methodTimeInfo = this.mMethodTimeInfos.get(position);
        if (!TextUtils.isEmpty((CharSequence)methodTimeInfo.mPackagePartName)) {
            return 1;
        }
        return 2;
    }

    public static interface OnOperateCallback {
        public void onBack();

        public void onNext(MethodTimeInfo var1);
    }

    public class ClassHolder
    extends RecyclerView.ViewHolder {
        TextView mNameView;
        TextView mMethodView;
        TextView mStartView;
        TextView mDurationView;

        ClassHolder(View itemView) {
            super(itemView);
            this.mNameView = (TextView)itemView.findViewById(R.id.tv_class);
            this.mMethodView = (TextView)itemView.findViewById(R.id.tv_method);
            this.mStartView = (TextView)itemView.findViewById(R.id.tv_start_time);
            this.mDurationView = (TextView)itemView.findViewById(R.id.tv_duration);
        }
    }

    static class PackageHolder
    extends RecyclerView.ViewHolder {
        TextView mNameView;

        PackageHolder(View itemView) {
            super(itemView);
            this.mNameView = (TextView)itemView.findViewById(R.id.tv_name);
        }
    }
}

