/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc.util;

import com.hurence.opc.ConnectionProfile;
import com.hurence.opc.ConnectionState;
import com.hurence.opc.OpcObjectInfo;
import com.hurence.opc.OpcOperations;
import com.hurence.opc.OpcSession;
import com.hurence.opc.OpcTagInfo;
import com.hurence.opc.SessionProfile;
import com.hurence.opc.util.SingleThreadedExecutorServiceFactory;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoReconnectOpcOperations<S extends ConnectionProfile<S>, T extends SessionProfile<T>, U extends OpcSession>
implements OpcOperations<S, T, U> {
    private static final Logger logger = LoggerFactory.getLogger(AutoReconnectOpcOperations.class);
    private ExecutorService executorService;
    private volatile boolean shouldKeepAlive = false;
    private final OpcOperations<S, T, U> delegate;

    public static <O extends OpcOperations> O create(O delegate) {
        AutoReconnectOpcOperations toProxy = new AutoReconnectOpcOperations(delegate);
        return (O)((OpcOperations)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), delegate.getClass().getInterfaces(), (proxy, method, args) -> {
            try {
                return toProxy.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)toProxy, args);
            }
            catch (NoSuchMethodException e) {
                return delegate.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)delegate, args);
            }
        }));
    }

    private AutoReconnectOpcOperations(OpcOperations<S, T, U> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void connect(S connectionProfile) {
        this.delegate.connect(connectionProfile);
        if (this.executorService == null) {
            this.executorService = SingleThreadedExecutorServiceFactory.instance().createScheduler();
            this.shouldKeepAlive = true;
            this.executorService.execute(() -> {
                while (this.shouldKeepAlive) {
                    if (this.getConnectionState() == ConnectionState.CONNECTED) {
                        this.awaitDisconnected();
                    }
                    if (this.shouldKeepAlive) {
                        logger.info("Detected disconnection. Triggering reconnection");
                        try {
                            this.connect(connectionProfile);
                            this.awaitConnected();
                            continue;
                        }
                        catch (Exception e) {
                            logger.warn("Error while reconnecting. Retrying in 1 second", (Throwable)e);
                            try {
                                Thread.sleep(1000L);
                                continue;
                            }
                            catch (InterruptedException ie) {
                                break;
                            }
                        }
                    }
                    logger.info("Connection keepalive done since user asked for disconnection.");
                    break;
                }
            });
        }
    }

    @Override
    public void disconnect() {
        this.shouldKeepAlive = false;
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        this.delegate.disconnect();
    }

    @Override
    public Collection<OpcTagInfo> fetchMetadata(String ... tagIds) {
        return this.delegate.fetchMetadata(tagIds);
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.delegate.getConnectionState();
    }

    @Override
    public Collection<OpcTagInfo> browseTags() {
        return this.delegate.browseTags();
    }

    @Override
    public Collection<OpcObjectInfo> fetchNextTreeLevel(String rootTagId) {
        return this.delegate.fetchNextTreeLevel(rootTagId);
    }

    @Override
    public U createSession(T sessionProfile) {
        return this.delegate.createSession(sessionProfile);
    }

    @Override
    public void releaseSession(U session) {
        this.delegate.releaseSession(session);
    }

    @Override
    public boolean awaitConnected() {
        return this.delegate.awaitConnected();
    }

    @Override
    public boolean awaitDisconnected() {
        return this.delegate.awaitDisconnected();
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    @Override
    public boolean isChannelSecured() {
        return this.delegate.isChannelSecured();
    }
}

