/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc.ua;

import com.hurence.opc.exception.OpcException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaVariantMarshaller {
    private static final Logger logger = LoggerFactory.getLogger(UaVariantMarshaller.class);

    public static Optional<Class<?>> findJavaClass(OpcUaClient client, NodeId node) {
        if (node == null || node.expanded() == null) {
            throw new OpcException("Impossible to guess type from empty node");
        }
        try {
            Object value;
            VariableNode vn = client.getAddressSpace().createVariableNode(node);
            Integer valueRank = (Integer)vn.getValueRank().get();
            boolean isArray = -1 != valueRank;
            Class cls = null;
            NodeId dataType = (NodeId)((CompletableFuture)vn.getDataType().exceptionally(e -> null)).get();
            if (dataType != null) {
                cls = TypeUtil.getBackingClass((ExpandedNodeId)dataType.expanded());
            }
            if (cls == null && (value = ((CompletableFuture)vn.getValue().exceptionally(e -> null)).get()) instanceof Integer) {
                cls = Integer.class;
            }
            if (cls != null) {
                if (cls.equals(UInteger.class)) {
                    cls = Long.class;
                } else if (cls.equals(UByte.class)) {
                    cls = Short.class;
                } else if (cls.equals(UShort.class)) {
                    cls = Integer.class;
                } else if (cls.equals(ULong.class)) {
                    cls = BigInteger.class;
                } else if (cls.equals(DateTime.class)) {
                    cls = Long.class;
                } else if (cls.equals(UUID.class)) {
                    cls = String.class;
                } else if (cls.equals(Number.class)) {
                    cls = Long.class;
                } else if (cls.equals(ByteString.class)) {
                    cls = byte[].class;
                } else if (cls.equals(XmlElement.class)) {
                    cls = String.class;
                } else if (cls.equals(NodeId.class)) {
                    cls = String.class;
                } else if (cls.equals(ExpandedNodeId.class)) {
                    cls = String.class;
                } else if (cls.equals(StatusCode.class)) {
                    cls = Long.class;
                } else if (cls.equals(QualifiedName.class)) {
                    cls = String.class;
                } else if (cls.equals(LocalizedText.class)) {
                    cls = String.class;
                } else if (cls.equals(ExtensionObject.class)) {
                    cls = Object.class;
                } else if (cls.equals(DataValue.class)) {
                    cls = Object.class;
                } else if (cls.equals(Variant.class)) {
                    cls = Object.class;
                }
            }
            if (cls != null) {
                return Optional.of(isArray ? Array.newInstance(cls, 0).getClass() : cls);
            }
        }
        catch (Exception e2) {
            logger.warn("Unable to map opc-ua type to java.", (Throwable)e2);
        }
        return Optional.empty();
    }

    private static Object convert(Object src, Function<Object, Object> function) {
        boolean isArray = src.getClass().isArray();
        if (isArray) {
            return Arrays.stream((Object[])src).map(function).toArray();
        }
        return function.apply(src);
    }

    public static Object toJavaType(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> cls = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
        try {
            if (cls.equals(UInteger.class)) {
                return UaVariantMarshaller.convert(value, a -> ((UInteger)a).longValue());
            }
            if (cls.equals(UByte.class)) {
                return UaVariantMarshaller.convert(value, a -> ((UByte)a).shortValue());
            }
            if (cls.equals(UShort.class)) {
                return UaVariantMarshaller.convert(value, a -> ((UShort)a).intValue());
            }
            if (cls.equals(ULong.class)) {
                return UaVariantMarshaller.convert(value, a -> ((ULong)a).toBigInteger());
            }
            if (cls.equals(DateTime.class)) {
                return UaVariantMarshaller.convert(value, a -> ((DateTime)a).getUtcTime());
            }
            if (cls.equals(UUID.class)) {
                return UaVariantMarshaller.convert(value, a -> ((UUID)a).toString());
            }
            if (cls.equals(Number.class)) {
                return UaVariantMarshaller.convert(value, a -> ((Number)a).longValue());
            }
            if (cls.equals(ByteString.class)) {
                return UaVariantMarshaller.convert(value, a -> ((ByteString)a).bytes());
            }
            if (cls.equals(XmlElement.class)) {
                return UaVariantMarshaller.convert(value, a -> ((XmlElement)a).toString());
            }
            if (cls.equals(NodeId.class)) {
                return UaVariantMarshaller.convert(value, a -> ((NodeId)a).toParseableString());
            }
            if (cls.equals(ExpandedNodeId.class)) {
                return UaVariantMarshaller.convert(value, a -> ((ExpandedNodeId)a).toParseableString());
            }
            if (cls.equals(StatusCode.class)) {
                return UaVariantMarshaller.convert(value, a -> ((StatusCode)a).getValue());
            }
            if (cls.equals(QualifiedName.class)) {
                return UaVariantMarshaller.convert(value, a -> ((QualifiedName)a).toParseableString());
            }
            if (cls.equals(LocalizedText.class)) {
                return UaVariantMarshaller.convert(value, a -> ((LocalizedText)a).getText());
            }
            if (cls.equals(ExtensionObject.class)) {
                return UaVariantMarshaller.convert(value, a -> ((ExtensionObject)a).decode());
            }
            if (cls.equals(DataValue.class)) {
                return UaVariantMarshaller.convert(value, a -> UaVariantMarshaller.toJavaType(((DataValue)a).getValue()));
            }
            if (cls.equals(Variant.class)) {
                return UaVariantMarshaller.convert(value, a -> UaVariantMarshaller.toJavaType(((Variant)a).getValue()));
            }
        }
        catch (Exception e) {
            logger.warn("Unable to map value " + value + " to java type", (Throwable)e);
        }
        return value;
    }
}

