/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc.ua;

import com.hurence.opc.AbstractOpcOperations;
import com.hurence.opc.ConnectionState;
import com.hurence.opc.OpcContainerInfo;
import com.hurence.opc.OpcObjectInfo;
import com.hurence.opc.OpcTagInfo;
import com.hurence.opc.OpcTagProperty;
import com.hurence.opc.auth.Credentials;
import com.hurence.opc.auth.UsernamePasswordCredentials;
import com.hurence.opc.auth.X509Credentials;
import com.hurence.opc.exception.OpcException;
import com.hurence.opc.ua.OpcUaConnectionProfile;
import com.hurence.opc.ua.OpcUaOperations;
import com.hurence.opc.ua.OpcUaSession;
import com.hurence.opc.ua.OpcUaSessionProfile;
import com.hurence.opc.ua.UaVariantMarshaller;
import com.hurence.opc.util.ExecutorServiceFactory;
import com.hurence.opc.util.SingleThreadedExecutorServiceFactory;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.UsernameProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.X509IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.nodes.Node;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableNode;
import org.eclipse.milo.opcua.sdk.client.api.nodes.VariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.ServerNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.ServerStatusNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.CryptoRestrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaTemplate
extends AbstractOpcOperations<OpcUaConnectionProfile, OpcUaSessionProfile, OpcUaSession>
implements OpcUaOperations {
    private static final Logger logger = LoggerFactory.getLogger(OpcUaTemplate.class);
    private final Set<OpcUaSession> sessions = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private OpcUaClient client;
    private ScheduledExecutorService scheduler;

    public OpcUaTemplate(ExecutorServiceFactory executorServiceFactory) {
        super(executorServiceFactory);
    }

    public OpcUaTemplate() {
        this(SingleThreadedExecutorServiceFactory.instance());
    }

    private synchronized void checkAlive() {
        ConnectionState connectionState = this.getConnectionState();
        if (this.client != null && (connectionState == ConnectionState.CONNECTING || connectionState == ConnectionState.CONNECTED)) {
            boolean inError = false;
            try {
                ServerState serverState = (ServerState)((CompletableFuture)((CompletableFuture)this.client.getAddressSpace().getObjectNode(Identifiers.Server, ServerNode.class).thenCompose(ServerNode::getServerStatusNode)).thenCompose(ServerStatusNode::getState)).get();
                if (serverState == null || !ServerState.Running.equals((Object)serverState)) {
                    logger.warn("Server is no more running but rather is in state {}", (Object)serverState);
                    inError = true;
                }
            }
            catch (Exception e) {
                logger.error("Unable to read server state. Marking as disconnected", (Throwable)e);
                inError = true;
            }
            if (inError) {
                this.disconnect();
            } else {
                this.getStateAndSet(Optional.of(ConnectionState.CONNECTED));
            }
        }
    }

    private OpcUaClientConfigBuilder clientConfig(OpcUaConnectionProfile connectionProfile) {
        OpcUaClientConfigBuilder ret = new OpcUaClientConfigBuilder().setApplicationName(LocalizedText.english((String)connectionProfile.getClientName())).setApplicationUri(connectionProfile.getClientIdUri()).setEndpoint(this.findMatchingEndpoint(this.discoverEndpoints(connectionProfile.getConnectionUri().toString(), Optional.ofNullable(connectionProfile.getSocketTimeout())), connectionProfile.getSecureChannelEncryption() != null ? null : SecurityPolicy.None).orElseThrow(() -> new OpcException("Unable to find a matching endpoint. Please check server requirements"))).setIdentityProvider(this.resolveIdentityProvider(connectionProfile.getCredentials()).orElseThrow(() -> new OpcException("Unrecognised Credentials " + connectionProfile.getCredentials())));
        if (connectionProfile.getSocketTimeout() != null) {
            ret.setRequestTimeout(UInteger.valueOf((long)connectionProfile.getSocketTimeout().toMillis()));
        }
        if (connectionProfile.getSecureChannelEncryption() != null) {
            X509Credentials x509 = connectionProfile.getSecureChannelEncryption();
            ret.setCertificate(x509.getCertificate());
            ret.setKeyPair(new KeyPair(x509.getCertificate().getPublicKey(), x509.getPrivateKey()));
        }
        return ret;
    }

    private Optional<IdentityProvider> resolveIdentityProvider(Credentials credentials) {
        AnonymousProvider ret = null;
        if (credentials == null || credentials == Credentials.ANONYMOUS_CREDENTIALS) {
            ret = new AnonymousProvider();
        } else if (credentials instanceof UsernamePasswordCredentials) {
            ret = new UsernameProvider(((UsernamePasswordCredentials)credentials).getUser(), ((UsernamePasswordCredentials)credentials).getPassword());
        } else if (credentials instanceof X509Credentials) {
            ret = new X509IdentityProvider(((X509Credentials)credentials).getCertificate(), ((X509Credentials)credentials).getPrivateKey());
        }
        return Optional.ofNullable(ret);
    }

    private Optional<EndpointDescription> findMatchingEndpoint(Collection<EndpointDescription> endpoints, SecurityPolicy targetPolicy) {
        return endpoints.stream().filter(endpoint -> targetPolicy == null || targetPolicy.equals(SecurityPolicy.fromUriSafe((String)endpoint.getSecurityPolicyUri()).orElse(null))).sorted(Comparator.comparing(EndpointDescription::getSecurityLevel).reversed()).findFirst();
    }

    private Collection<EndpointDescription> discoverEndpoints(String serverUrl, Optional<Duration> timeout) {
        List<EndpointDescription> ret = Collections.emptyList();
        try {
            logger.info("Discovering OCP-UA endpoints from {}", (Object)serverUrl);
            EndpointDescription[] response = (EndpointDescription[])UaTcpStackClient.getEndpoints((String)serverUrl).get(timeout.orElse(Duration.ofSeconds(30L)).toMillis(), TimeUnit.MILLISECONDS);
            if (response == null || response.length == 0) {
                logger.warn("Received empty endpoint descriptions from {}", (Object)serverUrl);
            } else {
                logger.warn("Received {} endpoint descriptions from {}", (Object)response.length, (Object)serverUrl);
                ret = Arrays.asList(response);
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error while discovering OPC-UA endpoints from " + serverUrl, (Throwable)e);
        }
        return ret;
    }

    private String beautifyEndpoint(EndpointDescription endpointDescription) {
        X509Certificate serverCertificate = null;
        if (endpointDescription.getServerCertificate().isNotNull()) {
            try {
                serverCertificate = CertificateUtil.decodeCertificate((byte[])endpointDescription.getServerCertificate().bytes());
            }
            catch (UaException e) {
                logger.warn("Unable to decode server certificate", (Throwable)e);
            }
        }
        return String.format("Server: %s\nUrl: %s\nSecurity policy: %s\nServer identity: %s", endpointDescription.getServer(), endpointDescription.getEndpointUrl(), endpointDescription.getSecurityPolicyUri(), serverCertificate);
    }

    @Override
    public boolean isChannelSecured() {
        if (this.client == null || !this.getConnectionState().equals((Object)ConnectionState.CONNECTED)) {
            throw new OpcException("Cannot state security on non established link. Please connect first");
        }
        if (this.client.getStackClient().getEndpoint().isPresent()) {
            return !SecurityPolicy.None.equals(SecurityPolicy.fromUriSafe((String)((EndpointDescription)this.client.getStackClient().getEndpoint().get()).getSecurityPolicyUri()).orElse(null));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(OpcUaConnectionProfile connectionProfile) {
        if (connectionProfile == null || connectionProfile.getCredentials() == null || connectionProfile.getConnectionUri() == null) {
            throw new OpcException("Please provide any valid non null connection profile with valid credentials");
        }
        ConnectionState cs = this.getConnectionState();
        if (cs != ConnectionState.DISCONNECTED) {
            throw new OpcException("There is already an active connection. Please disconnect first");
        }
        try {
            this.getStateAndSet(Optional.of(ConnectionState.CONNECTING));
            OpcUaClientConfig config = this.clientConfig(connectionProfile).build();
            logger.info("Connecting to OPC-UA endpoint\n{}", (Object)this.beautifyEndpoint((EndpointDescription)config.getEndpoint().get()));
            this.client = new OpcUaClient(config);
            this.client.connect().get(this.client.getConfig().getRequestTimeout().longValue(), TimeUnit.MILLISECONDS);
            this.scheduler = this.executorServiceFactory.createScheduler();
            this.scheduler.scheduleWithFixedDelay(this::checkAlive, 0L, connectionProfile.getKeepAliveInterval().toNanos(), TimeUnit.NANOSECONDS);
            this.getStateAndSet(Optional.of(ConnectionState.CONNECTED));
        }
        catch (Exception e) {
            try {
                this.disconnect();
            }
            finally {
                throw new OpcException("Unexpected exception occurred while connecting", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() {
        try {
            while (!this.sessions.isEmpty()) {
                try {
                    OpcUaSession session = this.sessions.stream().findFirst().orElse(null);
                    if (session == null) continue;
                    this.sessions.remove(session);
                    session.close();
                }
                catch (Exception e) {
                    logger.warn("Unable to properly close a session", (Throwable)e);
                }
            }
            this.getStateAndSet(Optional.of(ConnectionState.DISCONNECTING));
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
            if (this.client == null) return;
            this.client.getSubscriptionManager().clearSubscriptions();
            this.client.disconnect().get(this.client.getConfig().getRequestTimeout().longValue(), TimeUnit.MILLISECONDS);
            return;
        }
        catch (Exception e) {
            throw new OpcException("Unable to properly disconnect", e);
        }
        finally {
            this.getStateAndSet(Optional.of(ConnectionState.DISCONNECTED));
            this.scheduler = null;
            this.client = null;
        }
    }

    @Override
    public Collection<OpcTagInfo> fetchMetadata(String ... tagIds) {
        ArrayList<OpcTagInfo> ret = new ArrayList<OpcTagInfo>();
        for (String t : tagIds) {
            try {
                NodeId target = NodeId.parse((String)t);
                Node node = (Node)this.client.getAddressSpace().createNode(target).get();
                if (!(node instanceof VariableNode)) {
                    throw new IllegalArgumentException("Tag " + t + " is not a Variable node");
                }
                ArrayList<OpcTagInfo> tmp = new ArrayList<OpcTagInfo>();
                this.browse((NodeId)node.getNodeId().get(), null, tmp);
                if (tmp.isEmpty()) continue;
                ret.add((OpcTagInfo)tmp.get(0));
            }
            catch (Exception e) {
                throw new OpcException("Unable to fetch metadata for tag " + t, e);
            }
        }
        return ret;
    }

    private void browse(NodeId root, OpcTagInfo prevTagInfo, Collection<OpcTagInfo> result) throws Exception {
        List nodes;
        Node n;
        try {
            n = (Node)this.client.getAddressSpace().createNode(root).get();
        }
        catch (Exception e2) {
            logger.warn("Unable to read after tag {} : {}", (Object)prevTagInfo, (Object)e2.getMessage());
            return;
        }
        OpcTagInfo currentTagInfo = null;
        if (n != null && n instanceof VariableNode) {
            VariableTypeNode vtn;
            UaVariableNode vn = (UaVariableNode)n;
            NodeId nodeId = (NodeId)vn.getNodeId().get();
            try {
                vtn = (VariableTypeNode)vn.getTypeDefinition().get();
            }
            catch (Exception e3) {
                logger.warn("Unable to resolve property type for {}. Defaulting to BaseDataVariableType", (Object)nodeId);
                vtn = this.client.getAddressSpace().createVariableTypeNode(Identifiers.BaseDataVariableType);
            }
            if (prevTagInfo != null && Identifiers.PropertyType.equals(vtn.getNodeId().get())) {
                OpcTagInfo info = this.fillOpcTagInformation(new OpcTagInfo(nodeId.toParseableString()), (VariableNode)vn);
                prevTagInfo.addProperty(new OpcTagProperty(info.getId(), info.getDescription().orElse(info.getName()), ((CompletableFuture)((CompletableFuture)vn.getValue().exceptionally(e -> null)).thenApply(UaVariantMarshaller::toJavaType)).get()));
            } else {
                Optional<Class<?>> cls = UaVariantMarshaller.findJavaClass(this.client, (NodeId)n.getNodeId().get());
                if (cls.isPresent()) {
                    currentTagInfo = ((OpcTagInfo)new OpcTagInfo(nodeId.toParseableString()).withName(((QualifiedName)n.getBrowseName().get()).getName())).withType(cls.get());
                    result.add(this.fillOpcTagInformation(currentTagInfo, (VariableNode)vn));
                }
            }
        }
        if ((nodes = (List)this.client.getAddressSpace().browse(root).get()) != null && !nodes.isEmpty()) {
            for (Node child : nodes) {
                this.browse((NodeId)child.getNodeId().get(), currentTagInfo, result);
            }
        }
    }

    @Override
    public Collection<OpcObjectInfo> fetchNextTreeLevel(String rootTagId) {
        try {
            Map results = Arrays.stream(((BrowseResult)this.client.browse(new BrowseDescription(NodeId.parse((String)rootTagId), BrowseDirection.Forward, Identifiers.HierarchicalReferences, Boolean.valueOf(true), UInteger.valueOf((int)(NodeClass.Object.getValue() | NodeClass.Variable.getValue())), UInteger.valueOf((int)BrowseResultMask.All.getValue()))).get()).getReferences()).filter(referenceDescription -> referenceDescription.getNodeId().local().isPresent()).collect(Collectors.toMap(referenceDescription -> (NodeId)referenceDescription.getNodeId().local().get(), Function.identity(), (k1, k2) -> k1, LinkedHashMap::new));
            return results.values().stream().filter(referenceDescription -> !referenceDescription.getTypeDefinition().isLocal() || !((NodeId)referenceDescription.getTypeDefinition().local().get()).equals((Object)Identifiers.PropertyType)).map(referenceDescription -> ((OpcObjectInfo)(NodeClass.Object.equals((Object)referenceDescription.getNodeClass()) ? new OpcContainerInfo(((NodeId)referenceDescription.getNodeId().local().get()).toParseableString()) : new OpcTagInfo(((NodeId)referenceDescription.getNodeId().local().get()).toParseableString())).withDescription(referenceDescription.getDisplayName().getText())).withName(referenceDescription.getBrowseName().getName())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new OpcException("Unable to browse OPC address space", e);
        }
    }

    @Override
    public Collection<OpcTagInfo> browseTags() {
        LinkedHashSet<OpcTagInfo> ret = new LinkedHashSet<OpcTagInfo>();
        try {
            this.browse(Identifiers.RootFolder, null, ret);
        }
        catch (Exception e) {
            throw new OpcException("Unable to browse tags", e);
        }
        return ret;
    }

    private OpcTagInfo fillOpcTagInformation(OpcTagInfo info, VariableNode vn) {
        try {
            CompletableFuture.allOf(new CompletableFuture[]{((CompletableFuture)vn.readMinimumSamplingInterval().exceptionally(e -> null)).whenCompleteAsync((raw, e) -> {
                Number d = (Number)UaVariantMarshaller.toJavaType(raw);
                info.setScanRate(Optional.ofNullable(d != null && d.doubleValue() > 0.0 ? Duration.ofNanos(Math.round(d.doubleValue() * 1000000.0)) : null));
                if (d != null) {
                    info.addProperty(new OpcTagProperty<Number>(Integer.toString(AttributeId.MinimumSamplingInterval.id()), AttributeId.MinimumSamplingInterval.toString(), d));
                }
            }), ((CompletableFuture)vn.getHistorizing().exceptionally(e -> null)).whenCompleteAsync((historizing, e) -> info.addProperty(new OpcTagProperty<Boolean>(Integer.toString(AttributeId.Historizing.id()), AttributeId.Historizing.toString(), historizing == null ? false : historizing))), ((CompletableFuture)vn.getDescription().exceptionally(e -> null)).whenCompleteAsync((description, e1) -> {
                try {
                    LocalizedText displayName = (LocalizedText)((CompletableFuture)vn.getDescription().exceptionally(e -> null)).get();
                    String toSet = null;
                    if (description != null && description.getText() != null) {
                        toSet = description.getText();
                        info.addProperty(new OpcTagProperty<String>(Integer.toString(AttributeId.Description.id()), AttributeId.Description.toString(), description.getText()));
                    }
                    if (displayName != null && displayName.getText() != null) {
                        info.addProperty(new OpcTagProperty<String>(Integer.toString(AttributeId.DisplayName.id()), AttributeId.DisplayName.toString(), displayName.getText()));
                        if (toSet == null) {
                            toSet = displayName.getText();
                        }
                    }
                    info.setDescription(Optional.ofNullable(toSet));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }), ((CompletableFuture)vn.getUserAccessLevel().exceptionally(e -> null)).whenCompleteAsync((accessLevel, e) -> {
                if (accessLevel != null) {
                    EnumSet levels = AccessLevel.fromMask((UByte)accessLevel);
                    info.withReadAccessRights(levels.contains(AccessLevel.CurrentRead));
                    info.withWriteAccessRights(levels.contains(AccessLevel.CurrentWrite));
                    info.addProperty(new OpcTagProperty<Integer>(Integer.toString(AttributeId.UserAccessLevel.id()), AttributeId.UserAccessLevel.toString(), accessLevel.intValue()));
                }
            })}).get();
        }
        catch (Exception e2) {
            logger.warn("Unable to properly fill information for tag " + vn, (Throwable)e2);
        }
        return info;
    }

    @Override
    public OpcUaSession createSession(OpcUaSessionProfile sessionProfile) {
        OpcUaSession ret = OpcUaSession.create(this, this.client, sessionProfile);
        this.sessions.add(ret);
        return ret;
    }

    @Override
    public void releaseSession(OpcUaSession session) {
        if (this.getConnectionState() == ConnectionState.CONNECTED && session != null) {
            this.sessions.remove(session);
            session.cleanup();
        }
    }

    @Override
    public void close() throws Exception {
        this.disconnect();
    }

    static {
        CryptoRestrictions.remove();
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

