/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc.ua;

import com.hurence.opc.OperationStatus;
import com.hurence.opc.Quality;
import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.StatusCodes;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class OpcUaQualityExtractor {
    public static final Quality quality(StatusCode statusCode) {
        Quality ret = Quality.Unknown;
        if (statusCode.isGood()) {
            ret = Quality.Good;
        } else if (statusCode.isUncertain() || statusCode.isOverflowSet()) {
            ret = Quality.Uncertain;
        } else if (statusCode.isBad()) {
            ret = Quality.Bad;
        }
        return ret;
    }

    public static final OperationStatus operationStatus(StatusCode statusCode) {
        OperationStatus.Level level = OperationStatus.Level.WARNING;
        if (statusCode.isBad()) {
            level = OperationStatus.Level.ERROR;
        } else if (statusCode.isGood()) {
            level = OperationStatus.Level.INFO;
        }
        Optional lookup = StatusCodes.lookup((long)statusCode.getValue());
        return new OperationStatus(level, statusCode.getValue(), Optional.ofNullable(lookup.orElseGet(() -> new String[2])[1]));
    }
}

