/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc.da;

import com.hurence.opc.AbstractOpcOperations;
import com.hurence.opc.ConnectionState;
import com.hurence.opc.OpcContainerInfo;
import com.hurence.opc.OpcObjectInfo;
import com.hurence.opc.OpcTagInfo;
import com.hurence.opc.OpcTagProperty;
import com.hurence.opc.auth.Credentials;
import com.hurence.opc.auth.NtlmCredentials;
import com.hurence.opc.da.JIVariantMarshaller;
import com.hurence.opc.da.OpcDaConnectionProfile;
import com.hurence.opc.da.OpcDaOperations;
import com.hurence.opc.da.OpcDaSession;
import com.hurence.opc.da.OpcDaSessionProfile;
import com.hurence.opc.exception.OpcException;
import com.hurence.opc.util.ExecutorServiceFactory;
import com.hurence.opc.util.SingleThreadedExecutorServiceFactory;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIClsid;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIVariant;
import org.openscada.opc.dcom.common.KeyedResult;
import org.openscada.opc.dcom.common.KeyedResultSet;
import org.openscada.opc.dcom.common.impl.EnumString;
import org.openscada.opc.dcom.da.OPCBROWSEDIRECTION;
import org.openscada.opc.dcom.da.OPCBROWSETYPE;
import org.openscada.opc.dcom.da.OPCSERVERSTATE;
import org.openscada.opc.dcom.da.OPCSERVERSTATUS;
import org.openscada.opc.dcom.da.PropertyDescription;
import org.openscada.opc.dcom.da.impl.OPCItemProperties;
import org.openscada.opc.dcom.da.impl.OPCServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcDaTemplate
extends AbstractOpcOperations<OpcDaConnectionProfile, OpcDaSessionProfile, OpcDaSession>
implements OpcDaOperations {
    private static final Logger logger;
    private JISession session;
    private JIComServer comServer;
    private OPCServer opcServer;
    private OPCItemProperties opcItemProperties;
    private ScheduledExecutorService scheduler = null;
    private final Set<OpcDaSession> sessions = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    public OpcDaTemplate(ExecutorServiceFactory executorServiceFactory) {
        super(executorServiceFactory);
    }

    public OpcDaTemplate() {
        this(SingleThreadedExecutorServiceFactory.instance());
    }

    private synchronized void checkAlive() {
        ConnectionState connectionState = this.getConnectionState();
        if (this.opcServer != null && (connectionState == ConnectionState.CONNECTING || connectionState == ConnectionState.CONNECTED)) {
            boolean inError = false;
            try {
                OPCSERVERSTATUS status = this.opcServer.getStatus();
                if (status == null || status.getServerState() == null || !status.getServerState().equals((Object)OPCSERVERSTATE.OPC_STATUS_RUNNING)) {
                    logger.warn("Server is no more running but rather is in state {}", (Object)(status != null ? status.getServerState() : null));
                    inError = true;
                }
            }
            catch (JIException e) {
                logger.error("Unable to read server state. Marking as disconnected", (Throwable)e);
                inError = true;
            }
            if (inError) {
                this.disconnect();
            } else {
                this.getStateAndSet(Optional.of(ConnectionState.CONNECTED));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(OpcDaConnectionProfile connectionProfile) {
        if (connectionProfile == null || connectionProfile.getConnectionUri() == null) {
            throw new OpcException("Please provide any valid non null connection profile");
        }
        Credentials credentials = connectionProfile.getCredentials();
        if (credentials != null && !(credentials instanceof NtlmCredentials)) {
            throw new OpcException("Credentials " + credentials.getClass().getCanonicalName() + " is not supported by OPC-DA connector. Please use " + NtlmCredentials.class.getCanonicalName());
        }
        String username = ((NtlmCredentials)credentials).getUser();
        String password = ((NtlmCredentials)credentials).getPassword();
        String domain = ((NtlmCredentials)credentials).getDomain();
        ConnectionState cs = this.getConnectionState();
        if (cs != ConnectionState.DISCONNECTED) {
            throw new OpcException("There is already an active connection. Please disconnect first");
        }
        try {
            this.getStateAndSet(Optional.of(ConnectionState.CONNECTING));
            String connectionString = connectionProfile.getConnectionUri().getHost();
            if (connectionProfile.getComClsId() != null) {
                this.session = JISession.createSession((String)domain, (String)username, (String)password);
                if (connectionProfile.getSocketTimeout() != null) {
                    this.session.setGlobalSocketTimeout((int)connectionProfile.getSocketTimeout().toMillis());
                }
                this.comServer = new JIComServer(JIClsid.valueOf((String)connectionProfile.getComClsId()), connectionString, this.session);
            } else if (connectionProfile.getComProgId() != null) {
                this.session = JISession.createSession((String)domain, (String)username, (String)password);
                if (connectionProfile.getSocketTimeout() != null) {
                    this.session.setGlobalSocketTimeout((int)connectionProfile.getSocketTimeout().toMillis());
                }
                this.comServer = new JIComServer(JIProgId.valueOf((String)connectionProfile.getComProgId()), connectionString, this.session);
            } else {
                throw new IllegalArgumentException("Neither clsid nor progid is valid!");
            }
            this.opcServer = new OPCServer(this.comServer.createInstance());
            this.opcItemProperties = this.opcServer.getItemPropertiesService();
            this.scheduler = this.executorServiceFactory.createScheduler();
            this.scheduler.scheduleWithFixedDelay(this::checkAlive, 0L, connectionProfile.getKeepAliveInterval().toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Exception e) {
            try {
                this.disconnect();
            }
            finally {
                throw new OpcException("Unexpected exception occurred while connecting", e);
            }
        }
    }

    @Override
    public synchronized void disconnect() {
        try {
            this.getStateAndSet(Optional.of(ConnectionState.DISCONNECTING));
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
            this.destroySessions();
        }
        catch (Exception e) {
            throw new OpcException("Unable to properly disconnect", e);
        }
        finally {
            this.cleanup();
            this.getStateAndSet(Optional.of(ConnectionState.DISCONNECTED));
        }
    }

    private void destroySessions() {
        logger.info("Destroying DCOM sessions");
        while (!this.sessions.isEmpty()) {
            try {
                OpcDaSession s = (OpcDaSession)this.sessions.stream().findFirst().get();
                this.sessions.remove(s);
                s.cleanup(this.opcServer);
            }
            catch (Exception e) {
                logger.warn("Group not properly released", (Throwable)e);
            }
        }
        try {
            JISession.destroySession((JISession)this.session);
        }
        catch (Exception e) {
            throw new OpcException("Unable to properly destroy dcom session", e);
        }
    }

    private void cleanup() {
        this.opcItemProperties = null;
        this.comServer = null;
        this.session = null;
        this.opcServer = null;
        this.scheduler = null;
    }

    private String nameFromId(String tag) {
        int idx = tag.lastIndexOf(46);
        if (idx > 0) {
            return tag.substring(idx + 1);
        }
        return tag;
    }

    private String toggleNullTermination(String orig) {
        if (orig.endsWith("\u0000")) {
            return orig.substring(0, orig.length() - 1);
        }
        return orig;
    }

    private String sanitize(String orig) {
        if (orig.endsWith(Character.toString('\u00a5'))) {
            return orig.substring(0, orig.length() - 1);
        }
        return orig;
    }

    private <S, T> T extractFromProperty(OpcTagProperty<S> property, Function<S, T> transformer) {
        if (property != null) {
            return transformer.apply(property.getValue());
        }
        return null;
    }

    @Override
    public Collection<OpcTagInfo> fetchMetadata(String ... tagIds) {
        if (this.getConnectionState() != ConnectionState.CONNECTED) {
            throw new OpcException("Unable to fetch metadata. Not connected!");
        }
        return Arrays.stream(tagIds).map(s -> {
            OpcTagInfo ret;
            try {
                Map properties = this.opcItemProperties.queryAvailableProperties(s).stream().collect(Collectors.toMap(PropertyDescription::getId, Function.identity()));
                ret = (OpcTagInfo)new OpcTagInfo((String)s).withName(this.nameFromId((String)s));
                KeyedResultSet rawProps = this.opcItemProperties.getItemProperties(s, properties.keySet().stream().mapToInt(Integer::intValue).toArray());
                HashMap<Object, OpcTagProperty<Object>> tagProps = new HashMap<Object, OpcTagProperty<Object>>();
                for (KeyedResult result : rawProps) {
                    tagProps.put(result.getKey(), new OpcTagProperty<Object>(((Integer)result.getKey()).toString(), this.toggleNullTermination(((PropertyDescription)properties.get(result.getKey())).getDescription()), JIVariantMarshaller.toJavaType((JIVariant)result.getValue())));
                }
                ret.setProperties(new HashSet<OpcTagProperty>(tagProps.values()));
                if (tagProps.containsKey(1)) {
                    OpcTagProperty tmp = (OpcTagProperty)tagProps.get(1);
                    ret.setType(JIVariantMarshaller.findJavaClass(tmp != null && tmp.getValue() != null ? (int)((Short)tmp.getValue()).shortValue() : 0));
                }
                ret.setScanRate(Optional.ofNullable(this.extractFromProperty((OpcTagProperty)tagProps.get(6), rate -> Duration.ofMillis(Math.round(rate.floatValue())))));
                ret.setDescription(Optional.ofNullable(this.extractFromProperty((OpcTagProperty)tagProps.get(101), Function.identity())));
                Integer accessRightsBits = (Integer)this.extractFromProperty((OpcTagProperty)tagProps.get(5), Function.identity());
                if (accessRightsBits != null) {
                    ret.withWriteAccessRights((accessRightsBits & 2) != 0);
                    ret.withReadAccessRights((accessRightsBits & 1) != 0);
                }
            }
            catch (JIException e) {
                throw new OpcException("Unable to fetch metadata for tag " + s, e);
            }
            return ret;
        }).collect(Collectors.toList());
    }

    private String resolveItemId(String name) {
        try {
            return this.toggleNullTermination(this.sanitize(this.opcServer.getBrowser().getItemID(name)));
        }
        catch (JIException e) {
            throw new OpcException("Unable to resolve ID for item name " + name, e);
        }
    }

    @Override
    public Collection<OpcObjectInfo> fetchNextTreeLevel(String rootTagId) {
        if (this.getConnectionState() != ConnectionState.CONNECTED) {
            throw new OpcException("Unable to fetch tags. Not connected!");
        }
        OPCServer oPCServer = this.opcServer;
        synchronized (oPCServer) {
            try {
                this.opcServer.getBrowser().changePosition(rootTagId, OPCBROWSEDIRECTION.OPC_BROWSE_TO);
                return Stream.concat(this.opcServer.getBrowser().browse(OPCBROWSETYPE.OPC_BRANCH, "", 0, 0).asCollection().stream().map(s -> (OpcContainerInfo)new OpcContainerInfo(this.resolveItemId((String)s)).withName((String)s)), this.opcServer.getBrowser().browse(OPCBROWSETYPE.OPC_LEAF, "", 0, 0).asCollection().stream().map(s -> (OpcTagInfo)new OpcTagInfo(this.resolveItemId((String)s)).withName((String)s))).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new OpcException("Unable to hierarchically browse the access space", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OpcTagInfo> browseTags() {
        if (this.getConnectionState() != ConnectionState.CONNECTED) {
            throw new OpcException("Unable to browse tags. Not connected!");
        }
        OPCServer oPCServer = this.opcServer;
        synchronized (oPCServer) {
            try {
                this.opcServer.getBrowser().changePosition(null, OPCBROWSEDIRECTION.OPC_BROWSE_TO);
                EnumString res = this.opcServer.getBrowser().browse(OPCBROWSETYPE.OPC_FLAT, "", 0, 0);
                if (res != null) {
                    Collection result = res.asCollection();
                    return this.fetchMetadata(result.toArray(new String[result.size()]));
                }
            }
            catch (Exception e) {
                throw new OpcException("Unable to browse tags", e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public OpcDaSession createSession(OpcDaSessionProfile sessionProfile) {
        if (this.getConnectionState() != ConnectionState.CONNECTED) {
            throw new OpcException("Unable to create a session. Not connected!");
        }
        OpcDaSession ret = OpcDaSession.create(this.opcServer, sessionProfile, this);
        this.sessions.add(ret);
        return ret;
    }

    @Override
    public void releaseSession(OpcDaSession session) {
        if (this.getConnectionState() == ConnectionState.CONNECTED && session != null) {
            this.sessions.remove(session);
            session.cleanup(this.opcServer);
        }
    }

    @Override
    public void close() throws Exception {
        this.disconnect();
    }

    static {
        JISystem.setAutoRegisteration((boolean)true);
        JISystem.setJavaCoClassAutoCollection((boolean)false);
        logger = LoggerFactory.getLogger(OpcDaTemplate.class);
    }
}

