/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc.da;

import com.hurence.opc.SessionProfile;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OpcDaSessionProfile
extends SessionProfile<OpcDaSessionProfile> {
    private boolean directRead;
    private Duration refreshInterval = Duration.ofSeconds(1L);
    private Map<String, Short> dataTypeOverrideMap = new HashMap<String, Short>();

    public OpcDaSessionProfile withDataTypeForTag(String tagId, short dataType) {
        this.dataTypeOverrideMap.put(tagId, dataType);
        return this;
    }

    public Optional<Short> dataTypeForTag(String tagId) {
        return Optional.ofNullable(this.dataTypeOverrideMap.get(tagId));
    }

    public Map<String, Short> getDataTypeOverrideMap() {
        return Collections.unmodifiableMap(this.dataTypeOverrideMap);
    }

    public final Duration getRefreshInterval() {
        return this.refreshInterval;
    }

    public final void setRefreshInterval(Duration refreshInterval) {
        if (refreshInterval == null) {
            throw new IllegalArgumentException("The refresh interval must be any non null valid value.");
        }
        this.refreshInterval = refreshInterval;
    }

    public final OpcDaSessionProfile withRefreshInterval(Duration refreshInterval) {
        this.setRefreshInterval(refreshInterval);
        return this;
    }

    public boolean isDirectRead() {
        return this.directRead;
    }

    public void setDirectRead(boolean directRead) {
        this.directRead = directRead;
    }

    public OpcDaSessionProfile withDirectRead(boolean directRead) {
        this.setDirectRead(directRead);
        return this;
    }

    public String toString() {
        return "OpcDaSessionProfile{directRead=" + this.directRead + ", refreshInterval=" + this.refreshInterval + ", dataTypeOverrideMap=" + this.dataTypeOverrideMap + "} " + super.toString();
    }
}

