/*
 * Decompiled with CFR 0.152.
 */
package com.hurence.opc.da;

import com.hurence.opc.OperationStatus;
import com.hurence.opc.Quality;
import java.util.Optional;
import org.openscada.opc.dcom.common.Result;

public class OpcDaQualityExtractor {
    public static final int OPC_QUALITY_MASK = 192;
    public static final int OPC_STATUS_MASK = 252;
    public static final int OPC_LIMIT_MASK = 3;
    public static final int OPC_QUALITY_UNCERTAIN = 64;
    public static final int OPC_QUALITY_GOOD = 192;
    public static final int OPC_QUALITY_BAD = 0;
    public static final int OPC_QUALITY_CONFIG_ERROR_CODE = 4;
    public static final int OPC_QUALITY_NOT_CONNECTED_ERROR_CODE = 8;
    public static final int OPC_QUALITY_DEVICE_FAILURE_CODE = 12;
    public static final int OPC_QUALITY_SENSOR_FAILURE_CODE = 16;
    public static final int OPC_QUALITY_LAST_KNOWN_CODE = 20;
    public static final int OPC_QUALITY_COMM_FAILURE_CODE = 24;
    public static final int OPC_QUALITY_OUT_OF_SERVICE_CODE = 28;
    public static final int OPC_QUALITY_WAITING_FOR_INITIAL_DATA_CODE = 32;
    public static final int OPC_QUALITY_UNCERTAIN_LAST_USABLE_VALUE_CODE = 68;
    public static final int OPC_QUALITY_SENSOR_CAL_CODE = 80;
    public static final int OPC_QUALITY_EGU_EXCEEDED_CODE = 84;
    public static final int OPC_QUALITY_UNCERTAIN_SUBNORMAL_CODE = 88;
    public static final int OPC_QUALITY_LOCAL_OVERRIDE_CODE = 216;
    public static final String OPC_QUALITY_CONFIG_ERROR_DESC = "There is some server specific problem with the configuration.";
    public static final String OPC_QUALITY_NOT_CONNECTED_ERROR_DESC = "The input is required to be logically connected to something but is not.";
    public static final String OPC_QUALITY_DEVICE_FAILURE_DESC = "A device failure has been detected.";
    public static final String OPC_QUALITY_SENSOR_FAILURE_DESC = "A sensor failure had been detected";
    public static final String OPC_QUALITY_LAST_KNOWN_DESC = "Communications have failed. However, the last known value is available";
    public static final String OPC_QUALITY_COMM_FAILURE_DESC = "Communications have failed. There is no last known value is available.";
    public static final String OPC_QUALITY_OUT_OF_SERVICE_DESC = "The block is off scan or otherwise locked ";
    public static final String OPC_QUALITY_WAITING_FOR_INITIAL_DATA_DESC = "After Items are added to a group, it may take some time for the server to actually obtain values for these items.";
    public static final String OPC_QUALITY_UNCERTAIN_LAST_USABLE_VALUE_DESC = "Whatever was writing this value has stopped doing so. The returned value should be regarded as 'stale'.";
    public static final String OPC_QUALITY_SENSOR_CAL_DESC = "The sensor is known to be out of calibration.";
    public static final String OPC_QUALITY_EGU_EXCEEDED_DESC = "The returned value is outside the limits defined for this parameter";
    public static final String OPC_QUALITY_UNCERTAIN_SUBNORMAL_DESC = "The value is derived from multiple sources and has less than the required number of good sources.";
    public static final String OPC_QUALITY_LOCAL_OVERRIDE_DESC = "The value has been Overridden.";

    public static Quality quality(long value) {
        Quality ret;
        int extracted = (int)value & 0xC0;
        switch (extracted) {
            case 192: {
                ret = Quality.Good;
                break;
            }
            case 64: {
                ret = Quality.Uncertain;
                break;
            }
            case 0: {
                ret = Quality.Bad;
                break;
            }
            default: {
                ret = Quality.Unknown;
            }
        }
        return ret;
    }

    public static OperationStatus operationStatus(Result<?> result) {
        if (result.isFailed()) {
            return OpcDaQualityExtractor.operationStatus(result.getErrorCode());
        }
        return new OperationStatus(OperationStatus.Level.INFO, result.getErrorCode(), Optional.empty());
    }

    public static OperationStatus operationStatus(long value) {
        String desc;
        OperationStatus.Level level;
        switch (OpcDaQualityExtractor.quality(value)) {
            case Good: {
                level = OperationStatus.Level.INFO;
                break;
            }
            case Bad: {
                level = OperationStatus.Level.ERROR;
                break;
            }
            default: {
                level = OperationStatus.Level.WARNING;
            }
        }
        int code = (int)value & 0xFC;
        switch (code) {
            case 4: {
                desc = OPC_QUALITY_CONFIG_ERROR_DESC;
                break;
            }
            case 8: {
                desc = OPC_QUALITY_NOT_CONNECTED_ERROR_DESC;
                break;
            }
            case 12: {
                desc = OPC_QUALITY_DEVICE_FAILURE_DESC;
                break;
            }
            case 16: {
                desc = OPC_QUALITY_SENSOR_FAILURE_DESC;
                break;
            }
            case 20: {
                desc = OPC_QUALITY_LAST_KNOWN_DESC;
                break;
            }
            case 24: {
                desc = OPC_QUALITY_COMM_FAILURE_DESC;
                break;
            }
            case 28: {
                desc = OPC_QUALITY_OUT_OF_SERVICE_DESC;
                break;
            }
            case 32: {
                desc = OPC_QUALITY_WAITING_FOR_INITIAL_DATA_DESC;
                break;
            }
            case 68: {
                desc = OPC_QUALITY_UNCERTAIN_LAST_USABLE_VALUE_DESC;
                break;
            }
            case 80: {
                desc = OPC_QUALITY_SENSOR_CAL_DESC;
                break;
            }
            case 84: {
                desc = OPC_QUALITY_EGU_EXCEEDED_DESC;
                break;
            }
            case 88: {
                desc = OPC_QUALITY_UNCERTAIN_SUBNORMAL_DESC;
                break;
            }
            case 216: {
                desc = OPC_QUALITY_LOCAL_OVERRIDE_DESC;
                break;
            }
            default: {
                desc = null;
            }
        }
        return new OperationStatus(level, code, Optional.ofNullable(desc));
    }
}

